(function(Ext) {
	
	Ext.define('Suncode.datasourcemanager.component.RemovableField', {
		extend: 'Ext.container.Container',
		alias: 'widget.removablefield',
		
		fields: [],
		
		layout: 'hbox',
		
		initComponent: function(){
            var me = this;

            me.items = [];

            if (!Ext.isEmpty(this.fields)) {
                Ext.each(me.fields, function (field) {
                    Ext.apply(field, {
                        flex: 1
                    });
                });
            }

            me.items.push({
                xtype: 'parametersContainer',
                itemId: 'fields-form',
                frame: false,
                border: false,
                layout: 'hbox',
                flex: 1,
                submitValue: false,
                disabled: me.asPlaceholder,
                defaults: {
                    padding: '0 5 0 0',
                    hideLabel: true
                },
                items: Ext.isEmpty(me.fields) ? [] : me.fields
            });

            me.items.push({
                xtype: 'panel',
                frame: false,
                border: false,
                items: [this.generateAddButton(me),
                    this.generateRemoveButton(me),
                    this.generateUpButton(me),
                    this.generateDownButton(me)]
            });
            me.callParent(arguments);
        },

        generateAddButton: function (me) {
            return {
                xtype: 'button',
                itemId: 'add-button',
                iconCls: 'dvnt-icon-plus-circle dvnt-green-icon',
                hideMode: 'visibility',
                handler: function (button) {
                    const container = button.up('fieldcontainer');
                    const field = button.up('removablefield');
                    const formCt = button.up('multivaluefield');
                    if (me.asPlaceholder) {
                        me.down('#fields-form').enable();
                        me.down('#remove-button').show();
                        me.asPlaceholder = false;
                        return;
                    }
                    container.addRow(false, formCt.items.indexOf(field) + 1);
                },
                flex: 0
            }
        },

        generateRemoveButton: function (me) {
            return {
                xtype: 'button',
                itemId: 'remove-button',
                iconCls: 'dvnt-icon-minus-circle dvnt-red-icon',
                hideMode: 'visibility',
                handler: function (button) {
                    const container = button.up('fieldcontainer');
                    container.removeRow(me);
                },
                flex: 0,
                hidden: me.asPlaceholder
            }
        },

        generateUpButton: function (me) {
            return {
                xtype: 'button',
                itemId: 'up-button',
                iconCls: 'dvnt-icon-up',
                hideMode: 'visibility',
                handler: function (button) {
                    const container = button.up('fieldcontainer');
                    container.switchValue(me, true)
                },
                flex: 0,
                hidden: me.asPlaceholder
            }
        },

        generateDownButton: function (me) {
            return {
                xtype: 'button',
                itemId: 'down-button',
                iconCls: 'dvnt-icon-down',
                hideMode: 'visibility',
                handler: function (button) {
                    const container = button.up('fieldcontainer');
                    container.switchValue(me, false)
                },
                flex: 0,
                hidden: me.asPlaceholder
            }
        },

        setAsPlaceholder: function () {
            var parameters = this.down('#fields-form');
            parameters.disable();
            parameters.items.each(function (item) {
                item.setValue('');
            });

            this.down('#remove-button').hide();
            this.asPlaceholder = true;
        },

        _getAddButton: function () {
            return this.down('#add-button');
        },

        showAddButton: function () {
            this._getAddButton().show();
        },

        showUpButton: function () {
            this.down('#up-button').show();
        },

        showDownButton: function () {
            this.down('#down-button').show();
        },

        hideUpButton: function () {
            this.down('#up-button').hide();
        },

        hideDownButton: function () {
            this.down('#down-button').hide();
        },

        setValue: function (value) {
            var me = this;
            if (value) {
                // TODO pobrać po id/name?
                value.eachKey(function (key, value) {
                    var field = me.down('#' + key);
                    if (field) {
                        field.setValue(value.value);
                    }
                });
            }
        },
		getFields: function(){
			return this.down('#fields-form');
		},
		getValue: function( fieldId ) {
		    return this.getFields().items.getByKey( fieldId ).getValue();
		}
	});
	
})(Ext4);