(function(Ext) {
	
	Ext.define('Suncode.datasourcemanager.component.ExtendedDateTimeField', {
		extend: 'Ext.ux.DateTimeField',
		alias: 'widget.extendeddatetimefield',
		
		format: 'Y-m-d H:i:s',
		
		getSubmitValue: function(){
			var me = this,
			submitValue = Ext.ux.DateTimeField.prototype.getSubmitValue.call(me);
			
			if(!Ext.isEmpty(submitValue)) {
				return new Date(submitValue).getTime();
			}
			
			return submitValue;
		},
		setValue: function(value){
			var me = this;
			
			if(Ext.isNumeric(value)) {
				value = new Date(value);
			}
			Ext.ux.DateTimeField.prototype.setValue.call(me, value);
		}
		
	});
})(Ext4);