Ext.namespace('Ext.suncode.dashboard.gadget');
var messages = Suncode.context('dashboard').messages;

Ext.suncode.dashboard.gadget.GadgetBrowser = Ext.extend(Object, {
  /**
   * Template wyświetlający miniaturke gadżetu
   */
  gadgetTemplate: undefined,

  /**
   * DataView wyświetlający załadowane gadżety
   */
  view: undefined,

  /**
   * Okno tego browsera
   */
  win: undefined,

  modal: true,

  windowCfg: {
    id: 'gadget-browser',
    title: messages('gadget.browser.label'),
    layout: 'border',
    width: 935,
    height: 775,
    closeAction: 'hide',
    modal: true,
    border: false,
    frame: false,
    shadow: false,
  },

  constructor: function (config) {
    this.initTemplates();

    this.store = new Ext.data.JsonStore({
      url: 'api/gadgets/definitions',
      root: 'records',
      idProperty: 'key',
      fields: ['key', 'plugin', 'url', 'name', 'description', 'thumbnail', 'thumbnailIcon'],
    });

    var me = this;
    this.store.on('load', function (store, root) {
      for (var i = 0; i < root.length; i++) {
        var rootData = root[i].data;
        if (rootData.thumbnail !== null) {
          Ext.create({
            xtype: 'box',
            renderTo: root[i].id + '-thumb',
            autoEl: {
              tag: 'img',
              src: rootData.thumbnail,
              title: rootData.name,
            },
          });
        } else {
          new Ext.Container({
            cls: 'dvnt-table-black-icon dvnt-icon-' + rootData.thumbnailIcon,
            renderTo: root[i].id + '-thumb',
          });
        }
        new Ext.Button({
          text: '',
          iconCls: 'dvnt-icon-plus-symbol dvnt-white-icon',
          id: root[i].id + 'btn',
          renderTo: root[i].id + '-button',
          handler: function (btn) {
            me.onAddGadget(me, btn);
          },
          scope: me,
        });
      }
    });

    this.view = new Ext.DataView({
      tpl: this.gadgetTemplate,
      singleSelect: true,
      itemSelector: 'div.gadget-wrap',
      overClass: 'gadget-over',
      store: this.store,
      prepareData: this.prepareData.createDelegate(this),
    });
  },

  prepareData: function (data) {
    data.smallDescription = data.description.ellipse(65);
    data.author = data.plugin != undefined ? data.plugin.author : 'Suncode';

    if (data.thumbnail) data.thumbnail = Suncode.getAbsolutePath(data.thumbnail);
    if (!data.thumbnail && !data.thumbnailIcon)
      data.thumbnail = Suncode.context('dashboard').resourcesPath + '/resources/images/default-gadget-icon.png';
    return data;
  },

  show: function () {
    this.store.reload();

    if (this.win) {
      this.win.show();
      return;
    }

    var cfg = Ext.apply(this.windowCfg, {
      items: [
        {
          region: 'center',
          autoScroll: true,
          items: this.view,
        },
      ],
    });

    this.win = new Ext.Window(cfg);
    this.win.show();
  },

  onAddGadget: function (me, btn) {
    if (btn === undefined) return;
    var id = btn.id.split('btn')[0];
    var gadget = me.store.getById(id);

    var dashboard = Ext.suncode.dashboard.Dashboard.getInstance();
    dashboard.getLayoutManager().addGadget(gadget);

    me.win.hide();
  },

  initTemplates: function () {
    this.gadgetTemplate = new Ext.XTemplate(
      '<tpl for=".">',
      '<div class="gadget-wrap" id="{key}">',
      '<div class="gadget-thumb" id="{key}-thumb"></div>',
      '<div class="gadget-add-button" id="{key}-button"></div>',
      '<div class="gadget-details">',
      '<h3>{name}</h3>',
      '<p class="gadget-description"><b>' + messages('gadget.description') + ': </b>{smallDescription}</p>',
      '<p class="gadget-author"><b>' + messages('gadget.author') + ': </b>{author}</p>',
      '</div>',
      '</div>',
      '</tpl>'
    );
    this.gadgetTemplate.compile();
  },
});
