(function (Ext) {
  var messages = Suncode.context('dashboard').messages;

  Ext.define('Suncode.dashboard.administration.view.Settings', {
    extend: 'Ext.container.Container',
    requires: [
      'Suncode.dashboard.administration.view.DashboardGrid',
      'Suncode.dashboard.administration.view.CreateDashboardForm',
      'Suncode.dashboard.administration.view.EditDashboardForm',
      'Suncode.dashboard.administration.view.ChooseUserOrGroup',
    ],

    chosenType: 'users',
    chosenUser: undefined,
    chosenGroup: undefined,

    layout: 'border',
    margin: '10px 0',
    height: 770,
    minWidth: 800,
    style: {
      background: 0,
    },

    initComponent: function () {
      Ext.apply(this, {
        items: [
          {
            xtype: 'panel',
            region: 'west',
            layout: {
              type: 'vbox',
              align: 'stretch',
            },
            title: messages('manager.west.title'),
            width: 580,
            minWidth: 580,
            collapsible: true,
            autoScroll: true,
            split: true,
            frame: true,
            bodyStyle: {
              padding: '5px',
              border: '0',
            },
            defaults: {
              bodyPadding: 10,
              collapsible: true,
              titleCollapse: true,
              animCollapse: false,
            },
            items: [
              {
                xtype: 'choose-user-or-group',
                cls: 'dashboard-panel-clear choose',
              },
              {
                xtype: 'edit-dashboard-form',
                cls: 'dashboard-panel-clear highlighted',
              },
              {
                xtype: 'dashboard-create-form',
                cls: 'dashboard-panel-clear',
              },
            ],
          },
          {
            xtype: 'panel',
            itemId: 'center-panel',
            itemCls: 'dashboard-big-header',
            region: 'center',
            title: messages('manager.title'),
            frame: true,
            layout: {
              type: 'vbox',
              align: 'stretch',
            },
            bodyStyle: {
              border: '0',
            },
            defaults: {
              cls: 'dashboard-panel-clear',
              collapsible: true,
              animCollapse: false,
            },
            items: [
              {
                xtype: 'dashboard-grid',
                title: messages('grid.user.title', ''),
                hidden: true,
                flex: 1,
                itemId: 'ownedGrid',
                id: 'ownedGrid',
                store: 'MyDashboards',
                editable: true,
                listeners: {
                  scope: this,
                  selectionchange: this.onOwnedSelectionChange,
                },
                style: {
                  margin: '5px',
                  marginBottom: '32px',
                },
              },
              {
                xtype: 'dashboard-grid',
                title: messages('grid.shared.title', ''),
                hidden: true,
                flex: 1,
                itemId: 'sharedGrid',
                store: 'SharedDashboards',
                style: {
                  margin: '5px',
                  marginBottom: '32px',
                },
              },
            ],
            tbar: [
              {
                xtype: 'combo',
                emptyText: messages('dashboard.default.choose'),
                flex: 1,
                disabled: true,
                maxWidth: 576,
                itemId: 'defaultDashboardCombo',
                name: 'defaultDashboard',
                queryMode: 'remote',
                displayField: 'translatedName',
                valueField: 'id',
                value: this.defaultDashboard ? this.defaultDashboard.id : undefined,
                editable: false,
                pageSize: 20,
                listeners: {
                  scope: this,
                  change: function (combo, newValue, oldValue) {
                    if (newValue) {
                      this.setDefaultButton.setDisabled(false);
                    } else {
                      this.setDefaultButton.setDisabled(true);
                    }
                  }
                }
              },
              {
                xtype: 'button',
                itemId: 'setDefaultButton',
                cls: 'toolbar-button-overrides-secondary',
                width: '284px',
                text: messages('form.edit.set'),
                iconCls: 'dvnt-icon-star',
                disabled: true,
                scope: this,
                handler: this.setDefaultDashboard,
              },
            ],
          },
        ],
      });

      this.callParent();

      this.defaultDashboardCombo = this.down('#defaultDashboardCombo');
      this.setDefaultButton = this.down('#setDefaultButton');
      this.ownedGrid = this.down('#ownedGrid');
      this.sharedGrid = this.down('#sharedGrid');
      this.editForm = this.down('edit-dashboard-form');
      this.createForm = this.down('dashboard-create-form');
    },

    onOwnedSelectionChange: function (grid, selected) {
      var me = this;

      if (Ext.isEmpty(selected)) {
        me.editForm.setVisible(false);
      } else {
        me.editForm.bind(selected[0]);
        me.editForm.setVisible(true);
      }
    },

    setDefaultDashboard: function (button) {
      var me = this

      button.setDisabled(true);
      me.defaultDashboardCombo.setDisabled(true);
      button.setIconCls(Ext.baseCSSPrefix + 'mask-msg-text');

      const dashboard = me.defaultDashboardCombo.getStore()
          .getById(me.defaultDashboardCombo.getValue())
          .data;
      const isSystemDashboard = dashboard.type === 'SYSTEM';
      const params = me.chosenType === 'users'
          ? {user: me.chosenUser, system: isSystemDashboard}
          : {group: me.chosenGroup, system: isSystemDashboard};

      Ext.Ajax.request({
        url: Suncode.context('dashboard').base + `/api/dashboards/${encodeURIComponent(dashboard.id)}/default`,
        method: 'POST',
        params: params,
        success: function () {
          button.setIconCls('dvnt-icon-check-circle');
          Ext.defer(function () {
            button.setIconCls('dvnt-icon-star');
          }, 3000);
        },
        failure: function () {
          button.setIconCls('dvnt-icon-x-symbol');
          Ext.defer(function () {
            button.setIconCls('dvnt-icon-star');
          }, 3000);
        },
        callback: function () {
          me.defaultDashboardCombo.setDisabled(false);
          button.setDisabled(false);
        },
      });
    },

    getDefaultDashboard: function () {
      var me = this,
        url,
        params;

      if (me.chosenType === 'users') {
        url = Suncode.context('dashboard').base + '/api/dashboards/default';
        params = {user: me.chosenUser};
      } else {
        url = Suncode.context('dashboard').base + '/api/dashboards/default';
        params = {group: me.chosenGroup};
      }

      Ext.Ajax.request({
        url: url,
        method: 'GET',
        params: params,
        success: function (response) {
          if (response.responseText) {
            var dashboard = Ext.decode(response.responseText);
            me.defaultDashboardCombo.getStore().reload();
            me.defaultDashboardCombo.setValue(dashboard.id);
          } else {
            me.defaultDashboardCombo.setValue('');
          }
        },
      });
    },
  });
})(Ext4);
