// http://www.extjs.com/forum/showthread.php?t=10002

// =====================================================================
// =================== Grid dla Tabel ================================
// =====================================================================

// create the tableGridPanel
var tablesGrid = new Ext.grid.EditorGridPanel( {
	editable : true,
	region : 'center',
	loaded : false,
	clicksToEdit : 1,
	viewConfig : {
		// zeby nam kolumny zmienialy ladnie szerokosc
		forceFit : true,
		// usuniete rekordy zaznaczamy na szaro. dopiero pozniej cos z nimi
		// robimy..
		getRowClass : function(record, index, rowParams, store) {
			if (record.deleted) {
				return 'deleted-row';
			} else
				return '';
		}
	},
	title : PW.t('tytul_grida_tabel'),
	loadMask : {
		msg : PW.t('ladowanie_tabel'),
		store : getTableDataStore()
	},
	id : 'tablesGrid',
	store : getTableDataStore(),
	cm : tablesColumnModel,
	autoExpandColumn : 'tableName',
	// ze mozna zaznaczyc tylko pojedynczy wiersz
	sm : new Ext.grid.RowSelectionModel( {
		singleSelect : false
	})
});

// =====================================================================
// =================== Grid dla Kolumn ===============================
// =====================================================================

// create the tableGridPanel
var columnsGrid = new Ext.grid.EditorGridPanel( {
	editable : true,
	region : 'center',
	loaded : false,
	clicksToEdit : 1,
	viewConfig : {
		// zeby nam kolumny zmienialy ladnie szerokosc
		forceFit : true,
		// usuniete rekordy zaznaczamy na szaro. dopiero pozniej cos z nimi
		// robimy..
		getRowClass : function(record, index, rowParams, store) {
			if (record.deleted) {
				return 'deleted-row';
			} else
				return '';
		}
	},
	title : PW.t('tytul_grida_kolumn'),
	loadMask : {
		msg : PW.t('ladowanie_kolumn')
	},
	id : 'columnsGrid',
	store : getColumnsDataStore(),
	cm : emptyColumnModel,
	autoExpandColumn : 'columnName',
	// ze mozna zaznaczyc tylko pojedynczy wiersz
	sm : new Ext.grid.RowSelectionModel( {
		singleSelect : false
	})
});

// =====================================================================
// =================== Grid dla Wartosci =============================
// =====================================================================

// create the valuesGridPanel
var valuesGrid = new Ext.grid.EditorGridPanel( {
	editable : true,
	region : 'center',
	loaded : false,
	tableId : null,
	title : PW.t('tytul_grida_wartosci'),
	loadMask : {
		msg : PW.t('ladowani_wartosci'),
		store : emptyDataStore
	},
	plugins : [],
	id : 'valuesGrid',
	clicksToEdit : 1,
	store : emptyDataStore,
	cm : emptyColumnModel,
	view: new Ext.ux.grid.BufferView({
		cacheSize: 50,
		autoFill: true
	 }),
	// usuniete rekordy zaznaczamy na szaro. dopiero pozniej cos z nimi
	// robimy..
	viewConfig : {
		getRowClass : function(record, index, rowParams, store) {
			if (record.deleted) {
				return 'deleted-row';
			} else {
				return '';
			}
		}
	},
	// ze mozna zaznaczyc tylko pojedynczy wiersz
	sm : new Ext.grid.RowSelectionModel( {
		singleSelect : false,
		moveEditorOnEnter : false
	})
});

// =====================================================================
// =================== OBSŁUGA ZDARZEŃ ================================
// =====================================================================

// zmienna globalna dla nazwy tabeli
myVtCurrentTableName = '';

// id mozna edytowac tylko wtedy, gdy to jest nowy rekord.
// nowy rekord poznajemy po tym, ze ma id w modified.
function beforeEditFunction(e) {
	// jezeli ktos chce edytowac id
	if ((e.field == 'id') || (e.field == 'typeId')) {
		// jezeli to jest nowy rekord
		if ((e.record.modified != null) && (e.record.modified.id != undefined)) {
			// mozna edytowac
		} else {
			// nie mozna edytowac
			e.cancel = true;
			return false;
		}
	}
}

function refreshWindowTitle() {
	var tableName = myVtCurrentTableName;
	var tit = PW.t('tytul_okna_glownego')
			+ " : <SPAN class=\"tablename\">" + tableName + "</SPAN>";
	Ext.getCmp('mainVtWindow').setTitle(tit);
}

tablesGrid.on('celldblclick', function(grid, rowIndex, columnIndex, e) {
	// Get field name
		var fieldName = grid.getColumnModel().getDataIndex(columnIndex);
		if (fieldName == 'id') {
			Ext.Msg.alert(PW.t('uwaga'),
					PW.t('nieedycjaidtabeli'));
		} else {
			Ext.Msg.alert(PW.t('uwaga'),
					PW.t('nieedycja'));
		}
	});

// co sie stanie po kliknieciu na tabele
// tu jest ustawienie odpowiedniego dataStore'a dla kolumn
// i columnModel'u oraz dataStore'a dla wartosci
tablesGrid.on('rowclick', function(grid, rowIndex, e) {

	// ustawiamy tableId
		var rec = grid.getSelectionModel().getSelected();
		var tableId = rec.data.id;
		var cg = Ext.getCmp('columnsGrid');
		cg.getStore().setBaseParam('tableId', tableId);
		// ustawiamy wyswietlanie jaka jest wybrana tabela
		myVtCurrentTableName = rec.data.tableName;
		// ustawiamy tytul dla okna
		refreshWindowTitle()
		// load jest w momencie 'activate' dla columnGrida
		// teraz ustawiamy koniecznosc jego zaladowania
		cg.loaded = false;
		// to jest po to, ze jak nie ma zadnych tabel,
		// to nam sie nic nie wyswietla w kolumnach i wartosciach
		cg.reconfigure(getColumnsDataStore(), columnsColumnModel);
		// oznaczamy tabele i mowimy, ze trzeba narysować wartosci
		vg = Ext.getCmp('valuesGrid');
		vg.tableId = tableId;
		vg.loaded = false;
		// i jeszzcz ustawiamy ukryte pole w formularzu do uploadu plikow
		Ext.getCmp('fileUploadPanel').baseParams.tableId = tableId;
	});

tablesGrid.on('beforeedit', beforeEditFunction);

// to jest sprawdzenie, czy ktos chce edytowac wartosc
// zaznaczona do usuniecia. jezeli tak, to nie pozwalamy na to
tablesGrid.on('validateedit', function(e) {
	if (e.record.deleted) {
		var napis = PW.t('komunikat_tabeli_1');
		Ext.Msg.alert(PW.t('uwaga'), napis);
		return false;
	}
});

tablesGrid.on('activate', function(e) {
	tg = Ext.getCmp('tablesGrid');
	if (!tg.loaded) {
		tg.getStore().load();
		tg.loaded = true;
	}
});

columnsGrid.on('celldblclick', function(grid, rowIndex, columnIndex, e) {
	// Get field name
		var fieldName = grid.getColumnModel().getDataIndex(columnIndex);
		if (fieldName == 'id') {
			Ext.Msg.alert(PW.t('uwaga'),
					PW.t('nieedycjaidkolumny'));
		}
		if (fieldName == 'typeId') {
			Ext.Msg.alert(PW.t('uwaga'),
					PW.t('nieedycjatypu'));
		}
	});

columnsGrid.on('beforeedit', beforeEditFunction);

// to jest sprawdzenie, czy ktos chce edytowac wartosc
// zaznaczona do usuniecia. jezeli tak, to nie pozwalamy na to
columnsGrid.on('validateedit', function(e) {
	if (e.record.deleted) {
		var napis = PW.t('komunikat_kolumny_1');
		Ext.Msg.alert(PW.t('uwaga'), napis);
		return false;
	}
});

columnsGrid.on('activate', function(e) {
	cg = Ext.getCmp('columnsGrid');
	if (!cg.loaded) {
		cg.getStore().load();
		cg.loaded = true;
	}
});

valuesGrid.on('validateedit', function(e) {
	if (e.record.deleted) {
		var napis = PW.t('komunikat_wartosci_1');
		Ext.Msg.alert(PW.t('uwaga'), napis);
		return false;
	}
});

// ladujemy grida dopiero jak ktos chce go ogladac
valuesGrid.on('activate', function(e) {
	vg = Ext.getCmp('valuesGrid');
	// jezeli jest okreslona tabela , a wartosci nie byly jeszcze zaladowane
		if ((vg.tableId != null) && (!vg.loaded)) {
			// najpierw JAvaScript dla wartosci
		AJAX.open("GET",
				"com.plusmpm.servlet.virtualtables.getValuesJavaScript.customServlet?tableId="
						+ vg.tableId, false);
		AJAX.send(null);
		eval(AJAX.responseText);
		vg = Ext.getCmp('valuesGrid');
		// to powinno byc dopiero po pobraniu javascripty z columnModelem
		// pobieramy nowy dataStore i columnModel
		var cm = getValuesColumnModel()
		var ds = getValuesDataStore();
		// to sprawdzamy na wypadek, gdyby ktos chcial wyswietlic
		// wartosi nieisniejacej (nowo utworzonej) tabeli
		// ustawiamy je w gridzie
		vg.reconfigure(ds, cm);
		// ustalamy o jaka tabele chodzi
		ds.setBaseParam('tableId', vg.tableId);
		// ladujemy dane
		ds.load();
		vg.loaded = true;
		vg.render();
	}
	Ext.getCmp('importButton').show();
	Ext.getCmp('exportButton').show();
});

valuesGrid.on('deactivate', function(e) {
	Ext.getCmp('importButton').hide();
	Ext.getCmp('exportButton').hide();
});

valuesGrid.on('cellclick', function(grid, rowIndex, columnIndex, e) {
	var cm = grid.getColumnModel();
	var editor = cm.getCellEditor(columnIndex, rowIndex);
	var field = editor.field;

	if ( field.isXType('checkbox') ) {
	    var rec = grid.getStore().getAt(rowIndex);
        var dataIndex = cm.getDataIndex(columnIndex);
		var currentValue = rec.get(dataIndex);
		rec.set(dataIndex, !currentValue);
	}
});