(function (Ext) {
  Ext.define('Suncode.deactivateUsers.controller.DeactivateUserController', {
    extend: 'Ext.app.Controller',
    stores: ['TasksGridStore', 'UsersStore', 'GroupsStore'],
    models: ['TasksGridModel', 'UsersModel', 'GroupsModel'],
    views: ['WindowManager', 'Assignments', 'TasksSection', 'TasksGrid', 'TasksAssignment', 'OthersSection', 'UsersCombo'],

    init: function () {
      this.control({
        winmanager: {
          afterrender: this.onWindowRender,
        },
        'winmanager button[action=deactiveButton]': {
          click: this.onDeactiveButtonClick,
        },
        'winmanager button[action=cancelButton]': {
          click: this.onCancelButtonClick,
        },
        'tasks-grid': {
          selectionchange: this.onRowSelected,
        },
        'tasks-assignment combo[id=typeCombo]': {
          disable: this.onComboDisable,
          change: this.onComboChange,
        },
        'tasks-assignment combo[id=datalist]': {
          disable: this.onComboDisable,
          change: this.onComboChange,
        },
        'tasks-assignment button[action=addAssignButton]': {
          click: this.onAssignButtonClick,
        },
        'tasks-assignment button[action=clearButton]': {
          click: this.onClearButtonClick,
        },
        'others-section combo[itemId=defaultUser]': {
          select: this.onDefaultUserChosen,
        },
      });
    },

    onWindowRender: function (win) {
      var treegrid = Ext.getCmp('tasks-grid'),
        treegridStore = treegrid.getStore();

      var panel = Ext.getCmp('assignment-panel');
      panel.mask = new Ext.LoadMask(panel, { msg: PW.t('processes-load') });
      panel.mask.show();

      this.setValue('#skipSubstitutions', window.localStorage.getItem('deactivate_skip_substitutions'));
      this.setValue('#skipNotifications', window.localStorage.getItem('deactivate_skip_notifications'));

      //musimy dać opóźnienie na założenie maski, gdyż inaczej na IE leci błąd
      Ext.defer(
        function () {
          treegridStore.addListener('load', this.onTreeGridStoreLoad, this);

          this.editMode = win.editMode;

          if (this.editMode) {
            treegridStore.getProxy().url = 'api/userdeactivation/deactivate/processes';
          }

          treegridStore.getProxy().extraParams = {
            userName: win.userid,
          };
          treegrid.getRootNode().expand();
        },
        10,
        this
      );
    },

    onTreeGridStoreLoad: function () {
      var panel = Ext.getCmp('assignment-panel');

      if (!this.editMode) {
        Ext.Ajax.request({
          url: 'api/userdeactivation/deactivate/extratransfers',
          method: 'GET',
          scope: this,
          success: function (response) {
            var extraTransfers = JSON.parse(response.responseText);
            this.initExtraTransfers(extraTransfers);

            panel.mask.hide();
            Ext.getCmp('deactiveButton').setDisabled(false);
          },

          failure: this.onFailure,
        });
      } else {
        panel.mask.hide();
        Ext.getCmp('deactiveButton').setDisabled(false);
      }
    },

    initExtraTransfers: function (extraTransfers) {
      Ext.getCmp('others-section').initExtraTransfers(extraTransfers);
    },

    onRowSelected: function (treegrid, selected) {
      var typeCombo = Ext.getCmp('typeCombo');

      if (selected.length > 0) {
        typeCombo.setDisabled(false);
        Ext.getCmp('clearButton').setDisabled(false);
      } else {
        typeCombo.clearValue();
        typeCombo.setDisabled(true);
        Ext.getCmp('clearButton').setDisabled(true);
      }
    },

    onComboDisable: function (combo) {
      if (combo.getId() === 'typeCombo') {
        var dataList = Ext.getCmp('datalist');
        dataList.setDisabled(true);
        dataList.clearValue();
      } else {
        Ext.getCmp('addAssignButton').setDisabled(true);
      }
    },

    onComboChange: function (combo, newValue) {
      if (combo.getId() === 'datalist') {
        var dataListRecord = combo.findRecordByValue(newValue);
        if (dataListRecord) {
          Ext.getCmp('addAssignButton').setDisabled(false);
        } else {
          Ext.getCmp('addAssignButton').setDisabled(true);
        }
      } else {
        Ext.getCmp('addAssignButton').setDisabled(true);

        var dataListCombo = Ext.getCmp('datalist');
        dataListCombo.emptyText = ' ';
        delete dataListCombo.lastQuery;

        if (newValue) {
          if (newValue === 'USER') {
            dataListCombo.emptyText = PW.t('users-empty');
            dataListCombo.bindStore(Ext.getCmp('assignment-panel').usersStore);
          } else {
            dataListCombo.emptyText = PW.t('groups-empty');
            dataListCombo.bindStore(Ext.getCmp('assignment-panel').groupsStore);
          }
        }

        dataListCombo.reset();
        dataListCombo.setDisabled(false);
      }
    },

    onDefaultUserChosen: function (combo, records) {
      var chosenUser = records[0];
      if (chosenUser) {
        this.setCombo(Ext.getCmp('assignment-panel').down('#delegations'), chosenUser);
        this.setCombo(Ext.getCmp('assignment-panel').down('#views'), chosenUser);
        this.setCombo(Ext.getCmp('assignment-panel').down('#reports'), chosenUser);
        this.setCombo(Ext.getCmp('assignment-panel').down('#notifications'), chosenUser);
        this.setCombo(Ext.getCmp('assignment-panel').down('#otherActivities'), chosenUser);
        this.setCombo(Ext.getCmp('assignment-panel').down('#favouriteSets'), chosenUser);

        var me = this;
        var othersSection = Ext.getCmp('others-section');
        othersSection.getExtraTransfers().forEach(function (extraTransfer) {
          extraTransfer.value = chosenUser.get('userName');

          var combo = othersSection.getExtraTransferCombo(extraTransfer.id);
          me.setCombo(combo, chosenUser);
        });
      }
    },

    setCombo: function (combo, chosenUser) {
      var value = chosenUser.get('userName'),
        data = combo.findRecordByValue(value);

      if (!data) {
        combo.getStore().add(chosenUser);
      }
      combo.setValue(value);
    },

    onAssignButtonClick: function () {
      var mainwin = Ext.getCmp('deactivation'),
        mainwinmask = new Ext.LoadMask(mainwin, { msg: PW.t('assign-msg') });
      mainwinmask.show();

      //robimy opóźnienie, aby maska się pojawiła od razu
      Ext.defer(
        function () {
          var dataList = Ext.getCmp('datalist'),
            dataListRecord = dataList.findRecordByValue(dataList.getValue()),
            typeCombo = Ext.getCmp('typeCombo'),
            treegrid = Ext.getCmp('tasks-grid'),
            selected = treegrid.getSelectionModel().getSelection(),
            msg;

          if (dataListRecord) {
            if (typeCombo.getValue() === 'USER') {
              var userName = dataListRecord.get('userName');
              for (var i = 0; i < selected.size(); i++) {
                var leaves = this.getAllLeaves(selected[i]);

                for (var j = 0; j < leaves.length; j++) {
                  var assignedto = '',
                    isGroup = leaves[j].get('group');

                  if (isGroup == false) {
                    assignedto = leaves[j].get('assignments');
                  }

                  if (this.isAssignExisting(assignedto, userName) === false) {
                    //if(assignedto.indexOf(userName) == -1) {
                    if (Ext.isEmpty(assignedto)) {
                      assignedto = userName;
                    } else {
                      assignedto += ',' + userName;
                    }

                    leaves[j].set('assignments', assignedto);
                  }
                  leaves[j].set('group', false);
                }
              }
              msg = PW.t('user-assign-msg') + ' <span class="dvnt-orange">' + userName + '</span>';
            } else {
              var groupName = dataListRecord.get('name');
              for (var i = 0; i < selected.size(); i++) {
                var leaves = this.getAllLeaves(selected[i]);

                for (var j = 0; j < leaves.size(); j++) {
                  leaves[j].set('assignments', groupName);
                  leaves[j].set('group', true);
                }
              }
              msg = PW.t('group-assign-msg') + ' <span class="dvnt-orange">' + groupName + '</span>';
            }

            mainwinmask.hide();
            Suncode.deactivateUsers.api.MessageService.showSuccess(msg);
          } else {
            msg = PW.t('invalid-value');
            mainwinmask.hide();
            Suncode.deactivateUsers.api.MessageService.showFailure(msg);
          }
        },
        10,
        this
      );
    },

    isAssignExisting: function (assignedto, userName) {
      var assignedArray = assignedto.split(',');
      for (var i = 0; i < assignedArray.length; i++) {
        if (assignedArray[i].toString() == userName.toString()) {
          return true;
        }
      }
      return false;
    },

    onClearButtonClick: function () {
      var mainwin = Ext.getCmp('deactivation'),
        mainwinmask = new Ext.LoadMask(mainwin, { msg: PW.t('clean-msg-wait') });
      mainwinmask.show();

      //robimy opóźnienie, aby maska się pojawiła od razu
      Ext.defer(
        function () {
          var treegrid = Ext.getCmp('tasks-grid'),
            selected = treegrid.getSelectionModel().getSelection();

          for (var i = 0; i < selected.size(); i++) {
            var leaves = this.getAllLeaves(selected[i]);

            for (var j = 0; j < leaves.length; j++) {
              leaves[j].set('assignments', '');
              leaves[j].set('group', '');
            }
          }
          mainwinmask.hide();
          Suncode.deactivateUsers.api.MessageService.showInfo(PW.t('clean-msg'));
        },
        10,
        this
      );
    },

    setEmptyAssignments: function () {
      var root = Ext.getCmp('tasks-grid').getRootNode(),
        leaves = this.getAllLeaves(root),
        emptyTaskUsers = Ext.getCmp('deactivation').emptyTaskUsers,
        emptyTaskUsersName = [];

      for (var j = 0; j < emptyTaskUsers.length; j++) {
        emptyTaskUsersName.push(emptyTaskUsers[j].userName);
      }

      for (var i = 0; i < leaves.size(); i++) {
        if (Ext.isEmpty(leaves[i].get('assignments'))) {
          leaves[i].set('assignments', emptyTaskUsersName.join(','));
          leaves[i].set('group', false);
        }
      }
    },

    getAllLeaves: function (node) {
      var leaves = [];

      if (node.isLeaf()) {
        leaves.push(node);
      } else {
        node.eachChild(function (childNode) {
          leaves = leaves.concat(this.getAllLeaves(childNode));
        }, this);
      }
      return leaves;
    },

    getJsonToSend: function () {
      var jsonObject = {
        userName: Ext.getCmp('deactivation').userid,
        processes: this.getProcesses(),
      };

      if (this.editMode == false) {
        jsonObject.delegationUser = this.getValue('#delegations');
        jsonObject.viewUser = this.getValue('#views');
        jsonObject.reportUser = this.getValue('#reports');
        jsonObject.notificationUser = this.getValue('#notifications');
        jsonObject.otherAcitivitiesUser = this.getValue('#otherActivities');
        jsonObject.favouriteSetsUser = this.getValue('#favouriteSets');
        jsonObject.extraTransfers = this.getExtraTransfersDto();
      }

      jsonObject.skipSubstitutions = this.getValue('#skipSubstitutions');
      jsonObject.skipNotifications = this.getValue('#skipNotifications');

      return jsonObject;
    },

    getValue: function (type) {
      return Ext.getCmp('assignment-panel').down(type).getValue();
    },

    setValue: function (type, value) {
      return Ext.getCmp('assignment-panel').down(type).setValue(value);
    },

    getExtraTransfersDto: function () {
      return Ext.getCmp('others-section').getExtraTransfersDto();
    },

    getProcesses: function () {
      var processes = [],
        process = {},
        root = Ext.getCmp('tasks-grid').getRootNode();

      root.eachChild(function (node) {
        process = {
          name: node.get('name'),
          description: node.get('description'),
          packageId: node.get('packageId'),
          processDefId: node.get('processDefId'),
          children: this.getRoles(node),
        };
        processes.push(process);
      }, this);

      return processes;
    },

    getRoles: function (processNode) {
      var roles = [],
        role = {};

      processNode.eachChild(function (node) {
        role = {
          name: node.get('name'),
          id: node.get('roleId'),
          children: this.getTasks(node),
        };
        roles.push(role);
      }, this);

      return roles;
    },

    getTasks: function (roleNode) {
      var tasks = [],
        task = {};

      roleNode.eachChild(function (node) {
        task = {
          name: node.get('name'),
          activityDefId: node.get('activityDefId'),
          assigned: node.get('assigned'),
          leaf: node.get('leaf'),
          assignments: node.get('assignments').split(','),
          group: node.get('group'),
        };
        tasks.push(task);
      }, this);

      return tasks;
    },

    onDeactiveButtonClick: function () {
      var panel = Ext.getCmp('assignment-panel'),
        mainwin = Ext.getCmp('deactivation'),
        maskMsg = this.editMode ? PW.t('wait-msg-change') : PW.t('wait-msg'),
        mainwinmask = new Ext.LoadMask(mainwin, { msg: maskMsg }),
        failureMsg = PW.t('validation-failure');

      mainwinmask.show();
      Ext.defer(
        function () {
          var leaf = this.validateTasks();
          if (leaf == null) {
            if (panel.getForm().isValid()) {
              this.setEmptyAssignments();
              this.deactive(mainwinmask);
            } else {
              var otherSection = panel.down('#others-section');
              otherSection.down('#notifications').focus();
              mainwinmask.hide();
              Suncode.deactivateUsers.api.MessageService.showFailure(failureMsg);
            }
          } else {
            panel.body.scrollTo('Top', 0, true);
            Ext.getCmp('tasks-grid').getSelectionModel().select(leaf);
            mainwinmask.hide();
            Suncode.deactivateUsers.api.MessageService.showFailure(failureMsg);
          }
        },
        10,
        this
      );
    },

    deactive: function (mainwinmask) {
      var me = this;
      Ext.Ajax.request({
        url: 'api/userdeactivation/assignments/count',
        method: 'GET',
        scope: this,
        params: {
          userName: Ext.getCmp('deactivation').userid,
        },
        success: function (response) {
          var assignmentsCount = JSON.parse(response.responseText);
          var backgroundDeactivationAssignmentsLimit = 10000;

          var deactivationContext = {
            assignmentsCount: assignmentsCount,
            shouldRunConcurrently: !me.editMode && assignmentsCount >= backgroundDeactivationAssignmentsLimit
          }

          if (me.editMode) {
            me.performDeactivation(deactivationContext, false);
          } else if (deactivationContext.shouldRunConcurrently) {
            me.showScheduledTaskDeactivationWarningDialog(deactivationContext, mainwinmask);
          } else {
            me.showLongDeactivationWarningDialog(deactivationContext, mainwinmask);
          }
        },

        failure: this.onFailure
      });
    },

    showScheduledTaskDeactivationWarningDialog(deactivationContext, mainwinmask) {
      var me = this;

      Ext.Msg.show({
        title: PW.t("warningText"),
        msg: PW.t("Ze_wzgledu_na_duza_ilosc_zadan_dezaktywacja_zostanie_wykonana_zadaniem_zaplanowanym_w_nocy_czy_chcesz_kontynuowac"),
        buttons: Ext.Msg.YESNO,
        buttonText: {
          yes: PW.t("yes"),
          no: PW.t("no")
        },
        icon: Ext.MessageBox.QUESTION,
        //PWFL-10760 - obejście, by nie fokusuwać się na żadnym przycisku
        defaultFocus: 4,
        fn: function(buttonId) {
          if (buttonId === "yes") {
            me.performDeactivation(deactivationContext, true);
          } else {
            mainwinmask.hide();
          }
        }
      });
    },

    showLongDeactivationWarningDialog(deactivationContext, mainwinmask) {
      var me = this;

      Ext.Msg.show({
        title: PW.t("warningText"),
        msg: PW.t("Ta_operacja_moze_chwile_potrwac_zalecane_jest_uruchomienie_jej_w_nocy_czy_chcesz_tego_dokonac"),
        buttons: Ext.Msg.YESNOCANCEL,
        buttonText: {
          yes: PW.t("W_godzinach_nocnych"),
          no: PW.t("Natychmiast"),
          cancel: PW.t("cancelText")
        },
        icon: Ext.MessageBox.QUESTION,
        //PWFL-10760 - obejście, by nie fokusuwać się na żadnym przycisku
        defaultFocus: 4,
        fn: function(buttonId) {
          if (buttonId === "yes") {
            me.performDeactivation(deactivationContext, true);
          } else if (buttonId === "no") {
            me.performDeactivation(deactivationContext, false);
          } else {
            mainwinmask.hide();
          }
        }
      });
    },

    performDeactivation: function(deactivationContext, isUsingScheduledTask) {
      var jsonToSend = this.getJsonToSend();

      jsonToSend.runInBackground = isUsingScheduledTask;
      jsonToSend.runInScheduledTask = isUsingScheduledTask;
      jsonToSend.performConcurrently = deactivationContext.shouldRunConcurrently

      Ext.Ajax.defaultHeaders = { 'Content-Type': 'application/json' };
      Ext.Ajax.request({
        timeout: 300000,
        url: this.editMode ? 'api/userdeactivation/change' : 'api/userdeactivation/deactivate',
        method: 'POST',
        jsonData: jsonToSend,
        scope: this,
        success: function (response) {
          var success = Ext.decode(response.responseText).success;
          if (success) {
            window.reloadUserTable();
            var data = Ext.decode(response.responseText).data;
            this.onSuccess(data);
          } else {
            this.onFailure();
          }
        },
        failure: this.onFailure,
      });

      window.localStorage.setItem('deactivate_skip_substitutions', this.getValue('#skipSubstitutions'));
      window.localStorage.setItem('deactivate_skip_notifications', this.getValue('#skipNotifications'));

      if (isUsingScheduledTask) {
        this.onDeactivateInScheduledTask();
      }
    },

    onSuccess: function (data) {
      var mainwin = Ext.getCmp('deactivation');
      if (typeof mainwin !== 'undefined') {
        deactivatedUser = mainwin.userid;
        mainwin.close();

        var msg = PW.t('user') + ' <span class="dvnt-orange">' + deactivatedUser + '</span>' + ' ' + PW.t('deactivated') + '.';
        if (data == 'otherTransferFailed') {
          msg += '<br/>' + PW.t('couldNotTransferOtherActivities');
        }

        if (this.editMode) {
          msg = PW.t('onsuccess-edit');
        }

        Ext.Msg.show({
          msg: msg,
          buttons: Ext.Msg.OK,
          icon: Ext.MessageBox.INFO,
        });
      }
    },

    onFailure: function (response) {
      if (response.timedout) {
        this.onDeactivateInBackground();
        return;
      }

      var mainwin = Ext.getCmp('deactivation');
      if (typeof mainwin !== 'undefined') {
        deactivatedUser = mainwin.userid;

        mainwin.close();

        var msg = PW.t('failure') + ' <span class="dvnt-orange">' + deactivatedUser + '</span>';
        if (this.editMode) {
          msg = PW.t('onfailure-edit');
        }

        Ext.Msg.show({
          msg: msg,
          buttons: Ext.Msg.OK,
          icon: Ext.MessageBox.INFO,
        });
      }
    },

    onDeactivateInBackground: function () {
      var mainwin = Ext.getCmp('deactivation'),
        deactivatedUser = mainwin.userid;

      mainwin.close();

      var msg = PW.t('user') + ' <span class="dvnt-orange">' + deactivatedUser + '</span>' + ' ' + PW.t('deactivatedInBackground') + '.';

      Ext.Msg.show({
        msg: msg,
        buttons: Ext.Msg.OK,
        icon: Ext.MessageBox.INFO,
      });
    },

    onDeactivateInScheduledTask: function () {
      var mainwin = Ext.getCmp('deactivation'),
        deactivatedUser = mainwin.userid;

      mainwin.close();

      var msg = PW.t('user') + ' <span class="dvnt-orange">' + deactivatedUser + '</span>' + ' ' + PW.t('deactivatedInScheduledTask') + '.';

      Ext.Msg.show({
        msg: msg,
        buttons: Ext.Msg.OK,
        icon: Ext.MessageBox.INFO,
      });
    },

    validateTasks: function () {
      var root = Ext.getCmp('tasks-grid').getRootNode(),
        leaves = this.getAllLeaves(root),
        assigned,
        assignments,
        isValid = true,
        leaf = null;

      for (var i = 0; i < leaves.size(); i++) {
        assigned = leaves[i].get('assigned');
        assignments = leaves[i].get('assignments');

        if (assigned && Ext.isEmpty(assignments)) {
          if (leaf == null) {
            leaf = leaves[i];
          }
          this.expandNode(leaves[i]);
          isValid = false;
        }
      }

      return leaf;
    },

    expandNode: function (node) {
      var parent = node.parentNode;
      if (parent) {
        node.parentNode.expand();
        this.expandNode(node.parentNode);
      }
    },

    onCancelButtonClick: function (button) {
      button.up().up().close();
    },
  });
})(this.Ext4);
