/**
 * Nadpisuje standardowe działanie Ext4.
 * 
 * Musi być ładowany po /resources/js/common/common.js
 */

jQuery.extend(Suncode, {
    
    applyExt4Overrides : function(){
    	if( window.Ext4) {
    		Suncode._overrideMessageBox();
    		Suncode._overrideWindow();
    		Suncode._overrideComboBox();
    		Suncode._overridePluginEditing();
    	}
	},

    _overrideMessageBox : function(){
    	 Ext4.override(Ext4.window.MessageBox, {
			shadow : false
		});
	},

    _overrideWindow : function(){
    	Ext4.override(Ext4.Window, {
			shadow : false
		});
    },
	
	/**
	* Zachowane działanie dot forceSelection jak w 4.2.1
	*/
     _overrideComboBox : function(){
    	 Ext4.override( Ext4.form.field.ComboBox, {
			onDataChanged : function() {
				var me = this;
				if (me.resizeComboToGrow()) {
					me.updateLayout();
				}
			},
			onLoad : function(store, records, success) {
				var me = this;
				if (me.ignoreSelection > 0) {
					--me.ignoreSelection;
				}
				// If not querying using the raw field value, we can set the value now we have data
				if (success && !store.lastOptions.rawQuery) {
					// Set the value on load
					// There's no value.
					if (me.value == null) {
						// Highlight the first item in the list if autoSelect: true
						if (me.store.getCount()) {
							me.doAutoSelect();
						} else {
							// assign whatever empty value we have to prevent change from firing
							me.setValue(me.value);
						}
					} else {
						me.setValue(me.value);
					}
				}
			}
		});
     },
     
     _overridePluginEditing: function() {
         // PWFL-4028, PLWZD-77, PWFL-4898
         Ext4.override( Ext4.grid.plugin.Editing, {
             startEdit: function(record, columnHeader, context) {
                 if (this.cmp.isDestroyed) {
                     return;
                 }
                 var me = this,
                     context,
                     layoutView = me.grid.lockable ? me.grid : me.view,
                     bufferedRenderer = me.grid.view.bufferedRenderer;

                 if (!layoutView.componentLayoutCounter) {
                     layoutView.on({
                         boxready: Ext4.Function.bind(me.startEdit, me, [
                             record,
                             columnHeader
                         ]),
                         single: true
                     });
                     return false;
                 }

                 if (me.grid.collapsed || !me.grid.view.isVisible(true)) {
                     return false;
                 }

                 if (bufferedRenderer) {

                     //PWFL-4898
                     bufferedRenderer.handleViewScroll();

                     // PWFL-4028
                     // Sprawdzenie czy wiersz komórki jest widoczny.
                     // Jeżeli nie, scrolluj do niego.
                     
                     var firstVisibleIndex = bufferedRenderer.getFirstVisibleRowIndex();
                     var lastVisibleIndex = bufferedRenderer.getLastVisibleRowIndex();
                     var recordIndex = bufferedRenderer.store.indexOf(record);

                     if(recordIndex < firstVisibleIndex || recordIndex > lastVisibleIndex) {
                         bufferedRenderer.scrollTo(record);
                     }
                 }

                 
                 context = me.getEditingContext(record, columnHeader);
                 if (context == null) {
                     return false;
                 }
                 if (!me.preventBeforeCheck) {
                     if (me.beforeEdit(context) === false || me.fireEvent('beforeedit', me, context) === false || context.cancel) {
                         return false;
                     }
                 }
                 return context;
             }
         });
     }
});

        

