(function (Ext) {
  Ext.define('Favourites.settings.view.FavouriteElements', {
    extend: 'Ext.grid.Panel',
    xtype: 'favourite-elementsgrid',
    requires: ['Favourites.settings.view.FavouriteWindow'],

    initComponent: function () {
      var me = this;

      Ext.apply(me, {
        viewConfig: {
          markDirty: false,
          plugins: {
            ptype: 'gridviewdragdrop',
          },
          listeners: {
            drop: me.sortPositions,
            scope: me,
          },
        },
        columns: {
          defaults: {
            draggable: false,
            hideable: false,
            sortable: true,
          },
          items: [
            {
              text: Favourites.I18N.m('position'),
              dataIndex: 'position',
              width: 60,
            },
            {
              text: Favourites.I18N.m('name'),
              dataIndex: 'name',
              flex: 2,
            },
            {
              text: Favourites.I18N.m('type'),
              dataIndex: 'typeDescription',
              flex: 1,
            },
            {
              text: Favourites.I18N.m('description'),
              dataIndex: 'description',
              flex: 3,
            },
            {
              text: Favourites.I18N.m('count'),
              dataIndex: 'counted',
              width: 100,
              renderer: function (value, meta) {
                meta.innerCls = 'favourite-element-count';
                return '<img src="' + Ext.BLANK_IMAGE_URL + '" class="' + (value ? 'dvnt-icon-check-symbol dvnt-green-icon' : '') + '"/>';
              },
            },
            {
              xtype: 'actioncolumn',
              width: 30,
              tooltip: Favourites.I18N.m('delete'),
              iconCls: 'dvnt-icon-x-circle',
              handler: Ext.bind(me.deleteFavourite, me),
            },
          ],
        },
        dockedItems: [
          {
            xtype: 'toolbar',
            dock: 'bottom',
            items: [
              {
                text: Favourites.I18N.m('settings.editor.add'),
                iconCls: 'dvnt-icon-plus-circle',
                handler: me.showWindow,
                scope: me,
              },
            ],
          },
        ],
      });

      me.callParent(arguments);
      me.loadMask = Ext.create('Ext.LoadMask', { target: me });
    },

    reconfigure: function (store) {
      var me = this;

      me.callParent(arguments);
      if (store) {
        me.loadMask.bindStore(store);
      }
    },

    showWindow: function () {
      var me = this;

      if (!me.window) {
        me.window = Ext.create('Favourites.settings.view.FavouriteWindow', {
          modal: true,
          width: 800,
          height: 500,
          listeners: {
            addFavourite: me.addFavourite,
            scope: me,
          },
        });
      }
      me.window.show();
    },

    addFavourite: function (favourite) {
      var me = this,
        store = me.getStore();

      store.add(favourite);
      me.sortPositions();
    },

    deleteFavourite: function () {
      var me = this,
        store = me.getStore(),
        record = arguments[5];

      store.remove(record);
      me.sortPositions();
    },

    sortPositions: function () {
      var me = this,
        store = me.getStore(),
        i = 1;

      store.each(function (record) {
        record.set('position', i++);
      });
    },

    reset: function () {
      var me = this,
        store = me.getStore();

      store.suspendEvent('add');
      try {
        store.rejectChanges();
      } finally {
        store.resumeEvent('add');
      }
      me.getView().refresh();
      store.sort('position', 'ASC');
    },

    isDirty: function () {
      var me = this,
        store = me.getStore();
      return store.getModifiedRecords().length > 0 || store.getRemovedRecords().length > 0;
    },

    onDestroy: function () {
      var me = this;

      me.callParent(arguments);
      Ext.destroy(me.loadMask);
      Ext.destroy(me.window);
    },
  });
})(window.Ext4);
