Ext.namespace( 'Ext.ux.suncode' );

Ext.ux.suncode.ModalWindow = function( config ) {

    var updaterConfig = {
        url: config.url,
        scripts: true,
        method: 'GET'
    };

    config = Ext.apply( {
    	autoScroll: true,
    	autoHeight: config.height ? false : true,
        autoLoad: updaterConfig,
        bodyCssClass: 'popup-window-body',
        cls: 'modal-window popup-window',
        resizable: false,
        frame: false,
        border: true,
        modal: true,
        shadow: false,
        renderTo: Ext.getBody(),
        config: config
    }, config );

    Ext.ux.suncode.ModalWindow.superclass.constructor.call( this, config );
}

Ext.extend( Ext.ux.suncode.ModalWindow, Ext.Window, {

    initComponent: function() {
    	Ext.ux.suncode.ModalWindow.superclass.initComponent.call( this );
        this.on( "afterrender", this.onAfterRenderHandler, this );
        this.on( "show", this.onShowHandler, this );
        this.on( "destroy", this.onDestroyHandler, this );
    },

    onAfterRenderHandler: function( elem ) {
        var updater = elem.getUpdater();
        updater.on( 'update', this.onUpdateHandler, this );
    },
    
    onShowHandler: function( elem ) {
        Ext.getBody().setStyle('overflow', 'hidden');
    },
    
    onDestroyHandler: function( elem ) {
        PW.ui.ModalWindow.remove();
    },

    onUpdateHandler: function() {
    	this.resolveWidth();
    	this.center();
    	this.show();
    },
    
    resolveWidth: function() {
    	var width = this.config.width || 600;
		this.setWidth(width);
    }
});