// konflikt z prototype.js
$.noConflict();

PlusWorkflow = (function (window) {
  var contextPath, currentUser;
  return {
    init: function (config) {
      contextPath = config.contextPath;
      currentUser = config.user;
    },

    getCurrentUser: function () {
      return currentUser;
    },

    getContextPath: function () {
      return contextPath;
    },

    getAbsolutePath: function (url) {
      if (url.indexOf('/') != 0) {
        url = '/' + url;
      }
      return this.getContextPath() + url;
    },

    ExtUtils: {
      // funkcje skopiowane z Ext

      /**
       * Returns true if the passed value is not undefined.
       * @param {Mixed} value The value to test
       * @return {Boolean}
       */
      isDefined : function(v){
        return typeof v !== 'undefined';
      },

      /**
       * Returns true if the passed value is a JavaScript Function, otherwise false.
       * @param {Mixed} value The value to test
       * @return {Boolean}
       */
      isFunction : function(v){
        return Object.prototype.toString.apply(v) === '[object Function]';
      },

      /**
       * Returns true if the passed value is a JavaScript Object, otherwise false.
       * @param {Mixed} value The value to test
       * @return {Boolean}
       */
      isObject : function(v){
        return !!v && Object.prototype.toString.call(v) === '[object Object]';
      },

      /**
       * <p>Returns true if the passed value is empty.</p>
       * <p>The value is deemed to be empty if it is<div class="mdetail-params"><ul>
       * <li>null</li>
       * <li>undefined</li>
       * <li>an empty array</li>
       * <li>a zero length string (Unless the <tt>allowBlank</tt> parameter is <tt>true</tt>)</li>
       * </ul></div>
       * @param {Mixed} value The value to test
       * @param {Boolean} allowBlank (optional) true to allow empty strings (defaults to false)
       * @return {Boolean}
       */
      isEmpty : function(v, allowBlank){
        return v === null || v === undefined || ((Ext.isArray(v) && !v.length)) || (!allowBlank ? v === '' : false);
      },
    },
  };
})(window);

PW = window.PW || PlusWorkflow;

// Suncode - Singleton
Suncode = (function (window) {
  jQuery.ajaxSetup({
    cache: true,
  });

  var contextPath,
    currentUser,
    locale,
    contexts = {},
    sessionTimeout,
    userPageSize;

  return {
    init: function (config) {
      contextPath = config.contextPath;
      currentUser = config.user;
      locale = config.locale;
      sessionTimeout = config.sessionTimeout;
      userPageSize = config.userPageSize;
    },

    getCurrentUser: function () {
      if (currentUser == null) return null;
      return currentUser.userName;
    },

    isAnonymousUser: function () {
      return currentUser && currentUser.anonymous;
    },

    getUserLocale: function () {
      return locale;
    },

    getUserPageSize: function () {
      return userPageSize;
    },

    getSessionTimeout: function () {
      return sessionTimeout;
    },

    getContextPath: function () {
      return contextPath;
    },

    getAbsolutePath: function (url) {
      if (url.indexOf('/') != 0) {
        url = '/' + url;
      }
      return this.getContextPath() + url;
    },

    redirectToLogInPageIfUserIsLoggedOut: function () {
      jQuery
        .ajax({
          url: Suncode.getAbsolutePath('/api/heartbeat?status=IDLE'),
        })
        .fail(function (xhr) {
          if (xhr.status == 401) {
            location.href = Suncode.getAbsolutePath('/LoginManual.do');
          }
        });
    },

    loadScript: function (url) {
      jQuery.ajax({
        url: url,
        dataType: 'script',
        async: true,
      });
    },

    /**
     * Zleca załadowanie framework'a ExtJs4 oraz odpowiedniego języka. Ładowanie jest synchroniczne.
     */
    requireExt: function (config) {
      var me = this,
        config = config || {},
        callaback = Ext.emptyFn,
        scope = window,
        debug;

      if (Ext.isFunction(config)) {
        callback = config;
        if (Ext.isDefined(arguments[1])) {
          scope = arguments[1];
        }
        if (Ext.isDefined(arguments[2])) {
          debug = arguments[2];
        }
      } else {
        callback = config.fn || Ext.emptyFn;
        scope = config.scope || scope;
        debug = config.debug || debug;
      }

      // załadowany
      if (window.Ext4) {
        me.applyOverrides();
        callback.call(scope, Ext4);
        return;
      }

      // załaduj Ext'a
      jQuery.ajax({
        url: me.getAbsolutePath('/resources/lib/extjs-4/ext-all-sandbox' + (debug ? '-debug' : '') + '.js'),
        dataType: 'script',
        cache: true,
        async: false,
        success: function () {
          me.applyOverrides();

          // załaduj locale
          me.requireLang();
          callback.call(scope, Ext4);
        },
      });
    },

    applyOverrides: function () {
      // definicja jest umieszczona w /resources/lib/extjs-4/override.js
      Suncode.applyExt4Overrides();
    },

    /**
     * Zleca załadowanie odpowiedniego języka dla ExtJs4. Ładowanie jest synchroniczne.
     */
    requireLang: function () {
      // załaduj locale
      jQuery.ajax({
        url: this.getAbsolutePath('/resources/lib/extjs-4/locale/ext-lang-' + this.getUserLocale() + '-sandbox.js'),
        dataType: 'script',
        cache: true,
        async: false,
      });
    },

    context: function (name) {
      if (!contexts[name]) {
        contexts[name] = {};
      }
      return contexts[name];
    },
  };
})(window);

/**
 * Włącza mechanizm automatycznego wylogowywania użytkownika po dłuższym czasie nieaktywności.
 *
 * Co 5 minut (lub sessionTimeout/4) wysyłany jest do serwera '/api/heartbeat' informacja,
 * czy użytkownik jest aktywczny 'ACTIVE' czy nie 'IDLE'.
 *
 * Serwer odpowiada statusem 401, nie jest już zalogowany.
 */
Suncode.initAutoLogout = function () {
  var sessionTimeout = Suncode.getSessionTimeout();
  if (sessionTimeout <= 0) {
    return;
  }

  var $ = jQuery,
    sessionTimeout = sessionTimeout * 1000,
    idleTimeout = Math.min(5 * 60 * 1000, sessionTimeout / 4);

  function heartbeat(status) {
    $.ajax({
      url: Suncode.getAbsolutePath('/api/heartbeat?status=' + status),
    }).fail(function (xhr) {
      if (xhr.status == 0 || xhr.status == 401) {
        if (xhr.getResponseHeader('location') != null) {
          location.href = xhr.getResponseHeader('location');
        } else {
          location.href = Suncode.getAbsolutePath('/LoginManual.do');
        }
      }
    });
  }

  setInterval(function () {
    var idle = $(document).idleTimer('isIdle');
    heartbeat(idle ? 'IDLE' : 'ACTIVE');
  }, idleTimeout);

  $.idleTimer(idleTimeout);
};
