<%@page import="com.suncode.pwfl.util.SpringContext"%>
<%@page import="org.apache.commons.lang3.StringUtils"%>
<%@ page import="com.suncode.pwfl.administration.configuration.SystemProperties" %>
<%@ page import="com.suncode.pwfl.administration.configuration.DefinedSystemParameter" %>
<%@ page import="com.suncode.pwfl.administration.configuration.SystemType" %>
<%@ page import="com.suncode.pwfl.license.trial.service.TrialService" %>
<%@ page import="com.suncode.pwfl.i18n.MessageHelper" %>
<%@ page import="com.suncode.pwfl.administration.systemMessage.SystemMessageService" %>
<%@ page import="java.util.List" %>
<%@ page import="com.suncode.pwfl.administration.systemMessage.SystemMessage" %>
<%@ page import="com.suncode.pwfl.administration.user.UserContext" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean"%>
<%@ taglib uri="/tags/struts-html" prefix="html"%>
<%@ taglib uri="/tags/struts-logic" prefix="logic"%>
<%@ taglib uri="/tags/struts-tiles" prefix="tiles"%>
<%@ taglib uri="/tags/c" prefix="c"%>
<%@page language="Java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html>
<head>
	<jsp:include page="/pages/util/head_resources.jsp"></jsp:include>
</head>

<%
	TrialService trialService = SpringContext.getBean( TrialService.class );
	String systemTypeValue = SystemProperties.getString( DefinedSystemParameter.SYSTEM_TYPE );
	SystemType systemType = SystemType.fromString( systemTypeValue );
	String systemName = SystemProperties.getString( DefinedSystemParameter.SYSTEM_NAME );

	boolean showVersion = trialService.readLicense().isValid() || systemType != SystemType.PRODUCTION;
	boolean showBar = StringUtils.isNotBlank( systemName ) || showVersion;

	StringBuilder barStringBuilder = new StringBuilder();
	if ( showBar )
	{
		if ( StringUtils.isNotBlank( systemName ) )
		{
			barStringBuilder.append( systemName );
		}

		if ( StringUtils.isNotBlank( systemName ) && showVersion )
		{
			barStringBuilder.append( " - " );
		}

		if ( trialService.readLicense().isValid() )
		{
			barStringBuilder.append( MessageHelper.getMessage( "demoVersion" ) );
		}
		else if ( systemType != SystemType.PRODUCTION )
		{
			barStringBuilder.append( MessageHelper.getMessage( systemType.getMessageKey() ) );
		}
	}

	SystemMessageService systemMessageService = SpringContext.getBean( SystemMessageService.class );

	boolean showAfterLoginSystemMessages = session.getAttribute( "showSystemMessages" ) != null;
	String userName = UserContext.current().getUser().getUserName();
	List systemMessages = systemMessageService.getNewSystemMessagesForUser( userName, showAfterLoginSystemMessages );

	boolean shouldShowSystemMessages = systemMessages.size() > 0;
	if ( showAfterLoginSystemMessages && !shouldShowSystemMessages )
	{
		session.removeAttribute( "showSystemMessages" );
	}
%>

<script type="text/javascript">
	function closeMessage(messageId) {
		const message = jQuery('#system-message-' + messageId);
		const systemMessagesInnerContainer = message.parent()

		if (!this.widthSet) {
			const maxWidth = message.width();
			systemMessagesInnerContainer.children().width(maxWidth)
			this.widthSet = true;
		}

		message.remove()

		const lastMessage = systemMessagesInnerContainer.children().length === 0
		if (lastMessage) {
			systemMessagesInnerContainer.parent().remove()
		}

		const url = Suncode.getAbsolutePath("/api/systemMessage/" + messageId + "/read?lastMessage=" + lastMessage);
		jQuery.ajax({
			type: "POST",
			url: url,
			error: function() {
				PW.ui.Message.error(PW.t('unknownErrorText'));
			}
		})
	}
</script>

<body id="page_bg">

	<% if ( showBar )
	{%>
	<div id="version-bar">
		<%=barStringBuilder.toString()%>
	</div>
	<% } %>

	<div class="body-container">
		<tiles:insert name="body"/>
	</div>
	<div>
		<tiles:insert attribute="menu"/>
	</div>

	<div class="floating-component-container">
	</div>

	<% if ( shouldShowSystemMessages )
	{%>
	<div class="system-messages-wrapper">
		<div class="system-messages-inner-wrapper">
			<c:forEach items="<%=systemMessages%>" var="message">
				<div class="message-wrapper" id="system-message-${message.id}">
					<div class="message-actions">
						<a class="dvnt-icon-x-symbol dvnt-table-gray-icon close-button" onclick="closeMessage(${message.id})"></a>
					</div>
					<div class="message">
							${message.message}
					</div>
				</div>
			</c:forEach>
		</div>
	</div>
	<% } %>
</body>
</html>
