/////////////////// Plug-in file for CalendarXP 9.0 /////////////////
// This file is totally configurable. You may remove all the comments in this file to minimize the download size.
/////////////////////////////////////////////////////////////////////

var _xmlReq; 
var sPath;

function getURLParam(url,strParamName){
  var strReturn = "";
  var strHref = url; //window.location.href;
  if ( strHref.indexOf("?") > -1 ){
    var strQueryString = strHref.substr(strHref.indexOf("?")).toLowerCase();
    var aQueryString = strQueryString.split("&");
    for ( var iParam = 0; iParam < aQueryString.length; iParam++ ){
      if (
aQueryString[iParam].indexOf(strParamName.toLowerCase() + "=") > -1 ){
        var aParam = aQueryString[iParam].split("=");
        strReturn = aParam[1];
        break;
      }
    }
  }
  return unescape(strReturn);
 }
  
function loadXMLDoc(url) {     
    if (window.XMLHttpRequest) { 
        year = getURLParam(url,'year');
        month = getURLParam(url,'date2');
        for (var i=1;i<32;i++)
          fRemoveEvent(year,month,i);
        _xmlReq = new XMLHttpRequest(); 
        _xmlReq.onreadystatechange = processXML; 
        _xmlReq.open("GET", url, true); 
        _xmlReq.send(null); 
    } else if (window.ActiveXObject) { 
        _xmlReq = new ActiveXObject("Microsoft.XMLHTTP"); 
        if (_xmlReq) { 
            _xmlReq.onreadystatechange = processXML; 
            _xmlReq.open("GET", url, true); 
            _xmlReq.send(); 
        } 
    } 
} 

function processXML() { 
     if (_xmlReq.readyState == 4) { 
        if (_xmlReq.status == 200) { 
            var e=_xmlReq.responseXML.getElementsByTagName("event"); 
         for (var i=0; i<e.length; i++) { 
            fAppendEvent(parseAttrib(e[i],"year"), parseAttrib(e[i],"month"), parseAttrib(e[i],"date"), 
            parseText(e[i], "tooltip"), parseText(e[i], "action"), parseAttrib(e[i],"bgcolor"), 
            parseAttrib(e[i],"fgcolor"), parseAttrib(e[i],"bgimg"), parseAttrib(e[i],"border"), 
            parseText(e[i], "html")); 
         } 
         fRepaint(); 
        } else { 
            alert("There was a problem retrieving the XML data:\n" + 
                _xmlReq.statusText); 
        } 
    } 
} 

function parseText(root, tag) { 
   var ns=root.getElementsByTagName(tag); 
   if (ns.length==0) return null; 
   ns=ns[0].childNodes; 
   if (ns.length==0) return ""; 
   else if (ns.length==1) return ns[0].data; 
   else return ns[1].data; 
} 

function parseAttrib(root, attr) { 
   var n=root.getAttributeNode(attr); 
   return n?n.value:null; 
}

///////////// Calendar Onchange Handler ////////////////////////////
// It's triggered whenever the calendar gets changed to y(ear),m(onth),d(ay)
// d = 0 means the calendar is about to switch to the month of (y,m); 
// d > 0 means a specific date [y,m,d] is about to be selected.
// e is a reference to the triggering event object
// Return a true value will cancel the change action.
// NOTE: DO NOT define this handler unless you really need to use it.
////////////////////////////////////////////////////////////////////
// function fOnChange(y,m,d,e) {}


///////////// Calendar AfterSelected Handler ///////////////////////
// It's triggered whenever a date gets fully selected.
// The selected date is passed in as y(ear),m(onth),d(ay)
// e is a reference to the triggering event object
// NOTE: DO NOT define this handler unless you really need to use it.
////////////////////////////////////////////////////////////////////
function fAfterSelected(path,y,m,d,e) {
	var w=fDate2W(y,m,d);
	var dt=fW2Date(w[0],w[1],1);
	//popup("dhtmlgoodies-week-planner1.jsp?initDate="+dt[0]+"-"+dt[1]+"-"+dt[2],"_top");
	popup(path+"/ShowOneWeek.do?initDate="+dt[0]+"-"+dt[1]+"-"+dt[2],"_top");
}


///////////// Calendar Cell OnDrag Handler ///////////////////////
// It triggered when you try to drag a calendar cell. (y,m,d) is the cell date. 
// aStat = 0 means a mousedown is detected (dragstart)
// aStat = 1 means a mouseover between dragstart and dragend is detected (dragover)
// aStat = 2 means a mouseup is detected (dragend)
// e is a reference to the triggering event object
// NOTE: DO NOT define this handler unless you really need to use it.
////////////////////////////////////////////////////////////////////
// function fOnDrag(y,m,d,aStat,e) {}



////////////////// Calendar OnResize Handler ///////////////////////
// It's triggered after the calendar panel has finished drawing.
// NOTE: DO NOT define this handler unless you really need to use it.
////////////////////////////////////////////////////////////////////
function fOnResize() {
	if (NN4) return;	// re-stretch doesn't work in NN4
	// Strech-fix: resize the internal layer in accordance with the highest cell of the same week because the agenda contents could stretch the cell higher than preset value.
	// This fix is not required if the contents never overflow or you never use box-effect or gbFocus.
	var divs=IE4?document.all.tags("DIV"):document.getElementsByTagName("DIV"), cells=[];
	var j=0, maxH=0;
	for (var i=0;i<divs.length;i++)
		if (divs[i].className=="CalCell") {
			cells[j++]=divs[i];
			maxH=Math.max(maxH,divs[i].offsetHeight);
			if (j%7==0&&giCellHeight<maxH) {
				for (var k=1;k<=7; k++)
					cells[j-k].style.height=maxH+"px";
				maxH=0;
			}
		}
}

////////////////// Calendar fOnWeekClick Handler ///////////////////////
// It's triggered when the week number is clicked.
// NOTE: DO NOT define this handler unless you really need to use it.
////////////////////////////////////////////////////////////////////
function fOnWeekClick(year, weekNo) {
	var dt = fW2Date(year, weekNo, 1);
	popup("dhtmlgoodies-week-planner2.jsp?initDate="+dt[0]+"-"+dt[1]+"-"+dt[2],"_top");
}

////////////////// Calendar fOnDoWClick Handler ///////////////////////
// It's triggered when the week head (day of week) is clicked.
// dow ranged from 0-6 while 0 denotes Sunday, 6 denotes Saturday.
// NOTE: DO NOT define this handler unless you really need to use it.
////////////////////////////////////////////////////////////////////
// function fOnDoWClick(year, month, dow) {}


////////////////// Calendar fIsSelected Callback ///////////////////////
// It's triggered for every date passed in as y(ear) m(onth) d(ay). And if 
// the return value is true, that date will be rendered using the giMarkSelected,
// gcFGSelected, gcBGSelected and guSelectedBGImg theme options.
// NOTE: If NOT defined here, the engine will create one that checks the gdSelect only.
////////////////////////////////////////////////////////////////////
// function fIsSelected(y,m,d) {
//		return gdSelect[2]==d&&gdSelect[1]==m&&gdSelect[0]==y;
// }

////////////////// Calendar fOnload Handler ///////////////////////
// It's triggered when the calendar engine is fully loaded by the browser.
// NOTE: DO NOT define this handler unless you really need to use it.
////////////////////////////////////////////////////////////////////
//function fOnload() {     if (!__isAS) loadXMLDoc("getXmlAgenda.jsp?"+new Date().getTime()); }

function fOnload2(month,year) 
{     
	if (!__isAS) 
			loadXMLDoc(sPath+"/GetEventsForMonth.do?year="+year+"&date2="+month); 
}

function fOnload(path) {  sPath = path;   if (!__isAS) loadXMLDoc(path+"/GetEventsForMonth.do?date="+new Date().getTime()); }

// ====== predefined utility functions for use with agendas. ========
// load an url in the window/frame designated by "framename".
function popup(url,framename) {	
	var w=parent.open(url,framename,"top=200,left=200,width=400,height=200,scrollbars=1,resizable=1");
	if (w&&url.split(":")[0]=="mailto") w.close();
	else if (w&&!framename) w.focus();
}

// ====== Following are self-defined and/or custom-built functions! =======
if(NN4)_nn4_css.push("MsgBoard");	// to workaround NN4 CSS bugs, you should call _nn4_css.push() like this for every new CSS class you introduced into the calendar.

gsCalTitle="'<DIV><table width=100% class=CalTitle><tr><td align=left valign=middle>'+fGetPrevMon()+'</td><td align=center valign=middle class=CalTitle>'+"+gsCalTitle+"+'</td><td align=right valign=middle>'+fGetNextMon()+'</td></tr></table></DIV>'";

function fGetPrevMon() {
	var prev=gCurMonth[1]-1;
	if (prev<1) prev=12;
	return "<A id='navPrev' href='javascript:void(0)' class='MonthNav' onclick='fOnload2(\""+prev+"\",\""+gCurMonth[0]+"\");showPrevMon();stopShowMon();return false' onmouseup='stopShowMon()' onmouseout='stopShowMon();if(this.blur)this.blur()'>&nbsp;&laquo; "+gMonths[prev-1].substring(0,3)+"</A>";
}

function fGetNextMon() {
	var next=gCurMonth[1]+1;
	if (next>12) next=1;
	return "<A id='navNext' href='javascript:void(0)' class='MonthNav' onclick='fOnload2(\""+next+"\",\""+gCurMonth[0]+"\");fRepaint();showNextMon();stopShowMon();return false' onmouseup='stopShowMon()' onmouseout='stopShowMon();if(this.blur)this.blur()'>"+gMonths[next-1].substring(0,3)+" &raquo;&nbsp;</A>";
}


// We create a function here to show you how to append multiple events to a day
// Note: Must use onmousedown for sub-events, onclick won't work in sub-events!!
function fAppendEvent(y, m, d, message, action, bgcolor, fgcolor, bgimg, boxit, html) {
	var ag=fHoliday(y,m,d);
	if (ag==null) fAddEvent(y, m, d, message, action, bgcolor, fgcolor, bgimg, boxit, html);
	else fAddEvent(y, m, d, ag[0]?ag[0]:message, action?action:ag[1], bgcolor?bgcolor:ag[2], fgcolor?fgcolor:ag[3], bgimg?bgimg:ag[4], boxit?boxit:ag[5], ag[6]?ag[6]+html:html);
}
