<%@ page import="com.suncode.pwfl.administration.configuration.SystemProperties" %>
<%@ page import="com.suncode.pwfl.administration.configuration.DefinedSystemParameter" %>
<%@page language="Java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/tags/struts-bean" prefix="bean"%>
<%@ taglib uri="/tags/struts-html" prefix="html"%>
<%@ taglib uri="/tags/struts-logic" prefix="logic"%>
<%@ taglib uri="/tags/c" prefix="c"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@ taglib uri="http://ajaxtags.org/tags/ajax" prefix="ajax"%>

<%
    int iPageSize = ( new Integer( (String) request.getAttribute( "iPageSize" ) ) ).intValue();
    Integer size1 = new Integer( (String) request.getAttribute( "iMaxPageSize" ) );
    Integer documentsFound = (Integer) request.getAttribute( "documentCount" );
%>

<script type="text/javascript">

    function showLoadingMask(id, msg) {
        var maskDiv = Ext.DomHelper.append(Ext.getBody(), {tag: 'div', id: id}, true);
        maskDiv.setStyle({
            'position': 'fixed',
            'left': 0,
            'top': 0,
            'width': '100%',
            'height': '100%',
            'z-index': 20000
        });

        var mask = new Ext.LoadMask(maskDiv, {msg: msg});
        mask.show();
    }

    var ii = 0;

    function Viewer(text) {
        var text2 = 'menubar=no,toolbar=no,location=no,directories=no,status=no,scrollbars=yes,resizable=yes,fullscreen=no,channelmode=no,width=' + screen.width / 2 + ',height=' + screen.height + ',left=' + screen.width / 2 + ',top=0';
        window.open(text, 'viewer', text2).focus();
    }

    /**
     * Wyświetla komunikat z prośbą o potwierdzenie usunięcia znalezionych dokumentów.
     */
    function confirmDocumentDelete() {
        return confirm('<bean:message key="Czy_na_pewno_chcesz_usunac"/>');
    }

   	function validateUploadFile() {
       	if (validateFileChoice() && validateCommentLength()) {
       		return true;
       	}
       	return false;
	}

   	function validateFileChoice() {
       	var file = jQuery("#theFile").val();

       	if (file) {
       		return true;
       	}
       	PW.ui.Message.error('<bean:message key="Nie_wybrano_pliku"/>');
	   		return false;
       }

   	function validateCommentLength() {
   		var comment = jQuery("#comment").val();

   		if (comment.length >= 255) {
   			PW.ui.Message.error('<bean:message key="Komentarz_nie_moze_byc_dluzszy_niz_255_znakow"/>');
   			return false;
   		}
   		
   		if (comment.length < 1) {
   			PW.ui.Message.error('<bean:message key="Komentarz_nie_moze_byc_pusty"/>');
   			return false;
   		}
   		
   		return true;
   	}

    function deleteFoundDocuments(deleteUrl, size1) {
        var requiresCaptcha = <%=SystemProperties.getBoolean(DefinedSystemParameter.ADDITIONAL_CAPTCHA_CONFIRMATION)%>;

        PW.ui.CaptchaConfirmation.show({
            title: PW.t('warningText'),
            requiresCaptcha: requiresCaptcha,
            msg: PW.ui.CaptchaConfirmation.getBulkDeleteMessage('documents', size1, requiresCaptcha),
            fn: function () {
                new AjaxJspTag.PreFunctionUpdateInvoke({
                    href: deleteUrl,
                    id: 'documents',
                    evalScripts: true,
                    preFunction: PW.ui.showLoading,
                    postFunction: PW.ui.hideLoading
                })
            },
            scope: window
        })
    }
</script>

<div id="documents">
<div class="content-container">

	<div class="content-header">
        <table>
            <tr>
                <td>
                    <p><bean:message key="Znalezione_dokumenty"/> - <c:out value="${archiveName}" /></p>
                </td>
                <td class="actions">
                    <%
                	    if ( size1 >= 0 && documentsFound > 0)
                	    {%>
                				<c:if test="${canDelete=='TRUE'}">
                					<c:url value="/DeleteSearchedDocuments.do" var="deleteUrl" ></c:url>
                					<a href="javascript://nop/" class="form-button" onclick="deleteFoundDocuments('${deleteUrl}', <%=size1%>)" id="button"><bean:message key="Usun_znalezione_dokumenty" /></a>
                				</c:if>

                				<c:if test="${canPrint=='TRUE'}">
                					<c:url value="/PrintSearchedDocuments.do" var="printUrl" ></c:url>
                					<a href="<c:out value="${printUrl}" />" id="button" class="form-button"><bean:message key="Drukuj_znalezione_dokumenty" /></a>
                				</c:if>
                		<%}%>
                </td>
            </tr>
        </table>
	</div>

	<jsp:include page="/pages/archive/archiveFilters.jsp" flush="true">
		<jsp:param name="source" value="docclass"/>
		<jsp:param name="searchResults" value="true"/>
	</jsp:include>

	<div id="documentsTable">
		<jsp:include page="/pages/archive/searchDocClassResultTable.jsp" flush="true"></jsp:include>
	</div>

</div>
</div>
