/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.util.extension.procesFaktur.plusefaktura;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.search.GroupIndexFilter;
import com.suncode.pwfl.archive.search.IndexFilter;
import com.suncode.pwfl.archive.search.SimpleIndexFilter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.LogicOperator;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClientTools {
    public static Logger log = Logger.getLogger(ClientTools.class);

    public static List<WfDocument> getDocFromArchive(String sDocName, Map<String, String> mCriteriaParam, List<String> lSearchParam) throws Exception {
        int i;
        log.trace((Object)"************************* getDocFromArchive() ********************");
        log.trace((Object)("PARAM1: sDocName = " + sDocName));
        ArrayList<GroupIndexFilter> hmSearchIndecies = new ArrayList<GroupIndexFilter>();
        log.debug((Object)("Nazwa klasy dokumentu: " + sDocName));
        HashMap<Long, String> indexIds = new HashMap<Long, String>();
        log.debug((Object)"Stworzenie kryteriow wyszukiwania");
        GroupIndexFilter gif = new GroupIndexFilter(LogicOperator.AND);
        Object[] keys = mCriteriaParam.keySet().toArray();
        for (i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            DocumentClassIndex searchIndex = ClientTools.getIndexByNameInDocClass(sDocName, key);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date convertedCurrentDate = sdf.parse(mCriteriaParam.get(key));
            gif.addFilter((SQLFilter[])new IndexFilter[]{new SimpleIndexFilter(searchIndex.getId(), (Object)convertedCurrentDate, FilterOperator.GE)});
            gif.addFilter((SQLFilter[])new IndexFilter[]{new SimpleIndexFilter(searchIndex.getId(), (Object)convertedCurrentDate, FilterOperator.LE)});
            indexIds.put(searchIndex.getId(), key);
        }
        log.debug((Object)"Stworzenie kryteriow wyszukiwania");
        for (i = 0; i < lSearchParam.size(); ++i) {
            DocumentClassIndex searchIndex = ClientTools.getIndexByNameInDocClass(sDocName, lSearchParam.get(i));
            gif.addFilter((SQLFilter[])new IndexFilter[]{new SimpleIndexFilter(searchIndex.getId(), (Object)"", FilterOperator.ISNULL)});
            indexIds.put(searchIndex.getId(), lSearchParam.get(i));
        }
        hmSearchIndecies.add(gif);
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        DocumentClass documentClass = documentClassService.getDocumentClass(sDocName, new String[]{"indexes"});
        DocumentFinder documentFinder = FinderFactory.getDocumentFinder();
        ArrayList sorters = new ArrayList();
        CountedResult result = documentFinder.findByIndexes(documentClass.getId(), hmSearchIndecies, sorters, Integer.valueOf(0), Integer.valueOf(10000), new String[0]);
        List alDocuments = result.getData();
        return alDocuments;
    }

    public static DocumentClassIndex getIndexByNameInDocClass(String docClassName, String indexName) {
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        DocumentClass documentClass = documentClassService.getDocumentClass(docClassName, new String[0]);
        DocumentClassIndexFinder documentClassIndexFinder = FinderFactory.getDocumentClassIndexFinder();
        DocumentClassIndex returnIndex = null;
        if (documentClass != null) {
            Long docClassId = documentClass.getId();
            log.debug((Object)("docClassId=" + docClassId));
            log.debug((Object)"Pobieranie indeks\u00f3w klasy dokument\u00f3w.");
            List indexes = documentClassIndexFinder.findByDocumentClass(docClassId);
            for (DocumentClassIndex documentClassIndex : indexes) {
                if (documentClassIndex.getName().compareTo(indexName) != 0) continue;
                returnIndex = documentClassIndex;
                break;
            }
        }
        return returnIndex;
    }

    public static DocumentClassIndex getIndexByIdInDocClass(String docClassName, String indexId) {
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        DocumentClass documentClass = documentClassService.getDocumentClass(docClassName, new String[0]);
        DocumentClassIndexFinder documentClassIndexFinder = FinderFactory.getDocumentClassIndexFinder();
        DocumentClassIndex returnIndex = null;
        if (documentClass != null) {
            Long docClassId = documentClass.getId();
            log.debug((Object)("docClassId=" + docClassId));
            log.debug((Object)"Pobieranie indeks\u00f3w klasy dokument\u00f3w.");
            List indexes = documentClassIndexFinder.findByDocumentClass(docClassId);
            for (DocumentClassIndex documentClassIndex : indexes) {
                if (documentClassIndex.getId() != Long.parseLong(indexId)) continue;
                returnIndex = documentClassIndex;
                break;
            }
        }
        return returnIndex;
    }
}

