/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.library.tim.pzmodule;

import com.plusmpm.database.hibernate.HibernateUtil;
import com.suncode.client.library.tim.P0023.P0023GetData;
import com.suncode.client.library.tim.integrations.IntegrationAX;
import com.suncode.client.library.tim.pzmodule.entities.AdoptionDetails;
import com.suncode.client.library.tim.pzmodule.entities.Pz;
import com.suncode.client.library.tim.pzmodule.entities.PzDetails;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.util.FinderFactory;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Property;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class PzManager {
    public static Logger log = Logger.getLogger(PzManager.class);
    public static Logger findEndedPz = Logger.getLogger(PzManager.class);

    public static Long addPzToInternallDB(Pz pz) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            try {
                transaction = session.beginTransaction();
                session.saveOrUpdate((Object)pz);
                Long pzId = (long)pz.getPzId();
                transaction.commit();
                Long l = pzId;
                return l;
            }
            catch (ConstraintViolationException conVioEx) {
                try {
                    log.debug((Object)"Istnieje juz wspis o takim numerze PZ ");
                    transaction.rollback();
                    throw conVioEx;
                }
                catch (HibernateException he) {
                    try {
                        if (transaction != null && session.isOpen()) {
                            transaction.rollback();
                        }
                        throw he;
                    }
                    catch (HibernateException he1) {
                        log.error((Object)he.getMessage(), (Throwable)he1);
                        throw he1;
                    }
                }
            }
        }
        finally {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException he) {
                log.error((Object)he.getMessage(), (Throwable)he);
                throw he;
            }
        }
    }

    public static void savePzDetailsInDB(PzDetails pzDetails) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            try {
                transaction = session.beginTransaction();
                session.saveOrUpdate((Object)pzDetails);
                transaction.commit();
                return;
            }
            catch (ConstraintViolationException conVioEx) {
                try {
                    log.debug((Object)"Istnieje juz wspis o takim numerze PZ ");
                    transaction.rollback();
                    throw conVioEx;
                }
                catch (HibernateException he) {
                    try {
                        if (transaction != null && session.isOpen()) {
                            transaction.rollback();
                        }
                        throw he;
                    }
                    catch (HibernateException he1) {
                        log.error((Object)he.getMessage(), (Throwable)he1);
                        throw he1;
                    }
                }
            }
        }
        finally {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException he) {
                log.error((Object)he.getMessage(), (Throwable)he);
                throw he;
            }
        }
    }

    public static Long updatePzInInternallDB(Pz pz) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.update((Object)pz);
            Long pzId = pz.getPzId();
            transaction.commit();
            Long l = pzId;
            return l;
        }
        catch (HibernateException he) {
            try {
                if (transaction != null && session.isOpen()) {
                    transaction.rollback();
                }
            }
            catch (HibernateException he1) {
                log.error((Object)he.getMessage(), (Throwable)he1);
                Long l = -1L;
                return l;
            }
            throw he;
        }
        finally {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException he) {
                log.error((Object)he.getMessage(), (Throwable)he);
                return -1L;
            }
        }
    }

    public static Pz getPzByIdFromInternallDB(Long pzId) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Pz pz = (Pz)session.get(Pz.class, (Serializable)pzId);
            transaction.commit();
            Pz pz2 = pz;
            return pz2;
        }
        catch (HibernateException he) {
            try {
                if (transaction != null && session.isOpen()) {
                    transaction.rollback();
                }
            }
            catch (HibernateException he1) {
                log.error((Object)he.getMessage(), (Throwable)he1);
            }
            throw he;
        }
        finally {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException he) {
                log.error((Object)he.getMessage(), (Throwable)he);
            }
        }
    }

    public static void removePzFromInternallDB(Pz pz) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.delete((Object)pz);
            transaction.commit();
        }
        catch (HibernateException he) {
            try {
                if (transaction != null && session.isOpen()) {
                    transaction.rollback();
                }
            }
            catch (HibernateException he1) {
                log.error((Object)he.getMessage(), (Throwable)he1);
            }
            throw he;
        }
        finally {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException he) {
                log.error((Object)he.getMessage(), (Throwable)he);
            }
        }
    }

    public static void removePzDetailsFromInternallDB(PzDetails pzDetails) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.delete((Object)pzDetails);
            transaction.commit();
        }
        catch (HibernateException he) {
            try {
                if (transaction != null && session.isOpen()) {
                    transaction.rollback();
                }
            }
            catch (HibernateException he1) {
                log.error((Object)he.getMessage(), (Throwable)he1);
            }
            throw he;
        }
        finally {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException he) {
                log.error((Object)he.getMessage(), (Throwable)he);
            }
        }
    }

    public static List<Pz> getPzByParamFromInternallDB(Pz pz) {
        Session session = null;
        Transaction transaction = null;
        try {
            List result;
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(Pz.class);
            criteria.add((Criterion)Example.create((Object)pz));
            List list = result = criteria.list();
            return list;
        }
        catch (HibernateException he) {
            try {
                if (transaction != null && session.isOpen()) {
                    transaction.rollback();
                }
            }
            catch (HibernateException he1) {
                log.error((Object)he.getMessage(), (Throwable)he1);
            }
            throw he;
        }
        finally {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException he) {
                log.error((Object)he.getMessage(), (Throwable)he);
            }
        }
    }

    public static Pz getPzByDocNumber(String supplierCode, String docNr) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> result = null;
        Connection con = null;
        ArrayList<PzDetails> pzDetails = null;
        Pz pz = null;
        try {
            StringBuilder query = new StringBuilder("SELECT details.RecordId as rowid, details.AwizoNum as id, '' as longId, details.ItemId as indeks, details.Qty as ilosc, details.Price As cena, details.PurchId As zamowienie, details.PurchLineNum as Linia FROM WfwAwizoLineView_Bon as details WHERE details.VendAccount='");
            query = query.append(supplierCode.trim());
            query = query.append("' and details.AwizoNum = '");
            query = query.append(docNr);
            query = query.append("'");
            con = IntegrationAX.getConnectionWithAX();
            pz = new Pz(docNr, supplierCode);
            pzDetails = new ArrayList<PzDetails>();
            result = IntegrationAX.execute(con, query.toString());
            for (Map<String, String> row : result) {
                String nazwa = "";
                if (!StringUtils.isBlank((CharSequence)row.get("indeks"))) {
                    nazwa = PzManager.getGoodsNameByIndeks(row.get("indeks"));
                }
                PzDetails pzDetail = new PzDetails(row.get("rowid"), row.get("id"), row.get("longId"), row.get("indeks"), row.get("zamowienie"), row.get("Linia"), row.get("ilosc"), row.get("cena"), nazwa, false, pz);
                pzDetails.add(pzDetail);
            }
            pz.setPzDetails(pzDetails);
            Pz pz2 = pz;
            return pz2;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (con == null) {
                throw new NullPointerException("Connection is null");
            }
            con.close();
        }
    }

    public static Pz getPzByDocNumber(String supplierCode, String docNr, Connection axConncetion) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> result = null;
        ArrayList<PzDetails> pzDetails = null;
        Pz pz = null;
        try {
            StringBuilder query = new StringBuilder("SELECT details.RecordId as rowid, details.AwizoNum as id, '' as longId, details.ItemId as indeks, details.Qty as ilosc, details.Price As cena, details.PurchId As zamowienie, details.PurchLineNum as Linia FROM WfwAwizoLineView_Bon as details WHERE details.VendAccount='");
            query = query.append(supplierCode.trim());
            query = query.append("' and details.AwizoNum = '");
            query = query.append(docNr.toLowerCase());
            query = query.append("'");
            pz = new Pz(docNr, supplierCode);
            pzDetails = new ArrayList<PzDetails>();
            result = IntegrationAX.execute(axConncetion, query.toString());
            if (result == null || result.isEmpty()) {
                return null;
            }
            Map<String, String> indeciesAndNames = null;
            try {
                if (result != null && !result.isEmpty()) {
                    indeciesAndNames = PzManager.getGoodsNameByIndeks(result, axConncetion);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            for (Map<String, String> row : result) {
                String productName = "";
                if (indeciesAndNames != null) {
                    productName = indeciesAndNames.get(row.get("indeks").toUpperCase());
                }
                PzDetails pzDetail = new PzDetails(row.get("rowid"), row.get("id"), row.get("longId"), row.get("indeks"), row.get("zamowienie"), row.get("Linia"), row.get("ilosc"), row.get("cena"), productName, false, pz);
                pzDetails.add(pzDetail);
            }
            pz.setPzDetails(pzDetails);
            return pz;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Pz getPzByDocNumber(String supplierCode, String nrDok, String PzNumber, Connection axConnection) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> result = null;
        ArrayList<PzDetails> pzDetails = null;
        Pz pz = null;
        try {
            StringBuilder query = new StringBuilder("SELECT details.RecordId as rowid, details.AwizoNum as id, '' as longId, details.ItemId as indeks, details.Qty as ilosc, details.Price As cena, details.PurchId As zamowienie, details.PurchLineNum as Linia FROM WfwAwizoLineView_Bon as details INNER JOIN WfwAwizoTableView_Bon as header ON header.VendAccount = details.VendAccount and header.AwizoNum = details.AwizoNum WHERE details.VendAccount='");
            query = query.append(supplierCode.trim());
            query = query.append("' and details.AwizoNum = '");
            query = query.append(PzNumber.toLowerCase().trim());
            query = query.append("' and header.DeliveryDate > '");
            query = query.append(P0023GetData.modyfiCurrentDate(PzManager.getNumberOfDaysBack()));
            query = query.append("'");
            pz = new Pz(nrDok, supplierCode);
            pzDetails = new ArrayList<PzDetails>();
            result = IntegrationAX.execute(axConnection, query.toString());
            if (result == null || result.isEmpty()) {
                return null;
            }
            Map<String, String> indeciesAndNames = null;
            try {
                if (result != null && !result.isEmpty()) {
                    indeciesAndNames = PzManager.getGoodsNameByIndeks(result, axConnection);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            for (Map<String, String> row : result) {
                String productName = "";
                if (indeciesAndNames != null) {
                    productName = indeciesAndNames.get(row.get("indeks").toUpperCase());
                }
                PzDetails pzDetail = new PzDetails(row.get("rowid"), row.get("id"), row.get("longId"), row.get("indeks"), row.get("zamowienie"), row.get("Linia"), row.get("ilosc"), row.get("cena"), productName, false, pz);
                pzDetails.add(pzDetail);
            }
            pz.setPzDetails(pzDetails);
            return pz;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Pz getPzByDocNumber(String supplierCode, String nrDok, String PzNumber, Connection axConnection, String spolka) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> result = null;
        ArrayList<PzDetails> pzDetails = null;
        Pz pz = null;
        try {
            StringBuilder query = new StringBuilder("SELECT details.RecordId as rowid, details.AwizoNum as id, '' as longId, details.ItemId as indeks, details.Qty as ilosc, details.Price As cena, details.PurchId As zamowienie, details.PurchLineNum as Linia FROM WfwAwizoLineView_Bon as details INNER JOIN WfwAwizoTableView_Bon as header ON header.VendAccount = details.VendAccount and header.AwizoNum = details.AwizoNum WHERE details.VendAccount='");
            query = query.append(supplierCode.trim());
            query = query.append("' and details.AwizoNum = '");
            query = query.append(PzNumber.toLowerCase().trim());
            query = query.append("' AND details.COMPANY = '");
            query = query.append(spolka);
            query = query.append("' and header.DeliveryDate > '");
            query = query.append(P0023GetData.modyfiCurrentDate(PzManager.getNumberOfDaysBack()));
            query = query.append("'");
            query = query.append(" AND header.COMPANY = '");
            query = query.append(spolka);
            query = query.append("'");
            pz = new Pz(nrDok, supplierCode);
            pzDetails = new ArrayList<PzDetails>();
            result = IntegrationAX.execute(axConnection, query.toString());
            if (result == null || result.isEmpty()) {
                return null;
            }
            Map<String, String> indeciesAndNames = null;
            try {
                if (result != null && !result.isEmpty()) {
                    indeciesAndNames = PzManager.getGoodsNameByIndeks(result, axConnection, spolka);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            for (Map<String, String> row : result) {
                String productName = "";
                if (indeciesAndNames != null) {
                    productName = indeciesAndNames.get(row.get("indeks").toUpperCase());
                }
                PzDetails pzDetail = new PzDetails(row.get("rowid"), row.get("id"), row.get("longId"), row.get("indeks"), row.get("zamowienie"), row.get("Linia"), row.get("ilosc"), row.get("cena"), productName, false, pz);
                pzDetails.add(pzDetail);
            }
            pz.setPzDetails(pzDetails);
            return pz;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Set<String> getPzNumberByOrder(String order, Connection MFG2Conncetion) throws ClassNotFoundException, SQLException {
        HashSet<String> pzNumbers = null;
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT DISTINCT AwizoNum as ID FROM dbo.WfwAwizoLineView_Bon WHERE PurchId = '");
            query = query.append(order);
            query = query.append("'");
            result = IntegrationAX.execute(MFG2Conncetion, query.toString());
            pzNumbers = new HashSet<String>();
            for (Map<String, String> row : result) {
                if (StringUtils.isBlank((CharSequence)row.get("ID"))) continue;
                pzNumbers.add(row.get("ID").trim());
            }
            return pzNumbers;
        }
        catch (NullPointerException nullEx) {
            log.error((Object)nullEx.getMessage(), (Throwable)nullEx);
            throw nullEx;
        }
        catch (SQLException sqlEx) {
            log.error((Object)sqlEx.getMessage(), (Throwable)sqlEx);
            throw sqlEx;
        }
    }

    public static Set<String> getPzNumberByOrder(String order, Connection MFG2Conncetion, String spolka) throws ClassNotFoundException, SQLException {
        HashSet<String> pzNumbers = null;
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT DISTINCT AwizoNum as ID FROM dbo.WfwAwizoLineView_Bon WHERE PurchId = '");
            query = query.append(order);
            query = query.append("'");
            query = query.append(" AND COMPANY = '");
            query = query.append(spolka);
            query = query.append("'");
            result = IntegrationAX.execute(MFG2Conncetion, query.toString());
            pzNumbers = new HashSet<String>();
            for (Map<String, String> row : result) {
                if (StringUtils.isBlank((CharSequence)row.get("ID"))) continue;
                pzNumbers.add(row.get("ID").trim());
            }
            return pzNumbers;
        }
        catch (NullPointerException nullEx) {
            log.error((Object)nullEx.getMessage(), (Throwable)nullEx);
            throw nullEx;
        }
        catch (SQLException sqlEx) {
            log.error((Object)sqlEx.getMessage(), (Throwable)sqlEx);
            throw sqlEx;
        }
    }

    private static String getGoodsNameByIndeks(String indeks) throws ClassNotFoundException, SQLException {
        Connection con = null;
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT ItemName as NAZWA FROM dbo.WfwInventTableView_Bon WHERE ItemId = '");
            query = query.append(indeks);
            query = query.append("'");
            con = IntegrationAX.getConnectionWithAX();
            result = IntegrationAX.execute(con, query.toString());
            for (Map<String, String> row : result) {
                if (StringUtils.isBlank((CharSequence)row.get("NAZWA"))) continue;
                String string = row.get("NAZWA").trim();
                return string;
            }
            Iterator<Map<String, String>> iterator = null;
            return iterator;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (con == null) {
                throw new NullPointerException("Connection is null");
            }
            if (!con.isClosed()) {
                con.close();
            }
        }
    }

    private static Map<String, String> getGoodsNameByIndeks(List<Map<String, String>> pzData, Connection MFG2XConnection, String spolka) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> queryResult = null;
        HashMap<String, String> result = new HashMap<String, String>();
        String indecies = "";
        try {
            StringBuilder query = new StringBuilder("SELECT ItemName as NAZWA, ItemId as INDEKS FROM dbo.WfwInventTableView_Bon WHERE ItemId IN (");
            for (Map<String, String> data : pzData) {
                String indeks = data.get("indeks");
                if (StringUtils.isBlank((CharSequence)indeks)) continue;
                if (indecies.compareTo("") != 0) {
                    indecies = indecies.concat(",");
                }
                indecies = indecies.concat("'");
                indecies = indecies.concat(indeks);
                indecies = indecies.concat("'");
            }
            query = query.append(indecies);
            query = query.append(")");
            query = query.append(" AND COMPANY = '");
            query = query.append(spolka);
            query = query.append("'");
            queryResult = IntegrationAX.execute(MFG2XConnection, query.toString());
            for (Map<String, String> map : queryResult) {
                if (StringUtils.isBlank((CharSequence)map.get("INDEKS"))) continue;
                if (!StringUtils.isBlank((CharSequence)map.get("NAZWA"))) {
                    result.put(map.get("INDEKS").toUpperCase(), map.get("NAZWA"));
                    continue;
                }
                result.put(map.get("INDEKS").toUpperCase(), "");
            }
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private static Map<String, String> getGoodsNameByIndeks(List<Map<String, String>> pzData, Connection MFG2XConnection) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> queryResult = null;
        HashMap<String, String> result = new HashMap<String, String>();
        String indecies = "";
        try {
            StringBuilder query = new StringBuilder("SELECT ItemName as NAZWA, ItemId as INDEKS FROM dbo.WfwInventTableView_Bon WHERE ItemId IN (");
            for (Map<String, String> data : pzData) {
                String indeks = data.get("indeks");
                if (StringUtils.isBlank((CharSequence)indeks)) continue;
                if (indecies.compareTo("") != 0) {
                    indecies = indecies.concat(",");
                }
                indecies = indecies.concat("'");
                indecies = indecies.concat(indeks);
                indecies = indecies.concat("'");
            }
            query = query.append(indecies);
            query = query.append(")");
            queryResult = IntegrationAX.execute(MFG2XConnection, query.toString());
            for (Map<String, String> map : queryResult) {
                if (StringUtils.isBlank((CharSequence)map.get("INDEKS"))) continue;
                if (!StringUtils.isBlank((CharSequence)map.get("NAZWA"))) {
                    result.put(map.get("INDEKS").toUpperCase(), map.get("NAZWA"));
                    continue;
                }
                result.put(map.get("INDEKS").toUpperCase(), "");
            }
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Set<String> getIndeksCode(String supplierCode, String productCode, Connection con) throws ClassNotFoundException, SQLException {
        HashSet<String> indeksCode = new HashSet<String>();
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT ItemId as IndeksCode FROM WfwAwizoLineView_Bon WHERE ItemId = '");
            query = query.append(productCode);
            query = query.append("'");
            result = IntegrationAX.execute(con, query.toString());
            for (Map<String, String> row : result) {
                if (StringUtils.isBlank((CharSequence)row.get("IndeksCode"))) continue;
                indeksCode.add(row.get("IndeksCode").trim());
            }
            return indeksCode;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Set<String> getIndeksCode(String supplierCode, String productCode, Connection con, String spolka) throws ClassNotFoundException, SQLException {
        HashSet<String> indeksCode = new HashSet<String>();
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT ItemId as IndeksCode FROM WfwAwizoLineView_Bon WHERE ItemId = '");
            query = query.append(productCode);
            query = query.append("'");
            query = query.append(" AND COMPANY = '");
            query = query.append(spolka);
            query = query.append("'");
            result = IntegrationAX.execute(con, query.toString());
            for (Map<String, String> row : result) {
                if (StringUtils.isBlank((CharSequence)row.get("IndeksCode"))) continue;
                indeksCode.add(row.get("IndeksCode").trim());
            }
            return indeksCode;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static List<Pz> getPzByIndeksCode(String supplierCode, String indeksCode, Connection con) throws ClassNotFoundException, SQLException {
        ArrayList<Pz> pzDocuments = new ArrayList<Pz>();
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT DISTINCT details.RecordId as rowid, details.AwizoNum as longId, main.PackingSlipId as id, details.ItemId as indeks, details.Qty as ilosc, details.Price As cena, details.PurchId As zamowienie, details.PurchLineNum as Linia FROM WfwAwizoLineView_Bon as details INNER JOIN WfwVendPackingSlipByAwizoView_Bon as main on main.AwizoNum = details.AwizoNum and main.VendAccount = details.VendAccount WHERE details.VendAccount='");
            query = query.append(supplierCode.trim());
            query = query.append("' and details.ItemId = '");
            query = query.append(indeksCode);
            query = query.append("' AND main.DeliveryDate > '");
            query = query.append(P0023GetData.modyfiCurrentDate(PzManager.getNumberOfDaysBack()));
            query = query.append("'");
            result = IntegrationAX.execute(con, query.toString());
            for (Map<String, String> row : result) {
                Pz pz = new Pz(row.get("id"), supplierCode);
                PzDetails pzDetails = new PzDetails(row.get("rowid"), row.get("id"), row.get("longId"), row.get("indeks"), row.get("zamowienie"), row.get("Linia"), row.get("ilosc"), row.get("cena"), "", false, pz);
                pzDetails.setPzId(pz);
                pzDocuments.add(pz);
            }
            return pzDocuments;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static List<Pz> getPzByIndeksCode(String supplierCode, String indeksCode, Connection con, String spolka) throws ClassNotFoundException, SQLException {
        ArrayList<Pz> pzDocuments = new ArrayList<Pz>();
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT DISTINCT details.RecordId as rowid, details.AwizoNum as longId, main.PackingSlipId as id, details.ItemId as indeks, details.Qty as ilosc, details.Price As cena, details.PurchId As zamowienie, details.PurchLineNum as Linia FROM WfwAwizoLineView_Bon as details INNER JOIN WfwVendPackingSlipByAwizoView_Bon as main on main.AwizoNum = details.AwizoNum and main.VendAccount = details.VendAccount WHERE details.VendAccount='");
            query = query.append(supplierCode.trim());
            query = query.append("' and details.ItemId = '");
            query = query.append(indeksCode);
            query = query.append("' AND details.COMPANY = '");
            query = query.append(spolka);
            query = query.append("' AND main.DeliveryDate > '");
            query = query.append(P0023GetData.modyfiCurrentDate(PzManager.getNumberOfDaysBack()));
            query = query.append("'");
            query = query.append(" AND main.COMPANY = '");
            query = query.append(spolka);
            query = query.append("'");
            result = IntegrationAX.execute(con, query.toString());
            for (Map<String, String> row : result) {
                Pz pz = new Pz(row.get("id"), supplierCode);
                PzDetails pzDetails = new PzDetails(row.get("rowid"), row.get("id"), row.get("longId"), row.get("indeks"), row.get("zamowienie"), row.get("Linia"), row.get("ilosc"), row.get("cena"), "", false, pz);
                pzDetails.setPzId(pz);
                pzDocuments.add(pz);
            }
            return pzDocuments;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Deprecated
    public static boolean checkAdmittedToMagazine(Connection mfgDataBase, String supplierCode, String docNr) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT DISTINCT main.PackingSlipId as abs_id FROM WfwAwizoLineView_Bon as details INNER JOIN WfwVendPackingSlipByAwizoView_Bon as main on main.AwizoNum = details.AwizoNum WHERE details.VendAccount='");
            query = query.append(supplierCode);
            query = query.append("' and details.AwizoNum = '");
            query = query.append(docNr);
            query = query.append("' and details.Qty = 0");
            result = IntegrationAX.execute(mfgDataBase, query.toString());
            Iterator<Map<String, String>> iterator = result.iterator();
            if (iterator.hasNext()) {
                Map<String, String> row = iterator.next();
                return false;
            }
            return true;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static List<AdoptionDetails> getAdmittedDetails(Connection mfgDataBase, String supplierCode, String docNr) throws ClassNotFoundException, SQLException {
        ArrayList<AdoptionDetails> results = new ArrayList<AdoptionDetails>();
        findEndedPz.trace((Object)"*************GetAdmittedDetails***********");
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT ItemId as prh_element, Qty, Price, InventLocationId as prh_line, VendAccount as prh_receiver, '' as prh_nbr FROM WfwVendPackingSlipTransView_Bon WHERE VendAccount = '");
            query = query.append(supplierCode);
            query = query.append("' AND DeliveryDate > '");
            query = query.append(P0023GetData.modyfiCurrentDate(PzManager.getNumberOfDaysBack()));
            query = query.append("' AND PackingSlipId IN (SELECT PackingSlipId FROM WfwVendPackingSlipByAwizoView_Bon WHERE VendAccount = '");
            query = query.append(supplierCode);
            query = query.append("' and AwizoNum = '");
            query = query.append(docNr);
            query = query.append("' AND DeliveryDate > '");
            query = query.append(P0023GetData.modyfiCurrentDate(PzManager.getNumberOfDaysBack()));
            query = query.append("')");
            findEndedPz.debug((Object)("Zapytanie szukaj\u0105ce szczegolow przyjecia na magazyn :" + query.toString()));
            result = IntegrationAX.execute(mfgDataBase, query.toString());
            if (result == null || result.isEmpty()) {
                throw new NullPointerException("Nie znaleziono szczego\u0142\u00f3w przj\u0119cia przyjecia");
            }
            for (Map<String, String> row : result) {
                AdoptionDetails adoptionDetails = new AdoptionDetails(row.get("prh_nbr"), row.get("prh_receiver"), row.get("prh_line"), row.get("prh_element"));
                Pz pz = new Pz();
                pz.setNrdokumentuPz(docNr);
                adoptionDetails.setPzId(pz);
                results.add(adoptionDetails);
            }
            return results;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static List<AdoptionDetails> getAdmittedDetails(Connection mfgDataBase, String supplierCode, String docNr, String spolka) throws ClassNotFoundException, SQLException {
        ArrayList<AdoptionDetails> results = new ArrayList<AdoptionDetails>();
        findEndedPz.trace((Object)"*************GetAdmittedDetails***********");
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT ItemId as prh_element, Qty, Price, InventLocationId as prh_line, VendAccount as prh_receiver, '' as prh_nbr FROM WfwVendPackingSlipTransView_Bon WHERE VendAccount = '");
            query = query.append(supplierCode);
            query = query.append("' AND DeliveryDate > '");
            query = query.append(P0023GetData.modyfiCurrentDate(PzManager.getNumberOfDaysBack()));
            query = query.append("' AND PackingSlipId IN (SELECT PackingSlipId FROM WfwVendPackingSlipByAwizoView_Bon WHERE VendAccount = '");
            query = query.append(supplierCode);
            query = query.append("' and AwizoNum = '");
            query = query.append(docNr);
            query = query.append("' AND DeliveryDate > '");
            query = query.append(P0023GetData.modyfiCurrentDate(PzManager.getNumberOfDaysBack()));
            query = query.append("' AND COMPANY = '");
            query = query.append(spolka);
            query = query.append("')");
            query = query.append(" AND COMPANY = '");
            query = query.append(spolka);
            query = query.append("'");
            findEndedPz.debug((Object)("Zapytanie szukaj\u0105ce szczegolow przyjecia na magazyn :" + query.toString()));
            result = IntegrationAX.execute(mfgDataBase, query.toString());
            if (result == null || result.isEmpty()) {
                throw new NullPointerException("Nie znaleziono szczego\u0142\u00f3w przj\u0119cia przyjecia");
            }
            for (Map<String, String> row : result) {
                AdoptionDetails adoptionDetails = new AdoptionDetails(row.get("prh_nbr"), row.get("prh_receiver"), row.get("prh_line"), row.get("prh_element"));
                Pz pz = new Pz();
                pz.setNrdokumentuPz(docNr);
                adoptionDetails.setPzId(pz);
                results.add(adoptionDetails);
            }
            return results;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Set<String> getEndedPzNumber(Connection mfgXDataBase, String vendAccount, String awizoNum) throws SQLException, ClassNotFoundException {
        findEndedPz.trace((Object)"*****************GetEndedPzNUmebr***************");
        HashSet<String> results = new HashSet<String>();
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT PackingSlipId AS NR_PZ FROM WfwVendPackingSlipByAwizoView_Bon WHERE AwizoNum = '");
            query = query.append(awizoNum);
            query = query.append("' AND VendAccount = '");
            query = query.append(vendAccount);
            query = query.append("'");
            findEndedPz.debug((Object)("Zapytanie wyszukujace pz koncowe : " + query.toString()));
            result = IntegrationAX.execute(mfgXDataBase, query.toString());
            for (Map<String, String> row : result) {
                if (StringUtils.isBlank((CharSequence)row.get("NR_PZ"))) continue;
                results.add(row.get("NR_PZ").trim());
            }
            return results;
        }
        catch (NullPointerException nullEx) {
            throw nullEx;
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
    }

    public static Set<String> getEndedPzNumber(Connection mfgXDataBase, String vendAccount, String awizoNum, String spolka) throws SQLException, ClassNotFoundException {
        findEndedPz.trace((Object)"*****************GetEndedPzNUmebr***************");
        HashSet<String> results = new HashSet<String>();
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT PackingSlipId AS NR_PZ FROM WfwVendPackingSlipByAwizoView_Bon WHERE AwizoNum = '");
            query = query.append(awizoNum);
            query = query.append("' AND VendAccount = '");
            query = query.append(vendAccount);
            query = query.append("'");
            query = query.append(" AND COMPANY = '");
            query = query.append(spolka);
            query = query.append("'");
            findEndedPz.debug((Object)("Zapytanie wyszukujace pz koncowe : " + query.toString()));
            result = IntegrationAX.execute(mfgXDataBase, query.toString());
            for (Map<String, String> row : result) {
                if (StringUtils.isBlank((CharSequence)row.get("NR_PZ"))) continue;
                results.add(row.get("NR_PZ").trim());
            }
            return results;
        }
        catch (NullPointerException nullEx) {
            throw nullEx;
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
    }

    public static List<Pz> getPzByNotComplitePzNumber(String supplierCode, String notCompliteDocNr) throws ClassNotFoundException, SQLException {
        ArrayList<Pz> pzDocuments = new ArrayList<Pz>();
        Connection con = null;
        List<Map<String, String>> result = null;
        try {
            con = IntegrationAX.getConnectionWithAX();
            if (StringUtils.isBlank((CharSequence)notCompliteDocNr)) {
                ArrayList<Pz> arrayList = pzDocuments;
                return arrayList;
            }
            StringBuilder query = new StringBuilder("SELECT details.RecordId as rowid, details.AwizoNum as id, '' As longId, details.ItemId as indeks, details.Qty as ilosc, details.Price As cena, details.PurchId As zamowienie, details.PurchLineNum as Linia FROM WfwAwizoLineView_Bon as details WHERE details.VendAccount='");
            query = query.append(supplierCode);
            query = query.append("' and details.AwizoNum LIKE ");
            query = query.append("'");
            query = query.append(notCompliteDocNr);
            query = query.append("'");
            result = IntegrationAX.execute(con, query.toString());
            for (Map<String, String> row : result) {
                String nazwa = "";
                if (!StringUtils.isBlank((CharSequence)row.get("indeks"))) {
                    nazwa = PzManager.getGoodsNameByIndeks(row.get("indeks"));
                }
                Pz pz = new Pz(row.get("id"), supplierCode);
                PzDetails pzDetails = new PzDetails(row.get("rowid"), row.get("id"), row.get("longId"), row.get("indeks"), row.get("zamowienie"), row.get("Linia"), row.get("ilosc"), row.get("cena"), nazwa, false);
                pzDetails.setPzId(pz);
                pzDocuments.add(pz);
            }
            ArrayList<Pz> arrayList = pzDocuments;
            return arrayList;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (con == null) {
                throw new NullPointerException("Connection is null");
            }
            if (!con.isClosed()) {
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Long addAdoptionDetailsToInternallDB(AdoptionDetails adoptionDetails) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            try {
                transaction = session.beginTransaction();
                session.save((Object)adoptionDetails);
                Long Id2 = adoptionDetails.getId();
                transaction.commit();
                Long l = Id2;
                return l;
            }
            catch (ConstraintViolationException conVioEx) {
                transaction.rollback();
                log.debug((Object)conVioEx.getMessage(), (Throwable)conVioEx);
                Long l = 0L;
                try {
                    if (session != null && session.isOpen()) {
                        session.close();
                    }
                }
                catch (HibernateException he) {
                    log.error((Object)he.getMessage(), (Throwable)he);
                    return -1L;
                }
                return l;
                catch (HibernateException he) {
                    try {
                        if (transaction != null && session.isOpen()) {
                            transaction.rollback();
                        }
                        throw he;
                    }
                    catch (HibernateException he1) {
                        log.error((Object)he.getMessage(), (Throwable)he1);
                        Long l2 = -1L;
                        return l2;
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException he) {
                log.error((Object)he.getMessage(), (Throwable)he);
                return -1L;
            }
        }
    }

    public static AdoptionDetails getAdoptionDetailsById(Long Id2) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            AdoptionDetails adoptionDetails = (AdoptionDetails)session.get(AdoptionDetails.class, (Serializable)Id2);
            transaction.commit();
            AdoptionDetails adoptionDetails2 = adoptionDetails;
            return adoptionDetails2;
        }
        catch (HibernateException he) {
            try {
                if (transaction != null && session.isOpen()) {
                    transaction.rollback();
                }
            }
            catch (HibernateException he1) {
                log.error((Object)he.getMessage(), (Throwable)he1);
            }
            throw he;
        }
        finally {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException he) {
                log.error((Object)he.getMessage(), (Throwable)he);
            }
        }
    }

    public static Long updateAdoptionDetails(AdoptionDetails adoptionDetails) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            session.update((Object)adoptionDetails);
            Long pzId = adoptionDetails.getId();
            transaction.commit();
            Long l = pzId;
            return l;
        }
        catch (HibernateException he) {
            try {
                if (transaction != null && session.isOpen()) {
                    transaction.rollback();
                }
            }
            catch (HibernateException he1) {
                log.error((Object)he.getMessage(), (Throwable)he1);
                Long l = -1L;
                return l;
            }
            throw he;
        }
        finally {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException he) {
                log.error((Object)he.getMessage(), (Throwable)he);
                return -1L;
            }
        }
    }

    public static Pz getPzByNaturalid(String nrdokumentuPz, String nrDostawcy) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Property nrDoc = Property.forName((String)"nrdokumentuPz");
            Property nrDost = Property.forName((String)"nrDostawcy");
            Pz result = (Pz)session.createCriteria(Pz.class).add((Criterion)nrDoc.eq((Object)nrdokumentuPz)).add((Criterion)nrDost.eq((Object)nrDostawcy)).uniqueResult();
            transaction.commit();
            Pz pz = result;
            return pz;
        }
        catch (HibernateException he) {
            try {
                if (transaction != null && session.isOpen()) {
                    transaction.rollback();
                }
            }
            catch (HibernateException he1) {
                log.error((Object)he.getMessage(), (Throwable)he1);
                Pz pz = null;
                return pz;
            }
            throw he;
        }
        finally {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException he) {
                log.error((Object)he.getMessage(), (Throwable)he);
                return null;
            }
        }
    }

    public static List<PzDetails> getAllPzDetails(Long pzId) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Pz pz = (Pz)session.load(Pz.class, (Serializable)pzId);
            List<PzDetails> result = pz.getPzDetails();
            transaction.commit();
            List<PzDetails> list = result;
            return list;
        }
        catch (HibernateException he) {
            try {
                if (transaction != null && session.isOpen()) {
                    transaction.rollback();
                }
            }
            catch (HibernateException he1) {
                log.error((Object)he.getMessage(), (Throwable)he1);
                List<PzDetails> list = null;
                return list;
            }
            throw he;
        }
        finally {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (HibernateException he) {
                log.error((Object)he.getMessage(), (Throwable)he);
                return null;
            }
        }
    }

    public static Map<String, Map<String, String>> getEndedPzData(Connection axConnection, String[] endedPzNumbersTab, String nrDostawcy) throws SQLException {
        findEndedPz.trace((Object)"***************GetEndedPzData***********");
        Double value = 0.0;
        List<Map<String, String>> result1 = null;
        HashSet<String> indeciesNr = null;
        ArrayList<Map<String, String>> result2 = null;
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>();
        StringBuilder endedPzNumbersForQuery = null;
        try {
            endedPzNumbersForQuery = new StringBuilder();
            indeciesNr = new HashSet<String>();
            StringBuilder query1 = new StringBuilder("SELECT PackingSlipId as xxtr_trnbr FROM WfwVendPackingSlipByAwizoView_Bon as main WHERE main.PackingSlipId IN(");
            for (String onePzNumber : endedPzNumbersTab) {
                if (StringUtils.isBlank((CharSequence)onePzNumber)) continue;
                if (!StringUtils.isBlank((CharSequence)endedPzNumbersForQuery.toString())) {
                    endedPzNumbersForQuery.append(",");
                }
                endedPzNumbersForQuery.append("'" + onePzNumber + "'");
            }
            query1.append((CharSequence)endedPzNumbersForQuery);
            query1.append(")");
            findEndedPz.debug((Object)("Zapytanie szukjace szczegolow Pz koncowego : " + query1.toString()));
            result1 = IntegrationAX.execute(axConnection, query1.toString());
            for (Map map : result1) {
                String trnbr = (String)map.get("xxtr_trnbr");
                indeciesNr.add(trnbr);
            }
            result2 = new ArrayList<Map<String, String>>();
            for (String string : indeciesNr) {
                StringBuilder query2 = new StringBuilder("SELECT PzSzcze.PackingSlipId as PZNUMBER, PzSzcze.Qty as tr_qty_loc, Price as tr_price, PzSzcze.DeliveryDate as tr_effdate, PzSzcze.InventLocationId as tr_site FROM WfwVendPackingSlipTransView_Bon as PzSzcze WHERE PzSzcze.PackingSlipId = ");
                query2 = query2.append("'");
                query2 = query2.append(string);
                query2 = query2.append("' AND PzSzcze.DeliveryDate > '");
                query2 = query2.append(P0023GetData.modyfiCurrentDate(PzManager.getNumberOfDaysBack()));
                query2 = query2.append("'");
                query2 = query2.append(" AND PzSzcze.VendAccount = '");
                query2 = query2.append(nrDostawcy);
                query2 = query2.append("'");
                findEndedPz.debug((Object)("Zapytanie szukjace szczegolow Pz koncowego :" + query2.toString()));
                List<Map<String, String>> tempResult2 = IntegrationAX.execute(axConnection, query2.toString());
                result2.addAll(tempResult2);
            }
            for (Map map : result2) {
                HashMap<String, String> endedPzDetails = new HashMap<String, String>();
                String pzNumber = (String)map.get("PZNUMBER");
                String tr_qty_loc = (String)map.get("tr_qty_loc");
                String tr_price = (String)map.get("tr_price");
                String tr_effdate = (String)map.get("tr_effdate");
                String reception = (String)map.get("tr_site");
                if (StringUtils.isBlank((CharSequence)((CharSequence)endedPzDetails.get("RECEPTION")))) {
                    endedPzDetails.put("RECEPTION", reception);
                }
                value = Double.valueOf(tr_price) * Double.valueOf(tr_qty_loc) + value;
                endedPzDetails.put("VALUE", String.valueOf(P0023GetData.round(value, 2)));
                endedPzDetails.put("DATE", tr_effdate);
                results.put(pzNumber, endedPzDetails);
            }
            return results;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Map<String, Map<String, String>> getEndedPzData(Connection axConnection, String[] endedPzNumbersTab, String nrDostawcy, String spolka) throws SQLException {
        findEndedPz.trace((Object)"***************GetEndedPzData***********");
        Double value = 0.0;
        List<Map<String, String>> result1 = null;
        HashSet<String> indeciesNr = null;
        ArrayList<Map<String, String>> result2 = null;
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>();
        StringBuilder endedPzNumbersForQuery = null;
        try {
            endedPzNumbersForQuery = new StringBuilder();
            indeciesNr = new HashSet<String>();
            StringBuilder query1 = new StringBuilder("SELECT PackingSlipId as xxtr_trnbr FROM WfwVendPackingSlipByAwizoView_Bon as main WHERE main.PackingSlipId IN(");
            for (String onePzNumber : endedPzNumbersTab) {
                if (StringUtils.isBlank((CharSequence)onePzNumber)) continue;
                if (!StringUtils.isBlank((CharSequence)endedPzNumbersForQuery.toString())) {
                    endedPzNumbersForQuery.append(",");
                }
                endedPzNumbersForQuery.append("'" + onePzNumber + "'");
            }
            query1.append((CharSequence)endedPzNumbersForQuery);
            query1.append(")");
            query1.append(" AND main.COMPANY = '");
            query1.append(spolka);
            query1.append("'");
            findEndedPz.debug((Object)("Zapytanie szukjace szczegolow Pz koncowego : " + query1.toString()));
            result1 = IntegrationAX.execute(axConnection, query1.toString());
            for (Map map : result1) {
                String trnbr = (String)map.get("xxtr_trnbr");
                indeciesNr.add(trnbr);
            }
            result2 = new ArrayList<Map<String, String>>();
            for (String string : indeciesNr) {
                StringBuilder query2 = new StringBuilder("SELECT PzSzcze.PackingSlipId as PZNUMBER, PzSzcze.Qty as tr_qty_loc, Price as tr_price, PzSzcze.DeliveryDate as tr_effdate, PzSzcze.InventLocationId as tr_site FROM WfwVendPackingSlipTransView_Bon as PzSzcze WHERE PzSzcze.PackingSlipId = ");
                query2 = query2.append("'");
                query2 = query2.append(string);
                query2 = query2.append("' AND PzSzcze.DeliveryDate > '");
                query2 = query2.append(P0023GetData.modyfiCurrentDate(PzManager.getNumberOfDaysBack()));
                query2 = query2.append("'");
                query2 = query2.append(" AND PzSzcze.VendAccount = '");
                query2 = query2.append(nrDostawcy);
                query2 = query2.append("'");
                query2 = query2.append(" AND PzSzcze.COMPANY = '");
                query2 = query2.append(spolka);
                query2 = query2.append("'");
                findEndedPz.debug((Object)("Zapytanie szukjace szczegolow Pz koncowego :" + query2.toString()));
                List<Map<String, String>> tempResult2 = IntegrationAX.execute(axConnection, query2.toString());
                result2.addAll(tempResult2);
            }
            for (Map map : result2) {
                HashMap<String, String> endedPzDetails = new HashMap<String, String>();
                String pzNumber = (String)map.get("PZNUMBER");
                String tr_qty_loc = (String)map.get("tr_qty_loc");
                String tr_price = (String)map.get("tr_price");
                String tr_effdate = (String)map.get("tr_effdate");
                String reception = (String)map.get("tr_site");
                if (StringUtils.isBlank((CharSequence)((CharSequence)endedPzDetails.get("RECEPTION")))) {
                    endedPzDetails.put("RECEPTION", reception);
                }
                value = Double.valueOf(tr_price) * Double.valueOf(tr_qty_loc) + value;
                endedPzDetails.put("VALUE", String.valueOf(P0023GetData.round(value, 2)));
                endedPzDetails.put("DATE", tr_effdate);
                results.put(pzNumber, endedPzDetails);
            }
            return results;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Map<String, Map<String, String>> getEndedPzData(Connection axConnection, String endedPzNumber, String nrDostawcy) throws SQLException {
        findEndedPz.trace((Object)"***************GetEndedPzData***********");
        Double value = 0.0;
        List<Map<String, String>> result1 = null;
        HashSet<String> indeciesNr = null;
        ArrayList<Map<String, String>> result2 = null;
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>();
        StringBuilder endedPzNumbersForQuery = null;
        try {
            endedPzNumbersForQuery = new StringBuilder();
            indeciesNr = new HashSet<String>();
            StringBuilder query1 = new StringBuilder("SELECT PackingSlipId as xxtr_trnbr FROM WfwVendPackingSlipTransView_Bon WHERE PackingSlipId IN (");
            endedPzNumbersForQuery.append("'" + endedPzNumber + "'");
            query1.append((CharSequence)endedPzNumbersForQuery);
            query1.append(")");
            findEndedPz.debug((Object)("Zapytanie szukjace szczegolow Pz koncowego : " + query1.toString()));
            result1 = IntegrationAX.execute(axConnection, query1.toString());
            for (Map<String, String> row : result1) {
                String trnbr = row.get("xxtr_trnbr");
                indeciesNr.add(trnbr);
            }
            result2 = new ArrayList<Map<String, String>>();
            for (String indexNumber : indeciesNr) {
                StringBuilder query2 = new StringBuilder("SELECT PzSzcze.PackingSlipId as PZNUMBER, PzSzcze.Qty as tr_qty_loc, Price as tr_price, PzSzcze.DeliveryDate as tr_effdate, PzSzcze.InventLocationId as tr_site FROM WfwVendPackingSlipTransView_Bon as PzSzcze WHERE PzSzcze.PackingSlipId = ");
                query2 = query2.append("'");
                query2 = query2.append(indexNumber);
                query2 = query2.append("' AND PzSzcze.DeliveryDate > '");
                query2 = query2.append(P0023GetData.modyfiCurrentDate(PzManager.getNumberOfDaysBack()));
                query2 = query2.append("'");
                query2 = query2.append(" AND PzSzcze.VendAccount = '");
                query2 = query2.append(nrDostawcy);
                query2 = query2.append("'");
                findEndedPz.debug((Object)("Zapytanie szukjace szczegolow Pz koncowego :" + query2.toString()));
                List<Map<String, String>> tempResult2 = IntegrationAX.execute(axConnection, query2.toString());
                result2.addAll(tempResult2);
            }
            for (Map<String, String> row : result2) {
                HashMap<String, String> endedPzDetails = new HashMap<String, String>();
                String pzNumber = row.get("PZNUMBER");
                String tr_qty_loc = row.get("tr_qty_loc");
                String tr_price = row.get("tr_price");
                String tr_effdate = row.get("tr_effdate");
                String reception = row.get("tr_site");
                if (StringUtils.isBlank((CharSequence)((CharSequence)endedPzDetails.get("RECEPTION")))) {
                    endedPzDetails.put("RECEPTION", reception);
                }
                value = Double.valueOf(tr_price) * Double.valueOf(tr_qty_loc) + value;
                endedPzDetails.put("VALUE", String.valueOf(P0023GetData.round(value, 2)));
                endedPzDetails.put("DATE", tr_effdate);
                results.put(pzNumber, endedPzDetails);
            }
            return results;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Map<String, Map<String, String>> getEndedPzData(Connection axConnection, String endedPzNumber, String nrDostawcy, String spolka) throws SQLException {
        findEndedPz.trace((Object)"***************GetEndedPzData***********");
        Double value = 0.0;
        List<Map<String, String>> result1 = null;
        HashSet<String> indeciesNr = null;
        ArrayList<Map<String, String>> result2 = null;
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>();
        StringBuilder endedPzNumbersForQuery = null;
        try {
            endedPzNumbersForQuery = new StringBuilder();
            indeciesNr = new HashSet<String>();
            StringBuilder query1 = new StringBuilder("SELECT PackingSlipId as xxtr_trnbr FROM WfwVendPackingSlipTransView_Bon WHERE PackingSlipId IN (");
            endedPzNumbersForQuery.append("'" + endedPzNumber + "'");
            query1.append((CharSequence)endedPzNumbersForQuery);
            query1.append(")");
            query1.append(" AND COMPANY = '");
            query1.append(spolka);
            query1.append("'");
            findEndedPz.debug((Object)("Zapytanie szukjace szczegolow Pz koncowego : " + query1.toString()));
            result1 = IntegrationAX.execute(axConnection, query1.toString());
            for (Map<String, String> row : result1) {
                String trnbr = row.get("xxtr_trnbr");
                indeciesNr.add(trnbr);
            }
            result2 = new ArrayList<Map<String, String>>();
            for (String indexNumber : indeciesNr) {
                StringBuilder query2 = new StringBuilder("SELECT PzSzcze.PackingSlipId as PZNUMBER, PzSzcze.Qty as tr_qty_loc, Price as tr_price, PzSzcze.DeliveryDate as tr_effdate, PzSzcze.InventLocationId as tr_site FROM WfwVendPackingSlipTransView_Bon as PzSzcze WHERE PzSzcze.PackingSlipId = ");
                query2 = query2.append("'");
                query2 = query2.append(indexNumber);
                query2 = query2.append("' AND PzSzcze.DeliveryDate > '");
                query2 = query2.append(P0023GetData.modyfiCurrentDate(PzManager.getNumberOfDaysBack()));
                query2 = query2.append("'");
                query2 = query2.append(" AND PzSzcze.VendAccount = '");
                query2 = query2.append(nrDostawcy);
                query2 = query2.append("'");
                query2 = query2.append(" AND PzSzcze.COMPANY = '");
                query2 = query2.append(spolka);
                query2 = query2.append("'");
                findEndedPz.debug((Object)("Zapytanie szukjace szczegolow Pz koncowego :" + query2.toString()));
                List<Map<String, String>> tempResult2 = IntegrationAX.execute(axConnection, query2.toString());
                result2.addAll(tempResult2);
            }
            for (Map<String, String> row : result2) {
                HashMap<String, String> endedPzDetails = new HashMap<String, String>();
                String pzNumber = row.get("PZNUMBER");
                String tr_qty_loc = row.get("tr_qty_loc");
                String tr_price = row.get("tr_price");
                String tr_effdate = row.get("tr_effdate");
                String reception = row.get("tr_site");
                if (StringUtils.isBlank((CharSequence)((CharSequence)endedPzDetails.get("RECEPTION")))) {
                    endedPzDetails.put("RECEPTION", reception);
                }
                value = Double.valueOf(tr_price) * Double.valueOf(tr_qty_loc) + value;
                endedPzDetails.put("VALUE", String.valueOf(P0023GetData.round(value, 2)));
                endedPzDetails.put("DATE", tr_effdate);
                results.put(pzNumber, endedPzDetails);
            }
            return results;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Pz getPzById(Long pzId) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = HibernateUtil.getSession();
            if (session == null || !session.isOpen()) {
                throw new HibernateException("Sesja jest null lub zamknieta!");
            }
            transaction = session.beginTransaction();
            Pz pz = (Pz)session.load(Pz.class, (Serializable)pzId);
            transaction.commit();
            Pz pz2 = pz;
            return pz2;
        }
        catch (HibernateException he) {
            throw he;
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    public static int getNumberOfDaysBack() {
        int number = 0;
        SQLFinder finder = FinderFactory.getSQLFinder();
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("select * from pm_cust_tabela_konfiguracyjna where klucz=:textcol");
        builder.addScalar("klucz", (Type)StandardBasicTypes.STRING);
        builder.addScalar("wartosc", (Type)StandardBasicTypes.STRING);
        builder.setParameter("textcol", (Object)"liczba_dni_wstecz");
        List data = finder.find(builder);
        for (int i = 0; i < data.size(); ++i) {
            String nazwaKonfiguracji = ((Map)data.get(i)).get("klucz").toString();
            if (nazwaKonfiguracji.compareTo("liczba_dni_wstecz") != 0) continue;
            String wartoscString = ((Map)data.get(i)).get("wartosc").toString();
            int wartoscInt = Integer.valueOf(wartoscString);
            if (wartoscInt > 0) {
                wartoscInt *= -1;
            }
            number = wartoscInt;
            break;
        }
        return number;
    }
}

