/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.library.tim.integrations;

import com.ddtek.jdbc.openedge.OpenEdgeDriver;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class IntegrationAX {
    public static Logger log = Logger.getLogger(IntegrationAX.class);
    private static String dataBaseUrl;
    private static String msSqlDataBaseUrl;
    private static String msSqlDataBaseName;
    private static String msSqlDataBasePort;
    private static String msSqlSendStringAsUnicode;
    private static String msSqlEncrypt;
    private static String msSqlTrustServerCertificate;
    private static String mfgDataBaseName;
    private static String mfgDataBasePort;
    private static String mfgxDataBaseName;
    private static String mfgxDataBasePort;
    private static String timDatabaseName;
    private static String timDataBasePort;
    private static String wmsDataBaseName;
    private static String wmsDataBasePort;

    public static Connection getODBCConnectionWithMFG(String clientNumber) throws ClassNotFoundException, SQLException {
        Connection conn = null;
        String DRIVER_NAME = "sun.jdbc.odbc.JdbcOdbcDriver";
        try {
            Class.forName(DRIVER_NAME);
            String dnsName = SystemProperties.getString((String)(clientNumber + ".DNSName"));
            String dbUserName = SystemProperties.getString((String)(clientNumber + ".DBUserName"));
            String dbPassword = SystemProperties.getString((String)(clientNumber + ".DBPassword"));
            String DATABASE_URL = "jdbc:odbc:" + dnsName;
            if (!(StringUtils.isBlank((CharSequence)dnsName) || StringUtils.isBlank((CharSequence)dbUserName) || StringUtils.isBlank((CharSequence)dbPassword))) {
                conn = DriverManager.getConnection(DATABASE_URL, dbUserName, dbPassword);
            }
            return conn;
        }
        catch (ClassNotFoundException classEx) {
            throw classEx;
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
    }

    public static Connection getJDBCConnectionWithMFG(String userID, String password, String port, String dataBaseName) {
        try {
            OpenEdgeDriver driver = new OpenEdgeDriver();
            DriverManager.registerDriver((Driver)driver);
            if (DriverManager.getLoginTimeout() == 0) {
                DriverManager.setLoginTimeout(30);
            }
            log.debug((Object)String.format("Establishing connection (login timeout: %d)...", DriverManager.getLoginTimeout()));
            Object connectionString = "jdbc:datadirect:openedge://" + dataBaseUrl + ":";
            connectionString = ((String)connectionString).concat(port);
            connectionString = ((String)connectionString).concat(";databaseName=");
            connectionString = ((String)connectionString).concat(dataBaseName);
            Connection conn = DriverManager.getConnection((String)connectionString, userID, password);
            log.debug((Object)"Connected with MFG!!!!!!!");
            return conn;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Connection getJDBCConnectionWithAX(String userID, String password, String port, String dataBaseName) {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            if (DriverManager.getLoginTimeout() == 0) {
                DriverManager.setLoginTimeout(30);
            }
            log.debug((Object)String.format("Establishing connection (login timeout: %d)...", DriverManager.getLoginTimeout()));
            log.debug((Object)("URL: " + msSqlDataBaseUrl + " port: " + port));
            String connectionString = "jdbc:sqlserver://" + msSqlDataBaseUrl + ":" + port + ";database=" + dataBaseName + ";user=" + userID + ";password=" + password;
            if (!StringUtils.isBlank((CharSequence)msSqlSendStringAsUnicode)) {
                connectionString = connectionString + ";sendStringParametersAsUnicode=" + msSqlSendStringAsUnicode;
            }
            if (!StringUtils.isBlank((CharSequence)msSqlEncrypt)) {
                connectionString = connectionString + ";encrypt=" + msSqlEncrypt;
            }
            if (!StringUtils.isBlank((CharSequence)msSqlTrustServerCertificate)) {
                connectionString = connectionString + ";trustServerCertificate=" + msSqlTrustServerCertificate;
            }
            Connection conn = DriverManager.getConnection(connectionString, userID, password);
            log.debug((Object)"Connected with AX!!!!!!!");
            return conn;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Map<String, String>> execute(Connection con, String query) throws SQLException {
        Statement stmt = null;
        ResultSet rset = null;
        try {
            Date dtStart = new Date();
            log.debug((Object)("Wykonanie zapytania do MFG  :" + query));
            ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
            if (query.contains("INSERT") || query.contains("UPDATE")) {
                if (!con.isClosed()) {
                    stmt = con.createStatement();
                    stmt.executeUpdate(query);
                }
            } else {
                DatabaseMetaData metaData = con.getMetaData();
                if (metaData.supportsTransactionIsolationLevel(1)) {
                    con.setTransactionIsolation(1);
                }
                stmt = con.createStatement();
                rset = stmt.executeQuery(query);
                ResultSetMetaData rsmd = rset.getMetaData();
                int numColumns = rsmd.getColumnCount();
                while (rset.next()) {
                    HashMap<String, String> oneRow = new HashMap<String, String>();
                    for (int i = 1; i < numColumns + 1; ++i) {
                        String columnName = rsmd.getColumnName(i);
                        String value = rset.getString(columnName);
                        if (value == null) {
                            value = "";
                        }
                        oneRow.put(columnName, value);
                    }
                    results.add(oneRow);
                }
                log.debug((Object)("Ilosc zwroconych wynikow : " + results.size()));
            }
            Date dtEnd = new Date();
            log.debug((Object)("Przyblizony czas wykonania zapytania : " + (dtEnd.getTime() - dtStart.getTime())));
            ArrayList<Map<String, String>> arrayList = results;
            return arrayList;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    public static Connection getConnectionWithAX() {
        return IntegrationAX.getJDBCConnectionWithAX("suncode_read", "suncode_read", msSqlDataBasePort, msSqlDataBaseName);
    }

    public static Connection getConnectionWithMFGDataBase() {
        return IntegrationAX.getJDBCConnectionWithMFG("mfg", "mfg90", mfgDataBasePort, mfgDataBaseName);
    }

    public static Connection getConnectionWithMFGXDataBase() {
        return IntegrationAX.getJDBCConnectionWithMFG("mfg", "mfg90", mfgxDataBasePort, mfgxDataBaseName);
    }

    public static Connection getConnectionWithTIMDataBase() {
        return IntegrationAX.getJDBCConnectionWithMFG("mfg", "mfg90", timDataBasePort, timDatabaseName);
    }

    public static Connection getConnectionWithWMSDataBase() {
        return IntegrationAX.getJDBCConnectionWithMFG("mfg", "mfg90", wmsDataBasePort, wmsDataBaseName);
    }

    public static void execute(String query) throws SQLException {
        Statement stmt = null;
        ResultSet rset = null;
        try {
            Connection con = IntegrationAX.getConnectionWithAX();
            ArrayList results = new ArrayList();
            if (query.contains("INSERT") || query.contains("UPDATE")) {
                if (!con.isClosed()) {
                    stmt = con.createStatement();
                    log.debug((Object)("Insert or Update Query :" + query));
                    stmt.executeUpdate(query);
                }
            } else {
                DatabaseMetaData metaData = con.getMetaData();
                if (metaData.supportsTransactionIsolationLevel(1)) {
                    con.setTransactionIsolation(1);
                }
                stmt = con.createStatement();
                rset = stmt.executeQuery(query);
                ResultSetMetaData rsmd = rset.getMetaData();
                int numColumns = rsmd.getColumnCount();
                while (rset.next()) {
                    for (int i = 1; i < numColumns + 1; ++i) {
                        HashMap<String, String> oneRow = new HashMap<String, String>();
                        String columnName = rsmd.getColumnName(i);
                        String value = rset.getString(columnName);
                        if (value == null) {
                            value = "";
                        }
                        log.debug((Object)("Column: " + columnName + "Value :" + String.valueOf(rset.getObject(i))));
                        oneRow.put(columnName, value);
                        results.add(oneRow);
                    }
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    static {
        try {
            msSqlDataBaseUrl = SystemProperties.getString((String)"MSSQLDATABASEURL");
            msSqlDataBaseName = SystemProperties.getString((String)"MSSQLDATABASE");
            msSqlDataBasePort = SystemProperties.getString((String)"MSSQLPORT");
            msSqlSendStringAsUnicode = SystemProperties.getString((String)"MSSQLSENDSTRINGASUNICODE");
            msSqlEncrypt = SystemProperties.getString((String)"MSSQLENCRYPT");
            msSqlTrustServerCertificate = SystemProperties.getString((String)"MSSQLTRUSTSERVERCERTIFICATE");
            dataBaseUrl = SystemProperties.getString((String)"MFGDATABASEURL");
            mfgDataBaseName = SystemProperties.getString((String)"MFGDATABASE");
            mfgDataBasePort = SystemProperties.getString((String)"MFGPORT");
            mfgxDataBaseName = SystemProperties.getString((String)"MFGXDATABASE");
            mfgxDataBasePort = SystemProperties.getString((String)"MFGXPORT");
            timDatabaseName = SystemProperties.getString((String)"TIMDATABASE");
            timDataBasePort = SystemProperties.getString((String)"TIMPORT");
            wmsDataBaseName = SystemProperties.getString((String)"WMSDATABASE");
            wmsDataBasePort = SystemProperties.getString((String)"WMSPORT");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

