/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.library.tim.P0023;

import com.plusmpm.CUF.util.extension.InternalDataBase;
import com.suncode.client.library.tim.integrations.IntegrationAX;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleFinder;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.database.sequence.SequenceService;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import com.suncode.pwfl.workflow.process.ProcessState;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.api.client.wfbase.BaseException;

public class P0023GetData {
    public static Logger log = Logger.getLogger(P0023GetData.class);

    public static Map<String, Map<String, String>> getSupplierDetails(Connection con, List<Map<String, String>> supplierData) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> queryResult = null;
        HashMap<String, Map<String, String>> result = null;
        try {
            log.debug((Object)"=== Pobieranie danych dostawcy ===");
            result = new HashMap<String, Map<String, String>>();
            StringBuilder query = new StringBuilder("SELECT AccountNum as KOD_DOSTAWCY, 'TIMSA/'+ UserLogin as BRANZYSTA, Name As NAZWA_DOSTAWCY, PaymTermId as WARUNKI_PLATNOSCI, PaymModeId as FORMA_CZEKU, Currency as WALUTA FROM dbo.WfwVendTableView_Bon WHERE AccountNum IN (");
            String codes = "";
            for (Map<String, String> data : supplierData) {
                String code = data.get("KOD_DOSTAWCY");
                if (code == null || code.isEmpty()) continue;
                if (codes.compareTo("") != 0) {
                    codes = codes.concat(",");
                }
                codes = codes.concat("'");
                codes = codes.concat(code);
                codes = codes.concat("'");
            }
            query = query.append(codes);
            query = query.append(")");
            queryResult = IntegrationAX.execute(con, query.toString());
            log.debug((Object)("Dane z AX: " + queryResult.toString()));
            UserService userService = ServiceFactory.getUserService();
            for (Map<String, String> map : queryResult) {
                if (map.get("BRANZYSTA") != null && !map.get("BRANZYSTA").isEmpty()) {
                    log.debug((Object)("BRANZYSTA: " + map.get("BRANZYSTA").toString()));
                    try {
                        User user = userService.getUser(map.get("BRANZYSTA"), new String[0]);
                        if (user == null || user.getFullName().compareToIgnoreCase(map.get("BRANZYSTA")) == 0) {
                            user = userService.getUser(map.get("BRANZYSTA").toLowerCase().replaceAll("timsa/", "TIMSA/"), new String[0]);
                            if (user == null || user.getFullName().compareToIgnoreCase(map.get("BRANZYSTA")) == 0) {
                                log.debug((Object)"Nie ma takiego u\u017cytkownika. Pusty bran\u017cysta.");
                                map.put("BRANZYSTA", "");
                            } else {
                                log.debug((Object)("BRANZYSTA znajduje sie w systemie: " + map.get("BRANZYSTA").toLowerCase().replaceAll("timsa/", "TIMSA/").toString()));
                                map.put("BRANZYSTA", map.get("BRANZYSTA").toLowerCase().replaceAll("timsa/", "TIMSA/"));
                            }
                        }
                    }
                    catch (Exception e) {
                        map.put("BRANZYSTA", "");
                    }
                }
                result.put(map.get("KOD_DOSTAWCY"), map);
            }
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Map<String, Map<String, String>> getSupplierDetails(Connection con, List<Map<String, String>> supplierData, String spolka) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> queryResult = null;
        HashMap<String, Map<String, String>> result = null;
        try {
            log.debug((Object)"=== Pobieranie danych dostawcy ===");
            result = new HashMap<String, Map<String, String>>();
            StringBuilder query = new StringBuilder("SELECT AccountNum as KOD_DOSTAWCY, 'TIMSA/'+ UserLogin as BRANZYSTA, Name As NAZWA_DOSTAWCY, PaymTermId as WARUNKI_PLATNOSCI, PaymModeId as FORMA_CZEKU, Currency as WALUTA FROM dbo.WfwVendTableView_Bon WHERE AccountNum IN (");
            String codes = "";
            for (Map<String, String> data : supplierData) {
                String code = data.get("KOD_DOSTAWCY");
                if (code == null || code.isEmpty()) continue;
                if (codes.compareTo("") != 0) {
                    codes = codes.concat(",");
                }
                codes = codes.concat("'");
                codes = codes.concat(code);
                codes = codes.concat("'");
            }
            query = query.append(codes);
            query = query.append(")");
            query = query.append(" AND COMPANY = '");
            query = query.append(spolka);
            query = query.append("'");
            queryResult = IntegrationAX.execute(con, query.toString());
            log.debug((Object)("Dane z AX: " + queryResult.toString()));
            UserService userService = ServiceFactory.getUserService();
            for (Map<String, String> map : queryResult) {
                if (map.get("BRANZYSTA") != null && !map.get("BRANZYSTA").isEmpty()) {
                    log.debug((Object)("BRANZYSTA: " + map.get("BRANZYSTA").toString()));
                    try {
                        User user = userService.getUser(map.get("BRANZYSTA"), new String[0]);
                        if (user == null || user.getFullName().compareToIgnoreCase(map.get("BRANZYSTA")) == 0) {
                            user = userService.getUser(map.get("BRANZYSTA").toLowerCase().replaceAll("timsa/", "TIMSA/"), new String[0]);
                            if (user == null || user.getFullName().compareToIgnoreCase(map.get("BRANZYSTA")) == 0) {
                                log.debug((Object)"Nie ma takiego u\u017cytkownika. Pusty bran\u017cysta.");
                                map.put("BRANZYSTA", "");
                            } else {
                                log.debug((Object)("BRANZYSTA znajduje sie w systemie: " + map.get("BRANZYSTA").toLowerCase().replaceAll("timsa/", "TIMSA/").toString()));
                                map.put("BRANZYSTA", map.get("BRANZYSTA").toLowerCase().replaceAll("timsa/", "TIMSA/"));
                            }
                        }
                    }
                    catch (Exception e) {
                        map.put("BRANZYSTA", "");
                    }
                }
                result.put(map.get("KOD_DOSTAWCY"), map);
            }
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Map<String, Map<String, String>> getSupplierAdress(Connection con, List<Map<String, String>> supplierData) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> queryResult = null;
        HashMap<String, Map<String, String>> result = null;
        try {
            result = new HashMap<String, Map<String, String>>();
            StringBuilder query = new StringBuilder("SELECT AccountNum as KOD_DOSTAWCY, City as MIASTO, ZipCode as KOD FROM dbo.WfwVendTableView_Bon WHERE AccountNum IN(");
            String codes = "";
            for (Map<String, String> data : supplierData) {
                String code = data.get("KOD_DOSTAWCY");
                if (code == null || code.isEmpty()) continue;
                if (codes.compareTo("") != 0) {
                    codes = codes.concat(",");
                }
                codes = codes.concat("'");
                codes = codes.concat(code);
                codes = codes.concat("'");
            }
            query = query.append(codes);
            query = query.append(")");
            queryResult = IntegrationAX.execute(con, query.toString());
            for (Map<String, String> map : queryResult) {
                result.put(map.get("KOD_DOSTAWCY"), map);
            }
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Map<String, Map<String, String>> getSupplierAdress(Connection con, List<Map<String, String>> supplierData, String spolka) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> queryResult = null;
        HashMap<String, Map<String, String>> result = null;
        try {
            result = new HashMap<String, Map<String, String>>();
            StringBuilder query = new StringBuilder("SELECT AccountNum as KOD_DOSTAWCY, City as MIASTO, ZipCode as KOD FROM dbo.WfwVendTableView_Bon WHERE AccountNum IN(");
            String codes = "";
            for (Map<String, String> data : supplierData) {
                String code = data.get("KOD_DOSTAWCY");
                if (code == null || code.isEmpty()) continue;
                if (codes.compareTo("") != 0) {
                    codes = codes.concat(",");
                }
                codes = codes.concat("'");
                codes = codes.concat(code);
                codes = codes.concat("'");
            }
            query = query.append(codes);
            query = query.append(")");
            query = query.append(" AND COMPANY = '");
            query = query.append(spolka);
            query = query.append("'");
            queryResult = IntegrationAX.execute(con, query.toString());
            for (Map<String, String> map : queryResult) {
                result.put(map.get("KOD_DOSTAWCY"), map);
            }
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Map<String, Map<String, String>> getSupplierNipByCode(Connection mfgxDataBase, List<Map<String, String>> supplierData) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> queryResult = null;
        HashMap<String, Map<String, String>> result = null;
        try {
            result = new HashMap<String, Map<String, String>>();
            StringBuilder query = new StringBuilder("SELECT VATNum as NIP, AccountNum as KOD_DOSTAWCY FROM dbo.WfwVendTableView_Bon WHERE AccountNum IN(");
            String codes = "";
            for (Map<String, String> data : supplierData) {
                String code = data.get("KOD_DOSTAWCY");
                if (code == null || code.isEmpty()) continue;
                if (codes.compareTo("") != 0) {
                    codes = codes.concat(",");
                }
                codes = codes.concat(code);
            }
            query = query.append(codes);
            query = query.append(")");
            queryResult = IntegrationAX.execute(mfgxDataBase, query.toString());
            for (Map<String, String> map : queryResult) {
                result.put(map.get("KOD_DOSTAWCY"), map);
            }
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Map<String, Map<String, String>> getSupplierNipByCode(Connection mfgxDataBase, List<Map<String, String>> supplierData, String spolka) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> queryResult = null;
        HashMap<String, Map<String, String>> result = null;
        try {
            result = new HashMap<String, Map<String, String>>();
            StringBuilder query = new StringBuilder("SELECT VATNum as NIP, AccountNum as KOD_DOSTAWCY FROM dbo.WfwVendTableView_Bon WHERE AccountNum IN(");
            String codes = "";
            for (Map<String, String> data : supplierData) {
                String code = data.get("KOD_DOSTAWCY");
                if (code == null || code.isEmpty()) continue;
                if (codes.compareTo("") != 0) {
                    codes = codes.concat(",");
                }
                codes = codes.concat(code);
            }
            query = query.append(codes);
            query = query.append(")");
            query = query.append(" AND COMPANY = '");
            query = query.append(spolka);
            query = query.append("'");
            queryResult = IntegrationAX.execute(mfgxDataBase, query.toString());
            for (Map<String, String> map : queryResult) {
                result.put(map.get("KOD_DOSTAWCY"), map);
            }
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static List<Map<String, String>> getSupplierDataByCode(Connection mfgxDataBase, String code) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> result = null;
        try {
            String query = "SELECT AccountNum as KOD_DOSTAWCY, VATNum as NIP, Street as ULICA1, Street as ULICA2 FROM dbo.WfwVendTableView_Bon WHERE AccountNum = '";
            query = query.concat(code);
            query = query.concat("'");
            result = IntegrationAX.execute(mfgxDataBase, query);
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static List<Map<String, String>> getSupplierDataByCode(Connection mfgxDataBase, String code, String spolka) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> result = null;
        try {
            String query = "SELECT AccountNum as KOD_DOSTAWCY, VATNum as NIP, Street as ULICA1, Street as ULICA2 FROM dbo.WfwVendTableView_Bon WHERE AccountNum = '";
            query = query.concat(code);
            query = query.concat("'");
            query = query.concat(" AND COMPANY = '");
            query = query.concat(spolka);
            query = query.concat("'");
            result = IntegrationAX.execute(mfgxDataBase, query);
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static List<Map<String, String>> getSupplierDataByNip(Connection con, String nip) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> result = null;
        try {
            String query = "SELECT AccountNum as KOD_DOSTAWCY, Street as ULICA1, Street as ULICA2 FROM dbo.WfwVendTableView_Bon WHERE LTRIM(RTRIM(REPLACE(VATNum, '-', ''))) = '";
            query = query.concat(nip);
            query = query.concat("'");
            List<Map<String, String>> list = result = IntegrationAX.execute(con, query);
            return list;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (con == null) {
                    throw new NullPointerException("Connection is null");
                }
                if (!con.isClosed()) {
                    con.close();
                }
            }
            catch (NullPointerException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    public static List<Map<String, String>> getSupplierDataByNip(Connection con, String nip, String spolka) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> result = null;
        try {
            String query = "SELECT AccountNum as KOD_DOSTAWCY, Street as ULICA1, Street as ULICA2 FROM dbo.WfwVendTableView_Bon WHERE LTRIM(RTRIM(REPLACE(VATNum, '-', ''))) = '";
            query = query.concat(nip);
            query = query.concat("'");
            query = query.concat(" AND COMPANY = '");
            query = query.concat(spolka);
            query = query.concat("'");
            List<Map<String, String>> list = result = IntegrationAX.execute(con, query);
            return list;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (con == null) {
                    throw new NullPointerException("Connection is null");
                }
                if (!con.isClosed()) {
                    con.close();
                }
            }
            catch (NullPointerException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    public static List<String> getUserInOUByRole(String ou, String role) throws NullPointerException, BaseException {
        try {
            UserFinder userFinder = FinderFactory.getUserFinder();
            OrganizationalUnitFinder organizationalUnitFinder = FinderFactory.getOrganizationalUnitFinder();
            List organizationalUnits = organizationalUnitFinder.findByName(ou, new String[0]);
            ArrayList usersInOu = new ArrayList();
            for (OrganizationalUnit organizationalUnit : organizationalUnits) {
                List usersForOu = userFinder.findByOU(organizationalUnit.getSymbol());
                usersInOu.addAll(usersForOu);
            }
            RoleService roleService = ServiceFactory.getRoleService();
            Role foundRole = roleService.getRole("probdo", "probdo", role);
            List usersInRole = userFinder.findByRoleId(foundRole.getId());
            usersInRole.retainAll(usersInOu);
            ArrayList<String> resultUsers = new ArrayList<String>();
            for (int i = 0; i < usersInRole.size(); ++i) {
                resultUsers.add(((User)usersInRole.get(i)).getUserName());
            }
            return resultUsers;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Set<String> getStorekeeperBySupplierCode(String supplierCode) throws SQLException, ClassNotFoundException {
        Connection con = null;
        HashSet<String> results = new HashSet<String>();
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT UserLogin AS KUPUJACY FROM dbo.WfwVendTableView_Bon WHERE AccountNum='");
            query = query.append(supplierCode);
            query = query.append("'");
            con = IntegrationAX.getConnectionWithAX();
            result = IntegrationAX.execute(con, query.toString());
            for (Map<String, String> row : result) {
                String supplierName = row.get("KUPUJACY");
                if (StringUtils.isBlank((CharSequence)supplierName)) continue;
                results.add(supplierName);
            }
            HashSet<String> hashSet = results;
            return hashSet;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (con == null) {
                    throw new NullPointerException("Connection is null");
                }
                if (!con.isClosed()) {
                    con.close();
                }
            }
            catch (NullPointerException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    public static String GenerateNextNr() {
        try {
            SequenceService sequenceService = ServiceFactory.getSequenceService();
            String sequenceName = "nrTransakcji";
            if (!sequenceService.sequenceExist(sequenceName)) {
                sequenceService.createSequence(sequenceName, 1, 1);
            }
            long number = sequenceService.getNextSequenceValue(sequenceName);
            int numberLength = String.valueOf(number).length();
            int stringLength = 14 - numberLength;
            StringBuilder nr = new StringBuilder();
            nr.append("01");
            for (int i = 0; i < stringLength; ++i) {
                nr.append("0");
            }
            nr.append(String.valueOf(number));
            return nr.toString();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Map<String, String>> getAccountNumberBySupplierCode(String supplierCode) throws SQLException, ClassNotFoundException {
        Connection con = null;
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT BankAccountId as NAZWA_BANKU, BankAccountNumber as KONTO_BANKOWE FROM WfwVendBankAccountView_Bon WHERE VendAccount='");
            query = query.append(supplierCode);
            query = query.append("'");
            con = IntegrationAX.getConnectionWithAX();
            List<Map<String, String>> list = result = IntegrationAX.execute(con, query.toString());
            return list;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (con == null) {
                    throw new NullPointerException("Connection is null");
                }
                if (!con.isClosed()) {
                    con.close();
                }
            }
            catch (NullPointerException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    public static List<Map<String, String>> getAccountNumberBySupplierCode(String supplierCode, String spolka) throws SQLException, ClassNotFoundException {
        Connection con = null;
        List<Map<String, String>> result = null;
        try {
            StringBuilder query = new StringBuilder("SELECT BankAccountId as NAZWA_BANKU, BankAccountNumber as KONTO_BANKOWE FROM WfwVendBankAccountView_Bon WHERE VendAccount='");
            query = query.append(supplierCode);
            query = query.append("'");
            query = query.append(" AND COMPANY = '");
            query = query.append(spolka);
            query = query.append("'");
            con = IntegrationAX.getConnectionWithAX();
            List<Map<String, String>> list = result = IntegrationAX.execute(con, query.toString());
            return list;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (con == null) {
                    throw new NullPointerException("Connection is null");
                }
                if (!con.isClosed()) {
                    con.close();
                }
            }
            catch (NullPointerException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    public static Set<String> GetAllOUWithPosition(String searchPositionRoleName) {
        HashSet<String> searchOU = new HashSet<String>();
        RoleService roleService = ServiceFactory.getRoleService();
        Role foundRole = roleService.getRole("probdo", "probdo", searchPositionRoleName);
        PositionFinder positionFinder = FinderFactory.getPositionFinder();
        List positionsWithRole = positionFinder.findByRole(foundRole.getId(), new String[]{"organizationalUnit"});
        for (Position onePosition : positionsWithRole) {
            OrganizationalUnit oneOu = onePosition.getOrganizationalUnit();
            if (oneOu == null) continue;
            searchOU.add(oneOu.getName());
        }
        return searchOU;
    }

    public static Map<String, Map<String, String>> getFirstActiveAccountForSuppliers(Connection mfgDataBase, String documentData, List<Map<String, String>> supplierData) throws Exception {
        List<Map<String, String>> queryResult = null;
        HashMap<String, Map<String, String>> result = null;
        try {
            result = new HashMap<String, Map<String, String>>();
            StringBuilder query = new StringBuilder("SELECT BankAccountId as NAZWA_BANKU, BankAccountNumber as KONTO_BANKOWE, VendAccount as KOD_DOSTAWCY FROM WfwVendBankAccountView_Bon WHERE VendAccount IN (");
            String codes = "";
            for (Map<String, String> data : supplierData) {
                String code = data.get("KOD_DOSTAWCY");
                if (code == null || code.isEmpty()) continue;
                if (codes.compareTo("") != 0) {
                    codes = codes.concat(",");
                }
                codes = codes.concat("'");
                codes = codes.concat(code);
                codes = codes.concat("'");
            }
            query = query.append(codes);
            query = query.append(")");
            queryResult = IntegrationAX.execute(mfgDataBase, (query = query.append(" ORDER BY NAZWA_BANKU ")).toString());
            Iterator<Map<String, String>> iterator = queryResult.iterator();
            if (iterator.hasNext()) {
                Map<String, String> map = iterator.next();
                result.put(map.get("KOD_DOSTAWCY"), map);
                return result;
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Map<String, Map<String, String>> getFirstActiveAccountForSuppliers(Connection mfgDataBase, String documentData, List<Map<String, String>> supplierData, String spolka) throws Exception {
        List<Map<String, String>> queryResult = null;
        HashMap<String, Map<String, String>> result = null;
        try {
            result = new HashMap<String, Map<String, String>>();
            StringBuilder query = new StringBuilder("SELECT BankAccountId as NAZWA_BANKU, BankAccountNumber as KONTO_BANKOWE, VendAccount as KOD_DOSTAWCY FROM WfwVendBankAccountView_Bon WHERE VendAccount IN (");
            String codes = "";
            for (Map<String, String> data : supplierData) {
                String code = data.get("KOD_DOSTAWCY");
                if (code == null || code.isEmpty()) continue;
                if (codes.compareTo("") != 0) {
                    codes = codes.concat(",");
                }
                codes = codes.concat("'");
                codes = codes.concat(code);
                codes = codes.concat("'");
            }
            query = query.append(codes);
            query = query.append(")");
            query = query.append(" AND COMPANY = '");
            query = query.append(spolka);
            query = query.append("'");
            queryResult = IntegrationAX.execute(mfgDataBase, (query = query.append(" ORDER BY NAZWA_BANKU ")).toString());
            Iterator<Map<String, String>> iterator = queryResult.iterator();
            if (iterator.hasNext()) {
                Map<String, String> map = iterator.next();
                result.put(map.get("KOD_DOSTAWCY"), map);
                return result;
            }
            return result;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static ArrayList<String> GetUserInOUWithPosition(String OUName, String roleName, String packageId) {
        ArrayList<String> usersIds = new ArrayList<String>();
        try {
            OrganizationalUnitFinder organizationalUnitFinder = FinderFactory.getOrganizationalUnitFinder();
            List allOU = organizationalUnitFinder.findByName(OUName, new String[0]);
            if (allOU == null) {
                throw new NullPointerException();
            }
            UserFinder userFinder = FinderFactory.getUserFinder();
            RoleFinder roleFinder = FinderFactory.getRoleFinder();
            for (OrganizationalUnit organizationalUnit : allOU) {
                List alluserInOU = userFinder.findByOU(organizationalUnit.getSymbol());
                if (alluserInOU == null) {
                    throw new NullPointerException();
                }
                for (User user : alluserInOU) {
                    List roles = roleFinder.findByUserName(user.getUserName());
                    for (Role role : roles) {
                        if (role.getRoleId().compareTo(roleName) != 0 || role.getPackageId().compareTo(packageId) != 0) continue;
                        usersIds.add(user.getUserName());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return usersIds;
    }

    public static String modyfiCurrentDate(int days) throws NullPointerException {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, days);
            String date = simpleDateFormat.format(calendar.getTime());
            return date;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Double round(Double number, int rpl) {
        try {
            Double p = Math.pow(10.0, rpl);
            Double val = number * p;
            Long temp = Math.round(val);
            Double tempDouble = temp.doubleValue();
            return tempDouble / p;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return 0.0;
        }
    }

    public static List<Map<String, String>> getArchInvoiceData(Connection conAX, String date) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> result = null;
        try {
            Object query = "SELECT InvoiceId as 'Nr faktury', InvoiceDate as 'Data wystawienia', CustAccount as 'Kod klienta', SiteTIM as 'Oddzia\u0142 TIM', DueDate as 'Data p\u0142atno\u015bci', NetAmount as 'Kwota netto', GrossAmount as 'Kwota brutto' FROM WfwCustInvoiceJourView_Bon WHERE ";
            query = date != null ? (String)query + "InvoiceDate = '" + date + "'" : (String)query + "InvoiceDate = DATEADD(day, -1, CONVERT(DATETIME, CONVERT(varchar(10), GETDATE(), 101)))";
            result = IntegrationAX.execute(conAX, (String)query);
            int iloscDanych = result.size();
            String allKk = "";
            for (int i = 0; i < iloscDanych; ++i) {
                String nrKlienta = result.get(i).get("Kod klienta");
                if (!StringUtils.isBlank((CharSequence)allKk)) {
                    allKk = allKk.concat(",");
                }
                allKk = allKk.concat("'");
                allKk = allKk.concat(nrKlienta);
                allKk = allKk.concat("'");
            }
            List<Map<String, String>> nazwaKlienta_kodKlienta = null;
            query = "SELECT CustName as Kontrahent, CustAccountNum as 'Kod klienta' FROM tim.LM_CustVendTableView WHERE CustAccountNum ";
            nazwaKlienta_kodKlienta = P0023GetData.createAndExecuteQuery((String)query, conAX, allKk);
            P0023GetData.mergeList(result, nazwaKlienta_kodKlienta, "Kod klienta", "Kontrahent");
            List<Map<String, String>> nip_kodKlienta = null;
            query = "SELECT NIP as Nip, CustAccountNum as 'Kod klienta' FROM tim.LM_CustVendTableView WHERE CustAccountNum ";
            nip_kodKlienta = P0023GetData.createAndExecuteQuery((String)query, conAX, allKk);
            P0023GetData.mergeList(result, nip_kodKlienta, "Kod klienta", "Nip");
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static List<Map<String, String>> getArchWzData(Connection axConnection, String date) throws ClassNotFoundException, SQLException {
        int iloscElInWJednymZapytaniu = 1000;
        List<Map<String, String>> result = null;
        try {
            Object query = "SELECT DeliveryDate as 'Data wystawienia', CustAccount as 'Kod klienta', CreatedBy as 'Wystawiaj\u0105cy', InvoiceId as 'Numer faktury', InventLocationId as 'Oddzia\u0142 TIM', PackingSlipId as 'Numer WZ',  case when PackingSlipId like 'WZ/%' then InventLocationId when PackingSlipId like 'W%' then SUBSTRING(PackingSlipId, 3,2) when PackingSlipId like 'ZZ/WZ/%' then InventLocationId when PackingSlipId like 'ZZ/W%' then SUBSTRING(PackingSlipId, 6,2) else InventLocationId end as 'Nr OH sprzedazy' FROM WfwCustPackingSlipJourView_Bon WHERE ";
            query = date != null ? (String)query + "DeliveryDate = '" + date + "'" : (String)query + "DeliveryDate = DATEADD(day, -1, CONVERT(DATETIME, CONVERT(varchar(10), GETDATE(), 101)))";
            result = IntegrationAX.execute(axConnection, (String)query);
            int iloscDanych = result.size();
            String allKk = "";
            String allfaktura = "";
            for (int i = 0; i < iloscDanych; ++i) {
                String nrKlienta = result.get(i).get("Kod klienta");
                if (!StringUtils.isBlank((CharSequence)allKk)) {
                    allKk = allKk.concat(",");
                }
                allKk = allKk.concat("'");
                allKk = allKk.concat(nrKlienta);
                allKk = allKk.concat("'");
                String faktura = result.get(i).get("Numer faktury");
                if (!StringUtils.isBlank((CharSequence)allfaktura)) {
                    allfaktura = allfaktura.concat(",");
                }
                allfaktura = allfaktura.concat("'");
                allfaktura = allfaktura.concat(faktura);
                allfaktura = allfaktura.concat("'");
                if (i == 0 || i % iloscElInWJednymZapytaniu != 0 || i == iloscDanych - 1) continue;
                allKk = allKk.concat(";");
                allfaktura = allfaktura.concat(";");
            }
            List<Map<String, String>> kontrahent_kodKlienta = null;
            query = "SELECT CustName as Kontrahent, CustAccountNum as 'Kod klienta' FROM tim.LM_CustVendTableView WHERE CustAccountNum ";
            kontrahent_kodKlienta = P0023GetData.createAndExecuteQuery((String)query, axConnection, allKk);
            P0023GetData.mergeList(result, kontrahent_kodKlienta, "Kod klienta", "Kontrahent");
            List<Map<String, String>> nip_kodKlienta = null;
            query = "SELECT NIP as Nip, CustAccountNum as 'Kod klienta' FROM tim.LM_CustVendTableView WHERE CustAccountNum ";
            nip_kodKlienta = P0023GetData.createAndExecuteQuery((String)query, axConnection, allKk);
            P0023GetData.mergeList(result, nip_kodKlienta, "Kod klienta", "Nip");
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    static List<Map<String, String>> createAndExecuteQuery(String queryPart, Connection con, String inVariable) throws SQLException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        String query = "";
        if (inVariable != null && inVariable.compareTo("") != 0) {
            String[] tabVar = inVariable.split(";,");
            for (int i = 0; i < tabVar.length; ++i) {
                query = queryPart;
                List<Map<String, String>> reusltPart = null;
                if (tabVar[i].compareTo("") == 0) continue;
                query = query.concat(" in (");
                query = query.concat(tabVar[i]);
                query = query.concat(")");
                reusltPart = IntegrationAX.execute(con, query);
                result.addAll(reusltPart);
            }
        }
        return result;
    }

    static void mergeList(List<Map<String, String>> ListA, List<Map<String, String>> ListB, String idKey, String idVal) {
        for (int i = 0; i < ListA.size(); ++i) {
            boolean succes = false;
            String key1 = ListA.get(i).get(idKey);
            if (key1 != null) {
                for (int j = 0; j < ListB.size(); ++j) {
                    String key2 = ListB.get(j).get(idKey);
                    if (key2 == null || key1.compareToIgnoreCase(key2) != 0) continue;
                    String val = ListB.get(j).get(idVal);
                    ListA.get(i).put(idVal, val);
                    succes = true;
                    break;
                }
            }
            if (succes) continue;
            ListA.get(i).put(idVal, "");
        }
    }

    public static ArrayList<HashMap<String, String>> searchProcess(HashMap<String, String> searchIndecies, String sProcessId) throws Exception {
        ArrayList result = null;
        Connection con = null;
        StringBuilder query = new StringBuilder("select * from pm_idx_probdo where ");
        StringBuilder queryFiltr = new StringBuilder();
        try {
            con = InternalDataBase.connect();
            result = new ArrayList();
            Set<String> set = searchIndecies.keySet();
            for (String key : set) {
                if (!StringUtils.isBlank((CharSequence)queryFiltr.toString())) {
                    queryFiltr.append(" and ");
                }
                if (StringUtils.isBlank((CharSequence)key)) continue;
                queryFiltr.append("LOWER(REPLACE(");
                queryFiltr.append(key);
                queryFiltr.append(",' ',''))=LOWER(REPLACE('");
                queryFiltr.append(searchIndecies.get(key));
                queryFiltr.append("',' ',''))");
            }
            query.append((CharSequence)queryFiltr);
            result = InternalDataBase.executeQuery((Connection)con, (String)query.toString());
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            InternalDataBase.distconnect((Connection)con);
        }
    }

    public static List<Map<String, String>> getCostsType(Connection con) throws Exception {
        ArrayList<Map<String, String>> result = null;
        StringBuilder query = null;
        try {
            result = new ArrayList();
            query = new StringBuilder("SELECT MARKUPCODE as KOSZTY, TXT as OPIS FROM tim.Wfw_AddChargeCodes");
            result = IntegrationAX.execute(con, query.toString());
            return result;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static List<Map<String, String>> getCostsType(Connection con, String spolka) throws Exception {
        ArrayList<Map<String, String>> result = null;
        StringBuilder query = null;
        try {
            result = new ArrayList();
            query = new StringBuilder("SELECT MARKUPCODE as KOSZTY, TXT as OPIS FROM tim.Wfw_AddChargeCodes WHERE COMPANY = '" + spolka + "'");
            result = IntegrationAX.execute(con, query.toString());
            return result;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static String getReceptionForPz(Connection con, String PzNumebr, String kodDostawcy, String spolka) throws Exception {
        List<Object> result = null;
        StringBuilder query = null;
        try {
            result = new ArrayList();
            query = new StringBuilder("SELECT InventLocationId as ODBIOR FROM WfwAwizoTableView_Bon WHERE AwizoNum = '");
            query.append(PzNumebr.trim());
            query.append("' AND VendAccount='");
            query.append(kodDostawcy.trim());
            query.append("'");
            query.append(" AND COMPANY = '");
            query.append(spolka);
            query.append("'");
            result = IntegrationAX.execute(con, query.toString());
            for (Map map : result) {
                String odbior = (String)map.get("ODBIOR");
                if (StringUtils.isBlank((CharSequence)odbior)) continue;
                return odbior;
            }
            return "";
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static String getReceptionForPz(Connection con, String PzNumebr, String kodDostawcy) throws Exception {
        List<Object> result = null;
        StringBuilder query = null;
        try {
            result = new ArrayList();
            query = new StringBuilder("SELECT InventLocationId as ODBIOR FROM WfwAwizoTableView_Bon WHERE AwizoNum = '");
            query.append(PzNumebr.trim());
            query.append("' AND VendAccount='");
            query.append(kodDostawcy.trim());
            query.append("'");
            result = IntegrationAX.execute(con, query.toString());
            for (Map map : result) {
                String odbior = (String)map.get("ODBIOR");
                if (StringUtils.isBlank((CharSequence)odbior)) continue;
                return odbior;
            }
            return "";
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static String getCostsDescritpion(Connection con, String koszt) throws Exception {
        List<Object> result = null;
        StringBuilder query = null;
        try {
            result = new ArrayList();
            query = new StringBuilder("SELECT TXT as OPIS FROM tim.Wfw_AddChargeCodes WHERE MARKUPCODE='");
            query.append(koszt);
            query.append("'");
            result = IntegrationAX.execute(con, query.toString());
            for (Map map : result) {
                String desc = (String)map.get("OPIS");
                if (StringUtils.isBlank((CharSequence)desc)) continue;
                return desc;
            }
            return "";
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static String getCostsDescritpion(Connection con, String koszt, String spolka) throws Exception {
        List<Object> result = null;
        StringBuilder query = null;
        try {
            result = new ArrayList();
            query = new StringBuilder("SELECT TXT as OPIS FROM tim.Wfw_AddChargeCodes WHERE MARKUPCODE='");
            query.append(koszt);
            query.append("'");
            query.append(" AND COMPANY = '");
            query.append(spolka);
            query.append("'");
            result = IntegrationAX.execute(con, query.toString());
            for (Map map : result) {
                String desc = (String)map.get("OPIS");
                if (StringUtils.isBlank((CharSequence)desc)) continue;
                return desc;
            }
            return "";
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Map<String, String> getArticleNameByCode(Connection mfgxDataBase, String code, String spolka) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> queryResult = null;
        HashMap<String, String> result = null;
        try {
            result = new HashMap<String, String>();
            StringBuilder query = new StringBuilder("SELECT ItemId as KOD_PRODUKTU, ItemName as NAZWA FROM dbo.WfwInventTableView_Bon WHERE ItemId = '");
            query.append(code);
            query.append("'");
            query.append(" AND COMPANY = '");
            query.append(spolka);
            query.append("'");
            queryResult = IntegrationAX.execute(mfgxDataBase, query.toString());
            for (Map<String, String> map : queryResult) {
                result.put("KOD_PRODUKTU", map.get("KOD_PRODUKTU"));
                result.put("NAZWA", map.get("NAZWA"));
            }
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Map<String, String> getArticleNameByCode(Connection mfgxDataBase, String code) throws ClassNotFoundException, SQLException {
        List<Map<String, String>> queryResult = null;
        HashMap<String, String> result = null;
        try {
            result = new HashMap<String, String>();
            StringBuilder query = new StringBuilder("SELECT ItemId as KOD_PRODUKTU, ItemName as NAZWA FROM dbo.WfwInventTableView_Bon WHERE ItemId = '");
            query.append(code);
            query.append("'");
            queryResult = IntegrationAX.execute(mfgxDataBase, query.toString());
            for (Map<String, String> map : queryResult) {
                result.put("KOD_PRODUKTU", map.get("KOD_PRODUKTU"));
                result.put("NAZWA", map.get("NAZWA"));
            }
            return result;
        }
        catch (NullPointerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static List<String> SearchProces(HashMap<String, Object> searchVar, String sProcessDefId, ProcessState processState) throws Exception {
        ArrayList<String> results = new ArrayList<String>();
        ProcessFinder processFinder = FinderFactory.getProcessFinder();
        List processes = processFinder.findByIndexes(sProcessDefId, searchVar, new String[0]);
        for (Process process : processes) {
            if (!process.getState().equals((Object)processState)) continue;
            results.add(process.getProcessId());
        }
        return results;
    }
}

