Action = {
        t: PW.I18N.createT('com.suncode.client-eris')
    };
/**
 * Okno informacyjne z wymogiem komentarza w przypadku klinięcia na OK
 */
PW.FormValidators.create('comment-required-if-function-failure-validator', {

    callback: function(message) {
    	this.message = message;
    	this.confirmWindow();
    },
    confirmWindow : function()
	{
		var me = this;
		Ext4.Msg.show({
			title: Action.t('validator.comment-required-if-function.title'),
			msg: me.message,
			buttons: Ext4.Msg.YESNO,
			icon: Ext4.Msg.QUESTION,
			fn: function(btn) 
			{
				if(btn === 'yes') 
				{
					me.showCommentWindow();
				}
			}
		});
	},
	showCommentWindow: function() 
	{
		if (!this.commentWindow)
		{
			this.createCommentWindow();
		}
        this.commentWindow.show();
    },
    createCommentWindow : function()
    {
    	var me = this;
    	var commentWindowDef =  new Ext4.define('Client.msg.commentWindow', { 
    		
    		extend: 'Ext4.window.Window',
    		height: 180,
    		width: 490,
    		layout: 'fit',
    		modal: true,
    		buttonAlign: 'right',
    		closable: false,
   	     
    		title: Action.t('leave-comment.window-title'),
   	     
    		items: [{
    			xtype: 'form',
    			frame: false,
    			border: 0,
    			layout: {
    				type: 'hbox',
    				align: 'middle'
    			},
    			fieldDefaults: {
    				msgTarget: 'side',
    				labelWidth: 70
    			},
    			items: [{
    				xtype: 'container',
    				flex: 1,
    				padding: 10,
    				layout: {
    					type: 'vbox',
    					align: 'stretch'
    				},
    				items: [{
    					xtype: 'textareafield',
    					itemId: 'commentWindow_textarea',
    					name: 'comment',
    					allowBlank: false,
    					flex: 1,
    					maxLength: 4000,
    					maxLengthText: Action.t('leave-comment.max-length-text')
    				}]
    			}]
    		}],
    		buttons: [{
    			text: Action.t('leave-comment.accept-button-name'),
    			itemId: 'acceptButton',
    			handler: function () 
    			{
    				var isValid = this.up('window').down('form').getForm().isValid();
    				if (isValid) 
    				{
    					var cfg = {
    							success: function ()
    							{
    								this.closeWindow();
    								this.confirm();
    							},
    							failure: function (response)
    							{
    								Ext4.Msg.show({
    									title: Action.t("leave-comment.errortitle"),
    									msg: Action.t("leave-comment.errormsg") + response,
    									buttons: Ext4.Msg.OK,
    									icon: Ext4.Msg.ERROR,
    								});
    							},
    							scope: me
    					}
    					CommentService.add(this.up('window').down('textareafield').getValue(), cfg);
    				}
    			},
    		}]
    	});
    	this.commentWindow = Ext4.create('Client.msg.commentWindow');
   	},
   	closeWindow : function()
   	{
   		this.commentWindow.hide();
    }
});