Action = {
        t: PW.I18N.createT('com.suncode.client-eris')
    };
/**
 * Form of application.extended-send-mail application
 */

PWE.integrationComponent.registerApplication( 'extended-send-mail-app', {
	apiVersion: 2,
    buildForm: function( form , options ) {
    	form.addField({
    		id : "subject",
        	hidden: false,
        	optional: false
        });
    	form.addField({
    		id : "templatePath",
            hidden: false,
            optional: false
        }); 
    	form.addField({
    		id : "jsonData",
        	hidden: false,
        	optional: false
        }); 
    	form.addField({
    		id : "attachments",
    		hidden: false,
    		optional: false,
            listeners: {
                change: function (value) 
                {
                    if (value) {
                    	form.show("onlyLastTaskAttachments");
                    	form.show("attachmentsDocClasses");
                    } else {
                    	form.hide("onlyLastTaskAttachments");
                        form.hide("attachmentsDocClasses");
                    }
                }
            }
        }); 
    	form.addField({
    		id : "onlyLastTaskAttachments",
    		hidden: true,
    		optional: false
        });  
        form.addCombobox({
			id: "attachmentsDocClasses",
			hidden: true,
			optional: false,
			remote: {
				url: "plugin/com.suncode.client-eris/component/docClassList",
				fields: [
					{
						name: "docClassName",
						type: "string"
					},
					{
						name: "docClassId",
						type: "string"
					}
				]
			},
			template: [
				{
					label: Action.t("application.extended-send-mail.docClassName.name"),
					field: "docClassName"
				},
				{
					label: Action.t("application.extended-send-mail.docClassId.name"),
					field: "docClassId"
				}
			],
			valueField: "docClassName",
			displayField: "docClassName",
			sort: [{
				property: "docClassName",
				direction: "ASC"
			}],
		});
        if (form.getValue("attachments", false) == false) {

            form.hide("onlyLastTaskAttachments");
            form.hide("attachmentsDocClasses");
        } 
    }
});