/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.validators;

import com.suncode.client.common.Categories;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.annotation.ValidatorsScript;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Validator
@ValidatorsScript(value="scripts/validators-callbacks/activity-documents-counter.js")
public class ActivityDocumentsCount {
    private static Logger log = LoggerFactory.getLogger(ActivityDocumentsCount.class);
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentFinder documentFinder;

    @Define
    public void action(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("activity-document-count-validator")).name("validator.activity-document-count.name")).description("validator.activity-document-count.desc")).icon((Icon)SilkIconPack.DATABASE_ERROR)).category(new Category[]{Categories.WC})).parameter().id("docClassName").name("validator.activity-document-count.docClassName.name").description("validator.activity-document-count.docClassName.desc").type((Type)Types.STRING).create()).parameter().id("maxAmount").name("validator.activity-document-count.maxAmountname").description("validator.activity-document-count.maxAmount.desc").type((Type)Types.INTEGER).create();
    }

    public void validate(@Param String docClassName, @Param int maxAmount, ValidationContext validationContext, ValidationErrors errors) {
        log.trace("***ActivityDocumentsCount - start***");
        int counter = 0;
        String activityId = validationContext.getActivityId();
        String processId = validationContext.getProcessId();
        Long docClassId = this.documentClassService.getDocumentClass(docClassName, new String[0]).getId();
        log.debug("Id klasy dokument\u00f3w: " + docClassId);
        if (docClassId != null) {
            List documents = this.documentFinder.getDocumentsFromActivity(processId, activityId, new String[]{"documentClass"});
            log.debug("documents " + documents.size());
            for (WfDocument wfDocument : documents) {
                Long docClassIdToCompare = wfDocument.getDocumentClassId();
                log.debug("Id klasy dokument\u00f3w do por\u00f3wnania " + docClassIdToCompare);
                if (Long.compare(docClassId, docClassIdToCompare) != 0) continue;
                log.debug("Dokument: " + wfDocument.getFile().getSystemFileName());
                ++counter;
            }
        }
        log.debug("Ilo\u015b\u0107 znalezionych dokument\u00f3w z klasy " + docClassName + " : " + counter);
        if (counter > maxAmount) {
            errors.invokeCallback((Object)maxAmount);
        }
        log.trace("***ActivityDocumentsCount - end***");
    }
}

