/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.tasks;

import com.suncode.client.common.Categories;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.Serializer;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class GenerateXMLFile {
    private Logger log = LoggerFactory.getLogger(GenerateXMLFile.class);
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentService documentService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("generate-xml-file-app")).name("application.generate-xml-file.name")).description("application.generate-xml-file.desc")).category(new Category[]{Categories.DS})).icon((Icon)SilkIconPack.APPLICATION)).parameter().id("dcClassForXMLFile").name("application.generate-xml-file.dcClassForXMLFile.name").description("application.generate-xml-file.dcClassForXMLFile.desc").type((Type)Types.STRING).create()).parameter().id("destXMLFilePath").name("application.generate-xml-file.destXMLFilePath.name").description("application.generate-xml-file.destXMLFilePath.desc").type((Type)Types.STRING).create()).parameter().id("xmlFileName").name("application.generate-xml-file.xmlFileName.name").type((Type)Types.STRING).create()).parameter().id("variables").name("application.generate-xml-file.variables.name").type((Type)Types.VARIABLE_ARRAY).create();
    }

    public void execute(@Param String dcClassForXMLFile, @Param String destXMLFilePath, @Param String xmlFileName, @Param Variable[] variables, ApplicationContext context) throws Exception {
        block11: {
            this.log.debug("***start GenerateXMLFile ***");
            String processId = context.getProcessId();
            String activityId = context.getActivityId();
            try {
                File xmlFilesDir = FileUtils.getFile((String[])new String[]{destXMLFilePath});
                if (!xmlFilesDir.exists() || !xmlFilesDir.isDirectory()) {
                    throw new IllegalArgumentException("Niepoprawna \u015bcie\u017cka do katalogu XML: " + destXMLFilePath);
                }
                xmlFileName = xmlFileName.replace("\\", "_").replace("/", "_");
                String fullDestXMLFilePath = "";
                fullDestXMLFilePath = destXMLFilePath.endsWith("\\") || destXMLFilePath.endsWith("/") ? destXMLFilePath.concat(xmlFileName).concat(".xml") : destXMLFilePath.concat("\\").concat(xmlFileName).concat(".xml");
                HashMap<String, String> nameAndValueOfVariables = new HashMap<String, String>();
                for (Variable variable : variables) {
                    nameAndValueOfVariables.put(this.changePolishWords(variable.getName()), (String)variable.getValue());
                }
                this.log.debug("Pelna sciezka do pliku: ".concat(fullDestXMLFilePath));
                File xmlFile = this.getXMLFile(fullDestXMLFilePath, nameAndValueOfVariables);
                this.log.debug("Dodaje plik do archiwum");
                if (xmlFile != null) {
                    try (FileInputStream fis = new FileInputStream(xmlFile);){
                        DocumentClass documentClass = this.documentClassService.getDocumentClass(dcClassForXMLFile, new String[]{"actions"});
                        if (documentClass != null) {
                            HashMap idx = new HashMap();
                            DocumentDefinition definition = new DocumentDefinition();
                            definition.setDocumentClassId(documentClass.getId());
                            definition.setFileName(fullDestXMLFilePath);
                            definition.setDescription("");
                            definition.setUserName("admin");
                            definition.setIndexes(idx);
                            definition.setInputStream((InputStream)fis);
                            definition.setActivityId(activityId);
                            definition.setProcessId(processId);
                            definition.setSaveAsNewVersion(false);
                            WfDocument document = this.documentService.addDocument(definition);
                            this.log.debug("Dokument faktury zosta\u0142 dodany do archiwum: fileid: " + document.getId() + ", filename: " + xmlFileName);
                            this.documentService.attachDocumentToProcess(document, "admin", processId, activityId);
                            this.log.debug("Dokument faktury zosta\u0142 dodany do procesu: " + processId);
                        }
                        break block11;
                    }
                }
                throw new Exception("B\u0141\u0104D - dokument faktury nie zosta\u0142 wygenerowany: ");
            }
            catch (Exception e) {
                this.log.debug(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    private File getXMLFile(String destXMLFilePath, Map<String, String> nameAndValueOfVariables) throws Exception {
        File f = new File(destXMLFilePath);
        try (FileOutputStream outputStream = new FileOutputStream(f);){
            Processor p = new Processor(false);
            Serializer s = p.newSerializer();
            s.setOutputProperty(Serializer.Property.METHOD, "xml");
            s.setOutputProperty(Serializer.Property.INDENT, "yes");
            s.setOutputStream((OutputStream)outputStream);
            StreamWriterToReceiver out = s.getXMLStreamWriter();
            out.writeStartDocument("UTF-8", "1.0");
            out.writeStartElement("Root");
            out.writeStartElement("Document-DS");
            for (String key : nameAndValueOfVariables.keySet()) {
                out.writeStartElement(key);
                out.writeCharacters(nameAndValueOfVariables.get(key));
                out.writeEndElement();
            }
            out.writeEndElement();
            out.writeEndElement();
            out.writeEndDocument();
            out.close();
        }
        return f;
    }

    private String changePolishWords(String text) {
        StringBuilder sb = new StringBuilder();
        block20: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\u0105': {
                    sb.append('a');
                    continue block20;
                }
                case '\u0107': {
                    sb.append('c');
                    continue block20;
                }
                case '\u0119': {
                    sb.append('e');
                    continue block20;
                }
                case '\u0142': {
                    sb.append('l');
                    continue block20;
                }
                case '\u0144': {
                    sb.append('n');
                    continue block20;
                }
                case '\u00f3': {
                    sb.append('o');
                    continue block20;
                }
                case '\u015b': {
                    sb.append('s');
                    continue block20;
                }
                case '\u017a': {
                    sb.append('z');
                    continue block20;
                }
                case '\u017c': {
                    sb.append('z');
                    continue block20;
                }
                case '\u0104': {
                    sb.append('A');
                    continue block20;
                }
                case '\u0106': {
                    sb.append('C');
                    continue block20;
                }
                case '\u0118': {
                    sb.append('E');
                    continue block20;
                }
                case '\u0141': {
                    sb.append('L');
                    continue block20;
                }
                case '\u0143': {
                    sb.append('N');
                    continue block20;
                }
                case '\u00d3': {
                    sb.append('O');
                    continue block20;
                }
                case '\u015a': {
                    sb.append('S');
                    continue block20;
                }
                case '\u0179': {
                    sb.append('Z');
                    continue block20;
                }
                case '\u017b': {
                    sb.append('Z');
                    continue block20;
                }
                default: {
                    sb.append(text.charAt(i));
                }
            }
        }
        return sb.toString().replaceAll(" ", "");
    }
}

