/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.tasks;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.client.common.Categories;
import com.suncode.cuf.automatictask.mail.ReceiverJson;
import com.suncode.cuf.automatictask.mail.ReceiverTypes;
import com.suncode.cuf.automatictask.mail.receivers.Receiver;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityEntity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class ExtendedSendMail {
    private static Logger log = LoggerFactory.getLogger(ExtendedSendMail.class);
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private UserService userService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("extended-send-mail-app")).name("application.extended-send-mail.name")).description("application.extended-send-mail.desc")).category(new Category[]{Categories.WC})).icon((Icon)SilkIconPack.EMAIL_GO)).parameter().id("subject").name("extended-send-mail.subject.name").description("extended-send-mail.subject.desc").type((Type)Types.STRING).create()).parameter().id("templatePath").name("extended-send-mail.templatePath.name").description("extended-send-mail.templatePath.desc").type((Type)Types.STRING).create()).parameter().id("jsonData").name("extended-send-mail.jsonData.name").description("extended-send-mail.jsonData.desc").type((Type)Types.STRING).create()).parameter().id("attachments").name("extended-send-mail.attachments.name").defaultValue((Object)false).type((Type)Types.BOOLEAN).create()).parameter().id("onlyLastTaskAttachments").name("extended-send-mail.onlyLastTaskAttachments.name").description("extended-send-mail.onlyLastTaskAttachments.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("attachmentsDocClasses").name("extended-send-mail.attachmentsDocClasses.name").description("extended-send-mail.attachmentsDocClasses.desc").type((Type)Types.STRING_ARRAY).create();
    }

    public void execute(ApplicationContext context, ActivityContextMap contextMap, @Param String subject, @Param String templatePath, @Param String jsonData, @Param Boolean attachments, @Param Boolean onlyLastTaskAttachments, @Param String[] attachmentsDocClasses) throws Exception {
        String processId = context.getProcessId();
        String activityId = context.getActivityId();
        Map processContext = this.processService.getProcessContext(processId);
        List<Object> listAttachments = new ArrayList();
        if (attachments.booleanValue()) {
            List listAttachmentsTemp = new ArrayList();
            listAttachmentsTemp = onlyLastTaskAttachments != false ? this.documentFinder.getDocumentsFromActivity(processId, activityId, new String[]{"documentClass"}) : this.documentFinder.getDocumentsFromProcess(processId, new String[]{"documentClass"});
            listAttachments = this.reduceAttachmentsToDocClasses(attachmentsDocClasses, listAttachmentsTemp);
            log.debug("Attachments to send:");
            listAttachments.forEach(document -> log.debug(document.getFile().getFileName()));
        }
        Collection collectionReceivers = null;
        try {
            collectionReceivers = (Collection)new ObjectMapper().readValue(jsonData, (TypeReference)new TypeReference<Collection<ReceiverJson>>(){});
        }
        catch (IOException e) {
            log.error("Invalid list of receivers: " + jsonData);
            throw new IllegalArgumentException("Invalid list of receivers: " + jsonData, e);
        }
        String sParsedContent = this.replaceExpressions(this.getHtmlFromTemplate(templatePath), processContext);
        String sParsedSubject = this.replaceExpressions(subject, processContext);
        ArrayList listMailsCompleted = new ArrayList();
        for (ReceiverJson receiver : collectionReceivers) {
            Receiver rec = this.getReceiver(receiver.getType());
            rec.send(receiver.getValue(), sParsedSubject, sParsedContent, listAttachments, listMailsCompleted, processId);
        }
    }

    private List<WfDocument> reduceAttachmentsToDocClasses(String[] attachmentsDocClasses, List<WfDocument> listAttachmentsToReduce) {
        ArrayList<WfDocument> reducedAttachments = new ArrayList<WfDocument>();
        for (String docClassName : attachmentsDocClasses) {
            DocumentClass docClass = this.documentClassService.getDocumentClass(docClassName, new String[0]);
            Long docClassIdToFind = docClass.getId();
            for (WfDocument wfDocument : listAttachmentsToReduce) {
                Long docClassIdToCheck = wfDocument.getDocumentClassId();
                if (Long.compare(docClassIdToCheck, docClassIdToFind) != 0) continue;
                reducedAttachments.add(wfDocument);
            }
        }
        return reducedAttachments;
    }

    public Receiver getReceiver(ReceiverTypes type) {
        Map receivers = SpringContext.getInstance().getBeansOfType(Receiver.class);
        for (Map.Entry entry : receivers.entrySet()) {
            if (!((Receiver)entry.getValue()).getType().equals((Object)type)) continue;
            return (Receiver)entry.getValue();
        }
        throw new NullPointerException(String.format("Not found receiver (type %s)", type));
    }

    private String getHtmlFromTemplate(String sTemplate) throws IOException {
        String htmlContent = null;
        try {
            htmlContent = new Scanner(new File(sTemplate), "UTF-8").useDelimiter("\\Z").next();
        }
        catch (IOException e) {
            throw new IOException("Niepoprawna \u015bcie\u017cka do szablonu: " + sTemplate, e);
        }
        return htmlContent;
    }

    private String replaceExpressions(String sData, Map<String, Object> mapProcessContext) {
        Activity activity = this.activityService.getActivity(mapProcessContext.get("ProccessId").toString(), mapProcessContext.get("ActivityId").toString(), new String[0]);
        Process process = this.processService.getProcess(mapProcessContext.get("ProccessId").toString(), new String[]{"processDefinition"});
        List listActivities = this.activityFinder.findByProcessId(process.getProcessId(), new String[0]);
        Date processStartTime = null;
        for (Activity act : listActivities) {
            if (processStartTime != null && !act.getLastStateTime().after(processStartTime) || !act.getState().equals((Object)ActivityState.COMPLETED)) continue;
            processStartTime = act.getLastStateTime();
            activity = act;
        }
        HashMap<String, Object> mapExpressions = new HashMap<String, Object>();
        mapExpressions.put("processname", process.getDescription());
        mapExpressions.put("processdescription", process.getDescription());
        mapExpressions.put("processtype", process.getProcessDefinition().getProcessDefinitionId());
        mapExpressions.put("processstarttime", new SimpleDateFormat("HH:mm").format(processStartTime));
        mapExpressions.put("processstartday", new SimpleDateFormat("dd-MM-yyy").format(processStartTime));
        mapExpressions.put("activityname", activity.getName());
        mapExpressions.put("activitystarttime", new SimpleDateFormat("HH:mm").format(activity.getCreatedTime()));
        mapExpressions.put("activitystartday", new SimpleDateFormat("dd-MM-yyyy").format(activity.getCreatedTime()));
        mapExpressions.putAll(this.getRealUsersName(sData, process.getProcessId()));
        mapExpressions.putAll(this.getTaskUsers(sData, process.getProcessId()));
        mapExpressions.putAll(this.getLinks(sData, process.getProcessId()));
        mapExpressions.putAll(mapProcessContext);
        for (String str : mapExpressions.keySet()) {
            sData = sData.replace("@" + str + "@", mapExpressions.get(str).toString());
        }
        return sData;
    }

    private Map<String, String> getRealUsersName(String sData, String sProcessId) {
        Map mapProcessContext = this.processService.getProcessContext(sProcessId);
        HashMap<String, String> mapRealUsersName = new HashMap<String, String>();
        int fromIndex = 0;
        while (sData.indexOf("@realusername#", fromIndex) != -1) {
            int endIndex;
            int beginIndex = sData.indexOf("@realusername#", fromIndex) + "@realusername#".length();
            fromIndex = endIndex = sData.indexOf("@", beginIndex);
            String sProcessVariable = sData.substring(beginIndex, endIndex);
            try {
                String sUserName = mapProcessContext.get(sProcessVariable).toString();
                if (sUserName.length() <= 0) continue;
                try {
                    String sUserFullName = this.userService.getUser(sUserName, new String[0]).getFullName();
                    mapRealUsersName.put("realusername#" + sProcessVariable, sUserFullName);
                }
                catch (NullPointerException e) {
                    mapRealUsersName.put("realusername#" + sProcessVariable, "@u\u017cytkownik nie istnieje!@");
                }
            }
            catch (NullPointerException e) {
                mapRealUsersName.put("realusername#" + sProcessVariable, "@realusername#" + sProcessVariable + ": (brak zmiennej w procesie)@");
            }
        }
        return mapRealUsersName;
    }

    private Map<String, String> getTaskUsers(String sData, String sProcessId) {
        List listActivity = this.activityFinder.findByProcessId(sProcessId, new String[0]);
        HashMap<String, String> mapTaskUsers = new HashMap<String, String>();
        int fromIndex = 0;
        while (sData.indexOf("@taskuser#", fromIndex) != -1) {
            int endIndex;
            int beginIndex = sData.indexOf("@taskuser#", fromIndex) + "@taskuser#".length();
            fromIndex = endIndex = sData.indexOf("@", beginIndex);
            String sActivityDefId = sData.substring(beginIndex, endIndex);
            String sActivityId = null;
            for (Activity activity : listActivity) {
                if (!activity.getActivityDefinitionId().equals(sActivityDefId)) continue;
                sActivityId = activity.getActivityId();
                break;
            }
            ActivityEntity activity = (ActivityEntity)this.activityService.getActivity(sProcessId, sActivityId, new String[0]);
            User user = this.userService.getUser(activity.getResourceId(), new String[0]);
            mapTaskUsers.put("taskuser#" + sActivityDefId, user.getFullName());
        }
        return mapTaskUsers;
    }

    private Map<String, String> getLinks(String sData, String sProcessId) {
        List listActivity = this.activityFinder.findByProcessId(sProcessId, new String[0]);
        HashMap<String, String> mapLinks = new HashMap<String, String>();
        String sHttpLink = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HTTPLINK);
        int fromIndex = 0;
        while (sData.indexOf("@link#", fromIndex) != -1) {
            int endIndex;
            int beginIndex = sData.indexOf("@link#", fromIndex) + "@link#".length();
            fromIndex = endIndex = sData.indexOf("@", beginIndex);
            String sActivityDefId = sData.substring(beginIndex, endIndex);
            String sActivityId = null;
            for (Activity activity : listActivity) {
                if (!activity.getActivityDefinitionId().equals(sActivityDefId)) continue;
                sActivityId = activity.getActivityId();
                break;
            }
            mapLinks.put("link#" + sActivityDefId, sHttpLink + "/ShowDetailHistory.do?histActivityId=" + sActivityId + "&ProcessId=" + sProcessId);
        }
        String sHistoryLink = sHttpLink + "/ShowProcessHistory.do?ProcessId=" + sProcessId;
        mapLinks.put("historylink", sHistoryLink);
        return mapLinks;
    }
}

