/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.tasks;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.client.common.Categories;
import com.suncode.pwfl.administration.configuration.SystemParameterService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.ShaKey;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class CreateZOProcesses {
    private static final String INVOICE_DEFINIOTION_ID = "zmiana_opak";
    private static ShaKey processKey = (ShaKey)SpringContext.getBean(ShaKey.class);
    private Logger log = LoggerFactory.getLogger(CreateZOProcesses.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private CommentService commentService;
    @Autowired
    private SystemParameterService systemParameterService;
    private static final String[] ZWO_COL_IDS = new String[]{"powod_zmiany", "indeks_wg", "nazwa_wg", "marka", "indeks_opakowania", "nazwa_opakowania", "odpowiedzialny_za_indek", "ilosc_aktywnych_zmian_o", "tryb_zmiany", "opis_zmiany", "tworzacy_sprawe_login", "tworzacy_sprawe"};
    private static final String[] ZO_VAR_IDS = new String[]{"powod_zmiany", "indeks_wg", "nazwa_wg", "marka", "indeks_opakowania", "nazwa_opakowania", "odpowiedzialny_za_index", "ilosc_aktywnych_zmopak", "tryb_zmiany", "opis_zmiany", "Initiator", "wnioskujacy"};

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("create_zo_processes-app")).name("application.create_zo_processes.name")).description("application.create_zo_processes.desc")).category(new Category[]{Categories.ZWO})).icon((Icon)SilkIconPack.APPLICATION)).parameter().id("createdProcessLinkColumn").name("application.create_zo_processes.createdProcessLinkColumn.name").type((Type)Types.VARIABLE).create();
    }

    public void execute(@Param Variable createdProcessLinkColumn, ApplicationContext context) {
        this.log.debug("***Starting CreateZOProcesses ***");
        String processId = context.getProcessId();
        String activityId = context.getActivityId();
        Map processContext = this.processService.getProcessContext(processId);
        int currentLine = -1;
        try {
            ArrayList<String> linksToNewProcesses = new ArrayList<String>();
            List odzTable = DynamicTableFunctions.convertFromMapToListOfMaps((Map)processContext, (String[])ZWO_COL_IDS);
            for (int i = 0; i < odzTable.size(); ++i) {
                currentLine = i;
                ProcessBuilderDefinition definition = this.buildProcesseDefinition(processContext, (Map)odzTable.get(i));
                String newProcessId = this.processService.createProcess(definition);
                this.log.debug("Created processId: " + newProcessId);
                Process newProcess = this.processService.getProcess(newProcessId, new String[0]);
                String newProcessName = newProcess.getName();
                this.addComment(processId, activityId, "admin", "Utworzono proces o nazwie " + newProcessName, new Date().getTime());
                String generatedLink = this.getLinkToNewProces(newProcessId, newProcessName);
                this.log.debug("Link to new process: " + generatedLink);
                linksToNewProcesses.add(generatedLink);
            }
            String[] arrayOfLinks = (String[])linksToNewProcesses.stream().toArray(String[]::new);
            this.log.debug("Array of links: " + arrayOfLinks.toString());
            createdProcessLinkColumn.setValue((Object)arrayOfLinks);
        }
        catch (Exception e) {
            this.log.debug("Error while creating new process for line " + currentLine + " : " + e.getMessage());
            this.addComment(processId, activityId, "admin", "B\u0142\u0105d podczas tworzenia nowego procesu dla linii " + currentLine + " : " + e.getMessage(), new Date().getTime());
            throw e;
        }
        this.log.debug("***End CreateZOProcesses ***");
    }

    private ProcessBuilderDefinition buildProcesseDefinition(Map<String, Object> processContext, Map<String, String> odzRow) {
        String username = SystemProperties.getString((String)"SchedulerToolAgent.sharkUsername");
        String password = SystemProperties.getPassword((String)"AdminPassword");
        Map<String, Object> variables = this.prepareVariables(odzRow);
        String invoicePackageId = this.findInvoicePackageId();
        ProcessBuilderDefinition definition = new ProcessBuilderDefinition();
        definition.setPackageId(invoicePackageId);
        definition.setProcessDefId(INVOICE_DEFINIOTION_ID);
        definition.setCreator(username);
        definition.setCreatorPassword(password);
        definition.setVariables(variables);
        definition.setAutoStart(true);
        return definition;
    }

    private String findInvoicePackageId() {
        return this.processService.getProcessDefinition(INVOICE_DEFINIOTION_ID).getPackageId();
    }

    private Map<String, Object> prepareVariables(Map<String, String> odzRow) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(ZO_VAR_IDS[0], odzRow.get(ZWO_COL_IDS[0]));
        variables.put(ZO_VAR_IDS[1], odzRow.get(ZWO_COL_IDS[1]));
        variables.put(ZO_VAR_IDS[2], odzRow.get(ZWO_COL_IDS[2]));
        variables.put(ZO_VAR_IDS[3], odzRow.get(ZWO_COL_IDS[3]));
        variables.put(ZO_VAR_IDS[4], odzRow.get(ZWO_COL_IDS[4]));
        variables.put(ZO_VAR_IDS[5], odzRow.get(ZWO_COL_IDS[5]));
        variables.put(ZO_VAR_IDS[6], odzRow.get(ZWO_COL_IDS[6]));
        variables.put(ZO_VAR_IDS[7], odzRow.get(ZWO_COL_IDS[7]));
        variables.put(ZO_VAR_IDS[8], odzRow.get(ZWO_COL_IDS[8]));
        variables.put(ZO_VAR_IDS[9], odzRow.get(ZWO_COL_IDS[9]));
        variables.put(ZO_VAR_IDS[10], odzRow.get(ZWO_COL_IDS[10]));
        variables.put(ZO_VAR_IDS[11], odzRow.get(ZWO_COL_IDS[11]));
        return variables;
    }

    private String getLinkToNewProces(String processId, String alias) {
        String link = this.systemParameterService.getParameter("HTTPLink").getValueString();
        Object keyLink = "";
        try {
            keyLink = "&key=" + processKey.get(processId);
        }
        catch (RuntimeException e) {
            this.log.error("Wyst\u0105pi\u0142 problem podczas generowania klucza", (Throwable)e);
        }
        return String.valueOf(link) + "/ShowProcessHistory.do?ProcessId=" + processId + (String)keyLink + "=()=" + alias;
    }

    public void addComment(String processId, String activityId, String userId, String commentMsg, Long timeStamp) {
        Comment comment = new Comment();
        comment.setProcessId(processId);
        comment.setActivityId(activityId);
        comment.setTimestamp(timeStamp);
        comment.setUserId(userId);
        comment.setComment(commentMsg);
        this.commentService.createComment(comment);
    }
}

