/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.tasks;

import com.suncode.client.common.Categories;
import com.suncode.client.tools.CommonTools;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityDocumentService;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class AttachDocumentsFromActivity {
    public static Logger log = Logger.getLogger(AttachDocumentsFromActivity.class);
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private ActivityDocumentService activityDocumentService;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentService documentService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("attach-document-from-activity-app")).name("application.attach-document-from-activity.name")).description("application.attach-document-from-activity.desc")).category(new Category[]{Categories.WC})).icon((Icon)SilkIconPack.PAGE_ATTACH)).parameter().id("docActivityIds").name("attach-document-from-activity.docActivityIds.name").description("attach-document-from-activity.docActivityIds.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("withDocClasses").name("attach-document-from-activity.withDocClasses.name").description("attach-document-from-activity.withDocClasses.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("margeActivityId").name("attach-document-from-activity.margeActivityId.name").description("attach-document-from-activity.margeActivityId.desc").type((Type)Types.STRING).create();
    }

    public void execute(ApplicationContext context, ActivityContextMap contextMap, @Param String[] docActivityIds, @Param String[] withDocClasses, @Param String margeActivityId) throws Exception {
        log.trace((Object)"***AttachDocumentsFromActivity - start****");
        String processId = context.getProcessId();
        String activityId = context.getActivityId();
        try {
            Set<String> docActivityIdsSet = Arrays.stream(docActivityIds).collect(Collectors.toSet());
            Set withDocClassesSet = Arrays.stream(withDocClasses).collect(Collectors.toSet());
            log.debug((Object)("docActivityIds=" + docActivityIdsSet));
            log.debug((Object)("withDocClasses=" + withDocClassesSet));
            HashSet<Long> classIdsToIncludeSet = new HashSet<Long>();
            for (String docClassName : withDocClasses) {
                Long docClassId = this.documentClassService.getDocumentClass(docClassName, new String[0]).getId();
                if (docClassId == null) continue;
                classIdsToIncludeSet.add(docClassId);
            }
            log.debug((Object)("classIdsToInclude=" + classIdsToIncludeSet));
            log.debug((Object)"detachDocumentsFromCurrentActivity");
            this.detachDocumentsFromMargeActivity(processId, margeActivityId);
            log.debug((Object)"rewriteDocuments");
            this.rewriteDocuments(processId, activityId, docActivityIdsSet, classIdsToIncludeSet);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            new CommonTools().AddCommentToday(processId, activityId, "ERROR: " + e.getMessage());
            throw e;
        }
        log.trace((Object)"***AttachDocumentsFromActivity - end****");
    }

    private void detachDocumentsFromMargeActivity(String processId, String activityDefId) {
        DetachedCriteria dc = DetachedCriteria.forClass(Activity.class);
        dc.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"activityDefinitionId", (Object)activityDefId), (Criterion)Restrictions.eq((String)"processId", (Object)processId)));
        List activityList = this.activityFinder.findByCriteria(dc);
        activityList.forEach(activity -> log.debug((Object)("foundActivity: " + activity.getActivityId())));
        for (Activity activity2 : activityList) {
            String activityId = activity2.getActivityId();
            log.debug((Object)("Od\u0142\u0105czanie dokument\u00f3w dla " + activityId));
            List documents = this.documentFinder.getDocumentsFromActivity(processId, activityId, new String[]{"documentClass"});
            if (documents == null) continue;
            for (WfDocument wfDocument : documents) {
                this.activityDocumentService.detachDocumentFromActivity(wfDocument, processId, activityId);
                log.debug((Object)("Od\u0142\u0105czono " + wfDocument.getFile().getFileName()));
            }
        }
    }

    private void rewriteDocuments(String processId, String activityId, Set<String> docActivityIds, Set<Long> classIdsToInclude) {
        HashSet attachedDocuments = new HashSet();
        List<Activity> activities = this.getActivitiesByIds(docActivityIds, processId);
        log.debug((Object)("activities: " + activities));
        activities.forEach(activity -> {
            List documents = this.activityDocumentService.getActivityDocuments(processId, activity.getActivityId(), new String[0]);
            documents.forEach(aDocument -> {
                WfDocument wfDocument = this.documentService.getDocument(Long.valueOf(aDocument.getFile().getId()));
                if (classIdsToInclude.contains(wfDocument.getDocumentClassId())) {
                    this.documentService.attachDocumentToProcess(wfDocument, wfDocument.getFile().getUploader(), processId, activityId);
                    attachedDocuments.add(wfDocument);
                } else {
                    this.documentService.detachDocumentFromProcess(wfDocument, processId);
                }
            });
        });
        attachedDocuments.forEach(wfdocument -> log.debug((Object)("Pod\u0142\u0105czono dokument o nazwie: " + wfdocument.getFile().getFileName())));
    }

    private List<Activity> getActivitiesByIds(Set<String> docActivityIds, String processId) {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        docActivityIds.forEach(activityId -> {
            Activity activity = this.getLastActivityByProcesIdAndActivityDefinitionId(processId, (String)activityId);
            if (activity != null) {
                activities.add(activity);
            }
        });
        return activities;
    }

    private Activity getLastActivityByProcesIdAndActivityDefinitionId(String processId, String activityId) {
        Activity result = null;
        List activitis = this.activityFinder.findByProcessId(processId, new String[]{"process"});
        for (Activity activity : activitis) {
            if (result == null && activity.getActivityDefinitionId().equals(activityId)) {
                result = activity;
                continue;
            }
            if (!activity.getActivityDefinitionId().equals(activityId) || result.getStartedTime().getTime() >= activity.getStartedTime().getTime()) continue;
            result = activity;
        }
        return result;
    }
}

