/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.setters;

import com.suncode.client.common.Categories;
import com.suncode.client.db.models.ReqAcceptance;
import com.suncode.client.db.services.ReqAcceptanceService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.form.variablesetter.VariableSetterDefinitionBuilder;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@VariableSetter
public class ReqUserAcceptance {
    public static Logger log = Logger.getLogger(ReqUserAcceptance.class);
    @Autowired
    private UserService userService;
    @Autowired
    private CommentService commentService;
    @Autowired
    private ReqAcceptanceService reqAcceptanceService;

    @Define
    public void definition(VariableSetterDefinitionBuilder builder) {
        ((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)builder.id("req-user-acceptance-setter")).name("setter.req-user-acceptance.name")).description("setter.req-user-acceptance.desc")).category(new Category[]{Categories.WC})).icon((Icon)SilkIconPack.USER_SUIT)).parameter().id("brand").name("setter.req-user-acceptance.brand.name").type((Type)Types.STRING).create()).parameter().id("salesChannel").name("setter.req-user-acceptance.salesChannel.name").type((Type)Types.STRING).create()).parameter().id("userToCompare").name("setter.req-user-acceptance.userToCompare.name").description("setter.req-user-acceptance.userToCompare.desc").type((Type)Types.STRING).create()).parameter().id("foundAcceptanceData").name("setter.req-user-acceptance.foundAcceptanceData.name").description("setter.req-user-acceptance.foundAcceptanceData.desc").type((Type)Types.VARIABLE).create()).parameter().id("userToAcceptLogin").name("setter.req-user-acceptance.userToAcceptLogin.name").description("setter.req-user-acceptance.userToAcceptLogin.desc").type((Type)Types.VARIABLE).create();
    }

    public void set(@Param String brand, @Param String salesChannel, @Param String userToCompare, @Param Variable foundAcceptanceData, @Param Variable userToAcceptLogin, AcceptanceContext acceptanceContext) {
        String activityId = acceptanceContext.getActivityId();
        String processId = acceptanceContext.getProcessId();
        log.debug((Object)("Kana\u0142 sprzeda\u017cy: " + salesChannel + ", Marka: " + brand));
        List<ReqAcceptance> foundAcceptance = this.reqAcceptanceService.findAcceptanceUser(brand, salesChannel);
        if (foundAcceptance != null) {
            log.debug((Object)("foundAcceptance: " + foundAcceptance));
            HashSet<String> users = new HashSet<String>();
            boolean anyUser = this.isAnyUser(foundAcceptance);
            if (anyUser) {
                users.add(userToCompare);
            } else {
                for (ReqAcceptance reqAcceptance : foundAcceptance) {
                    String userLogin = StringUtils.trim((String)reqAcceptance.getAcceptUserLogin());
                    User user = this.userService.getUser(userLogin, new String[0]);
                    if (user != null) {
                        users.add(user.getUserName());
                        continue;
                    }
                    this.addComment(processId, activityId, "Nieprawid\u0142owy u\u017cytkownik wprowadzony w tabeli pm_cust_wc_req_acceptance o loginie: " + userLogin + ". Skontaktuj si\u0119 z administratorem.");
                    throw new IllegalArgumentException("Nieprawid\u0142owy u\u017cytkownik wprowadzony w tabeli pm_cust_wc_req_acceptance o loginie: " + userLogin);
                }
            }
            if (users.contains(userToCompare)) {
                userToAcceptLogin.setValue((Object)"");
            } else {
                userToAcceptLogin.setValue((Object)StringUtils.join(users, (String)";"));
            }
            foundAcceptanceData.setValue((Object)Boolean.TRUE);
        } else {
            foundAcceptanceData.setValue((Object)Boolean.FALSE);
        }
    }

    private boolean isAnyUser(List<ReqAcceptance> foundAcceptance) {
        for (ReqAcceptance reqAcceptance : foundAcceptance) {
            String userLogin = StringUtils.trim((String)reqAcceptance.getAcceptUserLogin());
            if (!StringUtils.equals((CharSequence)userLogin, (CharSequence)"<ANY>")) continue;
            return true;
        }
        return false;
    }

    private void addComment(String processId, String activityId, String msg) {
        Comment comment = new Comment();
        comment.setProcessId(processId);
        comment.setActivityId(activityId);
        comment.setUserId("admin");
        comment.setComment(msg);
        comment.setTimestamp(Long.valueOf(DateTime.now().getMillis()));
        this.commentService.createComment(comment);
    }
}

