/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.setters;

import com.suncode.client.common.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.assignment.AssignmentService;
import com.suncode.pwfl.workflow.form.variablesetter.VariableSetterDefinitionBuilder;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

@VariableSetter
public class CancelParallelTasks {
    public static Logger log = Logger.getLogger(CancelParallelTasks.class);
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private AssignmentService assignmentService;

    @Define
    public void definition(VariableSetterDefinitionBuilder builder) {
        ((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)builder.id("cancel-parallel-tasks-setter")).name("setter.cancel-parallel-tasks.name")).description("setter.cancel-parallel-tasks.desc")).category(new Category[]{Categories.WC})).icon((Icon)SilkIconPack.CANCEL)).parameter().id("taskDefIdsToCancel").name("setter.cancel-parallel-tasks.taskDefIdsToCancel.name").description("setter.cancel-parallel-tasks.taskDefIdsToCancel.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("actionCancelName").defaultValue((Object)"anuluj").name("setter.cancel-parallel-tasks.actionCancelName.name").description("setter.cancel-parallel-tasks.actionCancelName.desc").type((Type)Types.STRING).create();
    }

    public void set(@Param String[] taskDefIdsToCancel, @Param String actionCancelName, AcceptanceContext acceptanceContext) {
        String processId = acceptanceContext.getProcessId();
        HashSet<Activity> activitiesToCancel = new HashSet<Activity>();
        Set activityDefIdsSet = Arrays.stream(taskDefIdsToCancel).collect(Collectors.toSet());
        log.debug((Object)("activityDefIdsSet: " + activityDefIdsSet));
        for (String activityDefId : activityDefIdsSet) {
            activitiesToCancel.addAll(this.findOpenActivityByActivityDefId(processId, activityDefId));
        }
        this.cancelActivities(activitiesToCancel, actionCancelName, "admin");
    }

    public void cancelActivities(Set<Activity> activitiesToCancel, String actionName, String userName) {
        for (Activity activity : activitiesToCancel) {
            AcceptationDefinition ad = new AcceptationDefinition(activity.getProcessId(), activity.getActivityId(), userName, actionName);
            ad.setIgnoreOwnerShip(Boolean.valueOf(true));
            try {
                this.assignmentService.assignActivityToUser(activity.getProcessId(), activity.getActivityId(), userName);
                this.activityService.acceptActivity(ad);
            }
            catch (Exception ex) {
                log.error((Object)("Zadanie nie zosta\u0142o anulowane dla procesu : " + activity.getProcessId()));
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public List<Activity> findOpenActivityByActivityDefId(String processId, String sActivityDefId) {
        DetachedCriteria dc = DetachedCriteria.forClass(Activity.class);
        dc.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"activityDefinitionId", (Object)sActivityDefId), (Criterion)Restrictions.eq((String)"processId", (Object)processId)));
        List activityList = this.activityFinder.findByCriteria(dc);
        activityList.forEach(activity -> log.debug((Object)("activityList: " + activity.getActivityId())));
        ArrayList<Activity> result = new ArrayList<Activity>();
        for (Activity activity2 : activityList) {
            if (!activity2.isOpen()) continue;
            result.add(activity2);
        }
        return result;
    }
}

