/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.scheduledTasks;

import com.suncode.client.common.Categories;
import com.suncode.client.scheduledTasks.XMLSubstitutionData;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.administration.scheduledtask.context.ProgressHolder;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.administration.substitution.Substitution;
import com.suncode.pwfl.administration.substitution.SubstitutionFinder;
import com.suncode.pwfl.administration.substitution.SubstitutionService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ScheduledTask
public class XMLSubstitutionsManager {
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private SubstitutionService substitutionService;
    @Autowired
    private SubstitutionFinder substitutionFinder;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ProcessService processService;
    DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private Logger log = Logger.getLogger(XMLSubstitutionsManager.class);

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("xml-substitutions-manager-scheduled-task")).name("scheduled-task.xml-substitutions-manager.name")).description("scheduled-task.xml-substitutions-manager.desc")).category(new Category[]{Categories.XML})).cancelable().parameter().id("xmlFilesPath").name("scheduled-task.xml-substitutions-manager.xmlFilesPath.name").description("scheduled-task.xml-substitutions-manager.xmlFilesPath.desc").type((Type)Types.STRING).create()).parameter().id("processedXmlFilesPath").name("scheduled-task.xml-substitutions-manager.processedXmlFilesPath.name").description("scheduled-task.xml-substitutions-manager.processedXmlFilesPath.desc").type((Type)Types.STRING).create()).parameter().id("invoiceProcessId").name("scheduled-task.xml-substitutions-manager.processInvoiceId.name").description("scheduled-task.xml-substitutions-manager.processInvoiceId.desc").type((Type)Types.STRING).create()).parameter().id("invoiceRoleId").name("scheduled-task.xml-substitutions-manager.invoiceRoleId.name").description("scheduled-task.xml-substitutions-manager.invoiceRoleId.desc").type((Type)Types.STRING).create();
    }

    public void execute(@Param String xmlFilesPath, @Param String processedXmlFilesPath, @Param String invoiceProcessId, @Param String invoiceRoleId, CancelationHandler cancelationHandler, Logger logger, ProgressHolder progressHolder) throws Exception {
        int filesProcessed = 0;
        int allFiles = 0;
        try {
            String invoiceProcessPackageId = this.getPackageId(invoiceProcessId);
            Role invoiceProcessRole = this.getRole(invoiceProcessPackageId, invoiceProcessId, invoiceRoleId);
            File xmlFilesDir = FileUtils.getFile((String[])new String[]{xmlFilesPath});
            List filesList = new ArrayList();
            if (!xmlFilesDir.exists() || !xmlFilesDir.isDirectory()) {
                throw new IOException("Nieprawid\u0142owa \u015bcie\u017cka do katalog\u00f3w z plikami xml!");
            }
            String[] extensions = new String[]{"xml"};
            filesList = (List)FileUtils.listFiles((File)xmlFilesDir, (String[])extensions, (boolean)false);
            File processedXmlFilesDir = FileUtils.getFile((String[])new String[]{processedXmlFilesPath});
            if (!(processedXmlFilesDir.exists() && processedXmlFilesDir.isDirectory() || !processedXmlFilesDir.mkdir())) {
                logger.debug((Object)"Katalog dla przetworzonych plik\u00f3w XML zosta\u0142 utworzony.");
                this.log.debug((Object)"Katalog dla przetworzonych plik\u00f3w XML zosta\u0142 utworzony.");
            }
            int filesSize = filesList.size();
            progressHolder.setProgress(Double.valueOf(0.0));
            for (File xmlFile : filesList) {
                if (!cancelationHandler.isCanceled().booleanValue() && xmlFile.isFile() && xmlFile.canRead()) {
                    List<XMLSubstitutionData> xmlSubstitutionDataList = this.getXMLSubstitutionData(xmlFile, logger);
                    for (XMLSubstitutionData xmlSubstitutionData : xmlSubstitutionDataList) {
                        try {
                            if (!xmlSubstitutionData.allDataIncluded()) continue;
                            String substitutedNmb = xmlSubstitutionData.getXml_Zastepowany();
                            User substituted = this.findUserByNmb(substitutedNmb, logger);
                            String substituteNmb = xmlSubstitutionData.getXml_Zastepujacy();
                            User substitute = this.findUserByNmb(substituteNmb, logger);
                            String substitutedInvProcRoleAkcNmb = xmlSubstitutionData.getXml_Zastepujacy_o_roli_Akceptujacy_w_procesie_faktur();
                            User substitutedInvProcRoleAkc = this.findUserByNmb(substitutedInvProcRoleAkcNmb, logger);
                            if (substituted == null) {
                                throw new IllegalArgumentException("Nie znaleziono zast\u0119powanego w systemie PlusWorkflow dla nr: " + substitutedNmb);
                            }
                            if (substitute == null) {
                                throw new IllegalArgumentException("Nie znaleziono zastepujacego w systemie PlusWorkflow dla nr: " + substituteNmb);
                            }
                            if (substitutedInvProcRoleAkc == null) {
                                throw new IllegalArgumentException("Nie znaleziono zast\u0119powanego dla procesu faktur o roli Akceptuj\u0105cy w systemie PlusWorkflow dla nr: " + substitutedInvProcRoleAkc);
                            }
                            Substitution substitutionAllProcesses = new Substitution();
                            substitutionAllProcesses.setFinishDate(xmlSubstitutionData.getXml_Do());
                            substitutionAllProcesses.setStartDate(xmlSubstitutionData.getXml_Od());
                            substitutionAllProcesses.setSubstitute(substitute);
                            substitutionAllProcesses.setSubstituted(substituted);
                            Substitution substitutionInvoiceProcessWithRoleAkceptujacy = new Substitution();
                            substitutionInvoiceProcessWithRoleAkceptujacy.setFinishDate(xmlSubstitutionData.getXml_Do());
                            substitutionInvoiceProcessWithRoleAkceptujacy.setStartDate(xmlSubstitutionData.getXml_Od());
                            substitutionInvoiceProcessWithRoleAkceptujacy.setSubstitute(substitutedInvProcRoleAkc);
                            substitutionInvoiceProcessWithRoleAkceptujacy.setSubstituted(substituted);
                            substitutionInvoiceProcessWithRoleAkceptujacy.setProcessDefId(invoiceProcessId);
                            substitutionInvoiceProcessWithRoleAkceptujacy.setRole(invoiceProcessRole);
                            if (xmlSubstitutionData.isXml_Aktualne()) {
                                this.substitutionService.createSubstitution(substitutionAllProcesses);
                                logger.info((Object)("Dodano zast\u0119pstwo do systemu PlusWorkflow: Zast\u0119powany " + substitutionAllProcesses.getSubstituted().getFullName().toUpperCase() + ", Zast\u0119puj\u0105cy " + substitutionAllProcesses.getSubstitute().getFullName().toUpperCase() + ", Od " + this.formatter.print((ReadablePartial)substitutionAllProcesses.getStartDate()) + ", Do " + this.formatter.print((ReadablePartial)substitutionAllProcesses.getFinishDate())));
                                if (!StringUtils.equals((String)substitutedNmb, (String)substitutedInvProcRoleAkcNmb)) {
                                    this.substitutionService.createSubstitution(substitutionInvoiceProcessWithRoleAkceptujacy);
                                    logger.info((Object)("Dodano zast\u0119pstwo do systemu PlusWorkflow: Zast\u0119powany " + substitutionInvoiceProcessWithRoleAkceptujacy.getSubstituted().getFullName().toUpperCase() + ", Zast\u0119puj\u0105cy w procesie faktur o roli Akceptuj\u0105cy " + substitutionInvoiceProcessWithRoleAkceptujacy.getSubstitute().getFullName().toUpperCase() + ", Od " + this.formatter.print((ReadablePartial)substitutionInvoiceProcessWithRoleAkceptujacy.getStartDate()) + ", Do " + this.formatter.print((ReadablePartial)substitutionInvoiceProcessWithRoleAkceptujacy.getFinishDate())));
                                } else {
                                    logger.info((Object)"Pomini\u0119to dodanie tego samego zastepstwa ograniczonego do procesu i roli");
                                }
                            } else {
                                List allSubstitutions = this.substitutionFinder.getAll(new String[]{"substitute", "substituted"});
                                Set<Long> substitutionsIds = this.getSubstitutionsIdsIfExists(allSubstitutions, substitutionAllProcesses);
                                if (!substitutionsIds.isEmpty()) {
                                    for (Long substitutionId : substitutionsIds) {
                                        this.substitutionService.deleteSubstitution(substitutionId);
                                        logger.info((Object)("Usuni\u0119to zast\u0119pstwo z systemu PlusWorkflow: Zast\u0119powany " + substitutionAllProcesses.getSubstituted().getFullName().toUpperCase() + ", Zast\u0119puj\u0105cy " + substitutionAllProcesses.getSubstitute().getFullName().toUpperCase() + ", Od " + this.formatter.print((ReadablePartial)substitutionAllProcesses.getStartDate()) + ", Do " + this.formatter.print((ReadablePartial)substitutionAllProcesses.getFinishDate())));
                                    }
                                } else {
                                    logger.info((Object)("Nie mo\u017cna by\u0142o usun\u0105\u0107 informacji o zast\u0119pstwie gdy\u017c nie zosta\u0142a znaleziona w systemie: Zast\u0119powany " + substitutionAllProcesses.getSubstituted().getFullName().toUpperCase() + ", Zast\u0119puj\u0105cy " + substitutionAllProcesses.getSubstitute().getFullName().toUpperCase() + ", Od " + this.formatter.print((ReadablePartial)substitutionAllProcesses.getStartDate()) + ", Do " + this.formatter.print((ReadablePartial)substitutionAllProcesses.getFinishDate())));
                                }
                                if (!StringUtils.equals((String)substituteNmb, (String)substitutedInvProcRoleAkcNmb)) {
                                    Set<Long> substitutionsInvProcAkcToleIds = this.getSubstitutionsIdsIfExists(allSubstitutions, substitutionInvoiceProcessWithRoleAkceptujacy);
                                    if (!substitutionsInvProcAkcToleIds.isEmpty()) {
                                        for (Long substitutionInvProcAkcToleId : substitutionsInvProcAkcToleIds) {
                                            this.substitutionService.deleteSubstitution(substitutionInvProcAkcToleId);
                                            logger.info((Object)("Usuni\u0119to zast\u0119pstwo z systemu PlusWorkflow: Zast\u0119powany " + substitutionInvoiceProcessWithRoleAkceptujacy.getSubstituted().getFullName().toUpperCase() + ", Zast\u0119puj\u0105cy w procesie faktur o roli Akceptuj\u0105cy " + substitutionInvoiceProcessWithRoleAkceptujacy.getSubstitute().getFullName().toUpperCase() + ", Od " + this.formatter.print((ReadablePartial)substitutionInvoiceProcessWithRoleAkceptujacy.getStartDate()) + ", Do " + this.formatter.print((ReadablePartial)substitutionInvoiceProcessWithRoleAkceptujacy.getFinishDate())));
                                        }
                                    } else {
                                        logger.info((Object)("Nie mo\u017cna by\u0142o usun\u0105\u0107 informacji o zast\u0119pstwie gdy\u017c nie zosta\u0142a znaleziona w systemie: Zast\u0119powany " + substitutionInvoiceProcessWithRoleAkceptujacy.getSubstituted().getFullName().toUpperCase() + ", Zast\u0119puj\u0105cy w procesie faktur o roli Akceptuj\u0105cy " + substitutionInvoiceProcessWithRoleAkceptujacy.getSubstitute().getFullName().toUpperCase() + ", Od " + this.formatter.print((ReadablePartial)substitutionInvoiceProcessWithRoleAkceptujacy.getStartDate()) + ", Do " + this.formatter.print((ReadablePartial)substitutionInvoiceProcessWithRoleAkceptujacy.getFinishDate())));
                                    }
                                }
                            }
                            logger.info((Object)("Przenoszenie pliku do: " + processedXmlFilesDir.getAbsolutePath()));
                            FileUtils.copyFileToDirectory((File)xmlFile, (File)processedXmlFilesDir);
                            FileUtils.deleteQuietly((File)xmlFile);
                            progressHolder.setProgress(Double.valueOf((double)(++filesProcessed) / (double)filesSize));
                        }
                        catch (Exception e) {
                            logger.info((Object)("ERROR: " + e.getMessage()));
                            this.log.debug((Object)e.getMessage(), (Throwable)e);
                            logger.info((Object)("Nieudane przetwarzanie pliku: " + xmlFile.getName()));
                        }
                    }
                }
                ++allFiles;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            logger.info((Object)"Przetwarzanie nie powiod\u0142o si\u0119.");
        }
        logger.info((Object)("Ilo\u015b\u0107 wszystkich plik\u00f3w do przetworzenia: " + allFiles));
        logger.info((Object)("Ilosc przetworzonych plik\u00f3w: " + filesProcessed));
    }

    private Set<Long> getSubstitutionsIdsIfExists(List<Substitution> allSubstitutions, Substitution substitiutionToCheck) {
        HashSet<Long> foundIds = new HashSet<Long>();
        String substitutedToCheck = substitiutionToCheck.getSubstituted().getUserName();
        this.log.debug((Object)("substitutedToCheck: " + substitutedToCheck));
        String substituteToCheck = substitiutionToCheck.getSubstitute().getUserName();
        this.log.debug((Object)("substituteToCheck: " + substituteToCheck));
        String startDateToCheck = this.formatter.print((ReadablePartial)substitiutionToCheck.getStartDate());
        this.log.debug((Object)("startDateToCheck: " + startDateToCheck));
        String finishDateToCheck = this.formatter.print((ReadablePartial)substitiutionToCheck.getFinishDate());
        this.log.debug((Object)("finishDateToCheck: " + finishDateToCheck));
        for (Substitution substitution : allSubstitutions) {
            try {
                String substituted = substitution.getSubstituted().getUserName();
                String substitute = substitution.getSubstitute().getUserName();
                LocalDateTime sStartDate = substitution.getStartDate();
                LocalDateTime sFinishDate = substitution.getFinishDate();
                if (sStartDate == null || sFinishDate == null) continue;
                String startDate = this.formatter.print((ReadablePartial)substitution.getStartDate());
                String finishDate = this.formatter.print((ReadablePartial)substitution.getFinishDate());
                if (!StringUtils.equals((String)substitutedToCheck, (String)substituted) || !StringUtils.equals((String)substituteToCheck, (String)substitute) || !StringUtils.equals((String)startDateToCheck, (String)startDate) || !StringUtils.equals((String)finishDateToCheck, (String)finishDate)) continue;
                foundIds.add(substitution.getId());
                this.log.debug((Object)("substitution.getId(): " + substitution.getId()));
            }
            catch (Exception e) {
                this.log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return foundIds;
    }

    private User findUserByNmb(String substitutedNmb, Logger logger) {
        DetachedCriteria dc = DetachedCriteria.forClass(User.class);
        dc.add((Criterion)Restrictions.and((Criterion[])new Criterion[]{Restrictions.eq((String)"number", (Object)substitutedNmb)}));
        List users = this.userFinder.findByCriteria(dc);
        if (users != null) {
            logger.info((Object)("Znalezionych u\u017cytkownik\u00f3w dla numeru " + substitutedNmb + " : " + users.size()));
            if (users.size() == 1) {
                return (User)users.get(0);
            }
        } else {
            logger.info((Object)("Nie znaleziono u\u017cytkownika dla numeru " + substitutedNmb));
        }
        return null;
    }

    private List<XMLSubstitutionData> getXMLSubstitutionData(File xmlFile, Logger logger) {
        ArrayList<XMLSubstitutionData> xmlSubstitutionDataList = new ArrayList<XMLSubstitutionData>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBulider = dbFactory.newDocumentBuilder();
            Document document = dBulider.parse(xmlFile);
            document.getDocumentElement().normalize();
            NodeList documentNL = document.getElementsByTagName("Zastepstwo");
            for (int i = 0; i < documentNL.getLength(); ++i) {
                NodeList isActiveND;
                NodeList dateToND;
                NodeList dateFromND;
                NodeList substituteAkcRoleProcFakND;
                NodeList substituteND;
                XMLSubstitutionData xmlSubstitutionData = new XMLSubstitutionData();
                Element documentE = (Element)documentNL.item(i);
                NodeList substitutedND = documentE.getElementsByTagName("Zastepowany");
                if (substitutedND.getLength() > 0) {
                    Element substitutedE = (Element)substitutedND.item(0);
                    String substituted = this.getCharacterDataFromElement(substitutedE);
                    xmlSubstitutionData.setXml_Zastepowany(substituted);
                }
                if ((substituteND = documentE.getElementsByTagName("Zastepujacy")).getLength() > 0) {
                    Element substituteE = (Element)substituteND.item(0);
                    String substitute = this.getCharacterDataFromElement(substituteE);
                    xmlSubstitutionData.setXml_Zastepujacy(substitute);
                }
                if ((substituteAkcRoleProcFakND = documentE.getElementsByTagName("ZastepujacyAkceptacjaFaktur")).getLength() > 0) {
                    Element substituteAkcRoleProcFakE = (Element)substituteAkcRoleProcFakND.item(0);
                    String subtituteAkcRoleProcFak = this.getCharacterDataFromElement(substituteAkcRoleProcFakE);
                    xmlSubstitutionData.setXml_Zastepujacy_o_roli_Akceptujacy_w_procesie_faktur(subtituteAkcRoleProcFak);
                }
                if ((dateFromND = documentE.getElementsByTagName("Od")).getLength() > 0) {
                    Element dateFromE = (Element)dateFromND.item(0);
                    String dateFrom = this.getCharacterDataFromElement(dateFromE);
                    try {
                        LocalDateTime localDate = LocalDateTime.parse((String)dateFrom);
                        xmlSubstitutionData.setXml_Od(localDate);
                    }
                    catch (Exception e) {
                        logger.info((Object)("Wystapi\u0142 problem z parsowaniem daty " + dateFrom));
                    }
                }
                if ((dateToND = documentE.getElementsByTagName("Do")).getLength() > 0) {
                    Element dateToE = (Element)dateToND.item(0);
                    String dateTo = this.getCharacterDataFromElement(dateToE);
                    try {
                        LocalDateTime localDate = LocalDateTime.parse((String)dateTo);
                        xmlSubstitutionData.setXml_Do(localDate);
                    }
                    catch (Exception e) {
                        logger.info((Object)("Wystapi\u0142 problem z parsowaniem daty " + dateTo));
                    }
                }
                if ((isActiveND = documentE.getElementsByTagName("Aktualne")).getLength() > 0) {
                    Element isActiveE = (Element)isActiveND.item(0);
                    String isActive = this.getCharacterDataFromElement(isActiveE);
                    try {
                        Boolean bool = Boolean.parseBoolean(isActive);
                        xmlSubstitutionData.setXml_Aktualne(bool);
                    }
                    catch (Exception e) {
                        logger.info((Object)("Wystapi\u0142 problem z parsowaniem warto\u015bci logicznej " + isActive));
                    }
                }
                xmlSubstitutionDataList.add(xmlSubstitutionData);
            }
        }
        catch (Exception e) {
            logger.info((Object)("Wyst\u0105pi\u0142 problem podczas odczytu pliku XML o nazwie " + xmlFile.getName()));
            logger.info((Object)e.getMessage());
        }
        return xmlSubstitutionDataList;
    }

    private String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "";
    }

    private String getPackageId(String processDefId) {
        ProcessDefinition processDefinition = this.processService.getProcessDefinition(processDefId);
        String packageId = processDefinition.getPackageId();
        if (packageId == null) {
            throw new IllegalArgumentException("Nie znaleziono pakietu dla procesu o id " + processDefId);
        }
        return packageId;
    }

    private Role getRole(String packageId, String processDefId, String roleId) {
        Role role = this.roleService.getRole(packageId, processDefId, roleId);
        if (role == null) {
            throw new IllegalArgumentException("Nie znaleziono roli o id " + roleId + " w procesie o id " + processDefId);
        }
        return role;
    }
}

