/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.scheduledTasks;

import com.suncode.client.common.Categories;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.administration.scheduledtask.context.ProgressHolder;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@ScheduledTask
public class SendXMLToSaldeo {
    private static Logger log = LoggerFactory.getLogger(SendXMLToSaldeo.class);
    private static final String SIGNATURE = "req_sig";
    private static final String ID = "req_id";
    private static final String USER = "username";
    private static final String FILE = "command";
    private static final String COMPANY_PROGRAM_ID_PARAM_NAME = "company_program_id";

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("send-xml-to-saldeo-scheduled-task")).name("scheduled-task.send-xml-to-saldeo.name")).description("scheduled-task.send-xml-to-saldeo.desc")).category(new Category[]{Categories.XML})).cancelable().parameter().id("xmlFilesPath").name("scheduled-task.send-xml-to-saldeo.xmlFilesPath.name").description("scheduled-task.send-xml-to-saldeo.xmlFilesPath.desc").type((Type)Types.STRING).create()).parameter().id("processedXmlFilesPath").name("scheduled-task.send-xml-to-saldeo.processedXmlFilesPath.name").description("scheduled-task.send-xml-to-saldeo.processedXmlFilesPath.desc").type((Type)Types.STRING).create()).parameter().id("serviceUrl").name("scheduled-task.send-xml-to-saldeo.serviceUrl.name").description("scheduled-task.send-xml-to-saldeo.serviceUrl.desc").type((Type)Types.STRING).create()).parameter().id("commandUrl").name("scheduled-task.send-xml-to-saldeo.commandUrl.name").description("scheduled-task.send-xml-to-saldeo.commandUrl.desc").type((Type)Types.STRING).create()).parameter().id(USER).name("scheduled-task.send-xml-to-saldeo.username.name").description("scheduled-task.send-xml-to-saldeo.username.desc").type((Type)Types.STRING).create()).parameter().id("token").name("scheduled-task.send-xml-to-saldeo.token.name").description("scheduled-task.send-xml-to-saldeo.token.desc").type((Type)Types.STRING).create()).parameter().id("companyProgramId").name("scheduled-task.send-xml-to-saldeo.companyProgramId.name").description("scheduled-task.send-xml-to-saldeo.companyProgramId.desc").type((Type)Types.STRING).create();
    }

    public void execute(@Param String xmlFilesPath, @Param String processedXmlFilesPath, @Param String serviceUrl, @Param String commandUrl, @Param String username, @Param String token, @Param String companyProgramId, CancelationHandler cancelationHandler, org.apache.log4j.Logger logger, ProgressHolder progressHolder) throws Exception {
        int filesProcessed = 0;
        int allFiles = 0;
        try {
            File xmlFilesDir = FileUtils.getFile((String[])new String[]{xmlFilesPath});
            List filesList = new ArrayList();
            if (!xmlFilesDir.exists() || !xmlFilesDir.isDirectory()) {
                throw new IOException("Nieprawid\u0142owa \u015bcie\u017cka do katalog\u00f3w z plikami xml!");
            }
            String[] extensions = new String[]{"xml"};
            filesList = (List)FileUtils.listFiles((File)xmlFilesDir, (String[])extensions, (boolean)false);
            File processedXmlFilesDir = FileUtils.getFile((String[])new String[]{processedXmlFilesPath});
            if (!(processedXmlFilesDir.exists() && processedXmlFilesDir.isDirectory() || !processedXmlFilesDir.mkdir())) {
                logger.debug((Object)"Katalog dla przetworzonych plik\u00f3w XML zosta\u0142 utworzony.");
                log.debug("Katalog dla przetworzonych plik\u00f3w XML zosta\u0142 utworzony.");
            }
            int filesSize = filesList.size();
            progressHolder.setProgress(Double.valueOf(0.0));
            String apiUrl = serviceUrl + commandUrl;
            for (File xmlFile : filesList) {
                if (!cancelationHandler.isCanceled().booleanValue() && xmlFile.isFile() && xmlFile.canRead()) {
                    try {
                        String fileContent = FileUtils.readFileToString((File)xmlFile, (String)"UTF-8");
                        log.debug("SALDEO XML:" + SendXMLToSaldeo.xmlFormatter(fileContent));
                        ByteArrayOutputStream rstBao = new ByteArrayOutputStream();
                        GZIPOutputStream zos = new GZIPOutputStream(rstBao);
                        zos.write(fileContent.getBytes());
                        IOUtils.closeQuietly((OutputStream)zos);
                        String base64FileContent = Base64.getEncoder().encodeToString(rstBao.toByteArray());
                        if (this.sendXMLToSALDEO(username, token, apiUrl, companyProgramId, base64FileContent, logger)) {
                            logger.info((Object)("Przenoszenie pliku do: " + processedXmlFilesDir.getAbsolutePath()));
                            FileUtils.copyFileToDirectory((File)xmlFile, (File)processedXmlFilesDir);
                            FileUtils.deleteQuietly((File)xmlFile);
                            progressHolder.setProgress(Double.valueOf((double)(++filesProcessed) / (double)filesSize));
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        log.debug(e.getMessage(), (Throwable)e);
                        logger.info((Object)"Wystapi\u0142 problem pdoczas przesy\u0142ania pliku XML do SALDEO.");
                    }
                }
                ++allFiles;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            log.debug(e.getMessage(), (Throwable)e);
            logger.info((Object)"Przetwarzanie nie powiod\u0142o si\u0119.");
        }
        logger.info((Object)("Ilo\u015b\u0107 plik\u00f3w, kt\u00f3re powinny zosta\u0107 przetworzone: " + allFiles));
        logger.info((Object)("Ilo\u015b\u0107 przetworzonych plik\u00f3w: " + filesProcessed));
    }

    private boolean sendXMLToSALDEO(String username, String token, String serviceUrl, String companyProgramId, String fileContent, org.apache.log4j.Logger logger) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(COMPANY_PROGRAM_ID_PARAM_NAME, companyProgramId);
        params.put(FILE, fileContent);
        String response = this.postXML(serviceUrl, username, token, params);
        log.debug("SALDEO RESPONSE XML:" + SendXMLToSaldeo.xmlFormatter(response));
        if (!StringUtils.isBlank((String)response)) {
            org.w3c.dom.Document document = this.getDocument(response);
            NodeList nodes = document.getElementsByTagName("RESPONSE");
            Element responseE = (Element)nodes.item(0);
            NodeList statusNL = responseE.getElementsByTagName("STATUS");
            Element statusE = (Element)statusNL.item(0);
            String status = this.getCharacterDataFromElement(statusE);
            if (StringUtils.equals((String)status, (String)"OK")) {
                return true;
            }
            if (StringUtils.equals((String)status, (String)"ERROR")) {
                log.debug("ERROR");
                this.generateErrorMessage(responseE, logger);
                throw new IllegalArgumentException("Wyst\u0105pi\u0142 problem podczas wysy\u0142ania pliku XML do SALDEO");
            }
        }
        return false;
    }

    private String postXML(String serviceUrl, String username, String token, Map<String, String> params) throws URISyntaxException, ClientProtocolException, IOException {
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        URIBuilder uriBuiler = null;
        try {
            uriBuiler = new URIBuilder(serviceUrl);
        }
        catch (Exception e) {
            return null;
        }
        String id = this.getReqId();
        params.put(USER, username);
        params.put(ID, id);
        ArrayList<String> paramNames = new ArrayList<String>(params.keySet());
        Collections.sort(paramNames);
        StringBuilder sb = new StringBuilder();
        for (String paramName : paramNames) {
            sb.append(paramName).append("=");
            String paramVal = params.get(paramName);
            sb.append(paramVal);
        }
        String signatureBase = sb.toString();
        log.debug("signatureBase=" + signatureBase);
        signatureBase = URLEncoder.encode(signatureBase, "UTF-8");
        log.debug("signatureBaseEncoded=" + signatureBase);
        String calculatedSignature = DigestUtils.md5Hex((String)(signatureBase + token));
        log.debug("calculatedSignature=" + calculatedSignature);
        params.put(SIGNATURE, calculatedSignature);
        paramNames = new ArrayList<String>(params.keySet());
        for (String paramName : paramNames) {
            postParameters.add(new BasicNameValuePair(paramName, params.get(paramName)));
        }
        HttpPost post = new HttpPost();
        post.setURI(uriBuiler.build());
        log.debug("URI=" + post.getURI());
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters));
        CloseableHttpClient client = HttpClients.createDefault();
        return (String)client.execute((HttpUriRequest)post, (ResponseHandler)new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            }
        });
    }

    private String getReqId() {
        Random rand = new Random();
        long requestId = System.currentTimeMillis() / 1000L;
        return String.valueOf(requestId += rand.nextLong());
    }

    private org.w3c.dom.Document getDocument(String xml) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        return builder.parse(is);
    }

    private void generateErrorMessage(Element responseE, org.apache.log4j.Logger logger) {
        NodeList errorCodeNL = responseE.getElementsByTagName("ERROR_CODE");
        Element errorCodeE = (Element)errorCodeNL.item(0);
        String errorCode = this.getCharacterDataFromElement(errorCodeE);
        logger.debug((Object)("Error Code: " + errorCode));
        NodeList errorMessageNL = responseE.getElementsByTagName("ERROR_MESSAGE");
        Element errorMessageE = (Element)errorMessageNL.item(0);
        String errorMessage = this.getCharacterDataFromElement(errorMessageE);
        logger.debug((Object)("Error Message: " + errorMessage));
    }

    public String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "";
    }

    public static String xmlFormatter(String xml) {
        StringWriter sw;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            Document document = DocumentHelper.parseText((String)xml);
            sw = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            writer.write(document);
        }
        catch (Exception e) {
            return xml;
        }
        return sw.toString();
    }
}

