/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.actions.components;

import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.search.CountedResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/component"})
public class GroupListController {
    public static Logger log = LoggerFactory.getLogger(GroupListController.class);
    @Autowired
    private UserGroupFinder userGroupFinder;

    @RequestMapping(value={"groupList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getGroupList(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        ArrayList<Map> userGroupInfoList = new ArrayList<Map>();
        ArrayList userGroupInfoTempList = new ArrayList();
        List groups = this.userGroupFinder.getAll(new String[0]);
        if (groups != null) {
            for (UserGroup userGroup : groups) {
                HashMap<String, String> userGroupMap = new HashMap<String, String>();
                userGroupMap.put("groupName", userGroup.getName());
                log.debug("groupName: {}", (Object)userGroup.getName());
                userGroupInfoTempList.add(userGroupMap);
            }
        }
        if (StringUtils.isBlank((String)query)) {
            userGroupInfoList = userGroupInfoTempList;
        } else {
            for (Map map : userGroupInfoTempList) {
                if (!((String)map.get("groupName")).toLowerCase().contains(query.toLowerCase())) continue;
                userGroupInfoList.add(map);
            }
        }
        int totalResult = userGroupInfoList.size();
        Long l = Long.valueOf(start);
        Long limitL = Long.valueOf(limit);
        if (totalResult > limitL.intValue()) {
            result.setData(userGroupInfoList.subList(l.intValue(), l.intValue() + limitL.intValue() - 1));
        } else {
            result.setData(userGroupInfoList);
        }
        result.setTotal((long)totalResult);
        return result;
    }
}

