/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.actions.components;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.search.CountedResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/component"})
public class DocumentClassesController {
    public static Logger log = LoggerFactory.getLogger(DocumentClassesController.class);
    @Autowired
    private DocumentClassService docClassService;

    @RequestMapping(value={"docClassList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentClassList(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        List<DocumentClass> classes = this.getAllDocClasses();
        ArrayList<Map> docClassInfoList = new ArrayList<Map>();
        ArrayList tempList = new ArrayList();
        for (DocumentClass documentClass : classes) {
            HashMap<String, String> docClassInfo = new HashMap<String, String>();
            docClassInfo.put("docClassName", documentClass.getName());
            docClassInfo.put("docClassId", documentClass.getId().toString());
            tempList.add(docClassInfo);
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            docClassInfoList = tempList;
        } else {
            for (Map map : tempList) {
                if (!((String)map.get("docClassName")).toLowerCase().contains(query.toLowerCase())) continue;
                docClassInfoList.add(map);
            }
        }
        int totalResult = docClassInfoList.size();
        Long l = Long.valueOf(start);
        Long limitL = Long.valueOf(limit);
        if (totalResult > limitL.intValue()) {
            result.setData(docClassInfoList.subList(l.intValue(), l.intValue() + limitL.intValue() - 1));
        } else {
            result.setData(docClassInfoList);
        }
        result.setTotal((long)totalResult);
        return result;
    }

    private List<DocumentClass> getAllDocClasses() {
        return this.docClassService.getAll(new String[0]);
    }
}

