/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.actions.components;

import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.workflow.activity.ActivityType;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/component"})
public class ActivityListController {
    public static Logger log = LoggerFactory.getLogger(ActivityListController.class);
    public final String PACK_DEF_ID = "wc";
    public final String PROCESS_DEF_ID = "wniosek_cen";

    @RequestMapping(value={"activityList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getActivityList(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        ArrayList<Map> activityInfoList = new ArrayList<Map>();
        ArrayList activityInfoTempList = new ArrayList();
        ProcessService processService = ServiceFactory.getProcessService();
        List activityTypes = processService.getActivityTypes("wniosek_cen");
        for (ActivityType activityType : activityTypes) {
            HashMap<String, String> activityInfo = new HashMap<String, String>();
            activityInfo.put("activityId", activityType.getActivityDefId());
            log.debug("activity.getId()=" + activityType.getActivityDefId());
            activityInfo.put("activityName", activityType.getName());
            log.debug("activity.getName()=" + activityType.getName());
            activityInfoTempList.add(activityInfo);
        }
        if (StringUtils.isBlank((String)query)) {
            activityInfoList = activityInfoTempList;
        } else {
            for (Map map : activityInfoTempList) {
                if (!((String)map.get("activityId")).toLowerCase().contains(query.toLowerCase())) continue;
                activityInfoList.add(map);
            }
        }
        int totalResult = activityInfoList.size();
        Long l = Long.valueOf(start);
        Long limitL = Long.valueOf(limit);
        if (totalResult > limitL.intValue()) {
            result.setData(activityInfoList.subList(l.intValue(), l.intValue() + limitL.intValue() - 1));
        } else {
            result.setData(activityInfoList);
        }
        result.setTotal((long)totalResult);
        return result;
    }
}

