/**
 * PWE form of FillInSummaryTable.
 */
PWE.integrationComponent.registerFormAction('fill-in-summary-table-action', {
	apiVersion: 2,
	buildForm: function(form, options) {
		form.addField({
			id: "summaringTableId",
		});
		form.addField({
			id: "updatingColumns",
		});
		form.addField({
            id: 'updatingVariables'
        });
		form.addField({
			id: "summaringWithPZ",
			listeners: {
				change: function(value) {
					if (value) {
						form.addField({
							id: "pzTableId",
						});
						form.setNotEmpty("pzTableId", true);
					}
					else {
						form.setNotEmpty("pzTableId", false);
						form.removeField("pzTableId");
					}
				}
			}
		});

		if (form.getValue("summaringWithPZ") == true) {
			form.addField({
				id: "pzTableId",
			});
			form.setNotEmpty("pzTableId", true);
		}
		else {
			form.setNotEmpty("pzTableId", false);
			form.removeField("pzTableId");
		}
	}
});
