var Action = {
        t: PW.I18N.createT('com.suncode.client-dobrowolscy.invoices')
};
/**
* Action that fill in summary vat table
 */
PW.FormActions.create('fill-in-summary-table-action', {
	
    variableSetInit : function (decreeTable){
    	this.decreeTable = VariableSetService.get(decreeTable.getId());
    	this.summaringTable = VariableSetService.get(this.get("summaringTableId"));
    	this.summaringWithPZ = this.get("summaringWithPZ");
    	this.pzTable = VariableSetService.get(this.get("pzTableId"));
    },
    defaultActions: {
        variableSet: function(variableSet, added, updated, removed){
        	if(added.length > 0)
        	{
        		this.setSummaringTableRowsValues();
        	}
        	if(updated.length > 0)
        	{
        		for (var j = 0; j < updated.length; j++){
                    if(this.checkUpdate(updated[j])){
                    	 this.setSummaringTableRowsValues();
                    	 VariableSetService.save(this.decreeTable);
                    }
                }
        	}
        	if(removed.length > 0)
        	{
        		this.setSummaringTableRowsValues();
        	}
        }
    },
    enable : function(){
    	var correctParams = true;
    	if(this.summaringTable == undefined){
    		correctParams = false;
    	    Logger.error(Action.t("action.fill-in-summary-table.no-table-id"));
    	    MessageService.showFailure(Action.t("action.fill-in-summary-table.no-table-id"));
    	}
    	else if(this.summaringWithPZ == true && this.pzTable == undefined ){
    		correctParams = false;
    		Logger.error(Action.t("action.fill-in-summary-table.no-pz_table-id"));
    	    MessageService.showFailure(Action.t("action.fill-in-summary-table.no-pz_table-id"));
    	}
    	if(correctParams) this.setSummaringTableRowsValues();
    	
    	var me = this;
    	PW.each(me.get("updatingVariables"), function (variable){
    		variable.on("change", me.setSummaringTableRowsValues, me);
    	});
    },
    disable : function(){
    	var me = this;
    	PW.each(me.get("updatingVariables"), function (variable){
    		variable.off("change", me.setSummaringTableRowsValues, me);
        });
    },
    checkUpdate : function(updated) {
    	var updateCol = this.get("updatingColumns");
        for (var i = 0; i < updateCol.length; i++){
            if(updated.changes.indexOf(updateCol[i].getId()) > -1 ){
                return true;
            }
        }
        return false;
    },
    setSummaringTableRowsValues : function()
    {
    	try 
    	{
        	VariableSetService.clear(this.summaringTable);
        	var decreeTableRowsCount = VariableSetService.getRowsCount(this.decreeTable);
        	
    		var tmpTable = new Array();
    		var tmpTableKeys = new Array();
    		
    		var currencyExchangeRate = VariableService.getValue('kurs_waluty');
    		
    		for (var rowIndex = 0; rowIndex < decreeTableRowsCount; rowIndex++)
        	{
    			var newRow = new Object();
    			
    			var vat = VariableSetService.getValue(this.decreeTable, rowIndex, 'klasa_vat');
    			var vatValue = VariableSetService.getValue(this.decreeTable, rowIndex, 'wartosc_vat_na_linii');
    			var netValue = VariableSetService.getValue(this.decreeTable, rowIndex, 'wartosc_netto_na_linii');
    			
    			if (vat != null && vat != '')
    			{
    				if(tmpTable[vat] == null) 
					{
    					tmpTable[vat] = new Array();
						tmpTable[vat]['vatValue']= new Decimal(vatValue).toDecimalPlaces(2).toNumber();
						tmpTable[vat]['netValue']= new Decimal(netValue).toDecimalPlaces(2).toNumber();
						tmpTableKeys.push(vat);
					}
    				else
					{
						tmpTable[vat]['vatValue'] = tmpTable[vat]['vatValue'] + new Decimal(vatValue).toDecimalPlaces(2).toNumber();
						tmpTable[vat]['netValue'] = tmpTable[vat]['netValue'] + new Decimal(netValue).toDecimalPlaces(2).toNumber();
					}
    			}
        	}
        	
    		if(this.summaringWithPZ == true)
    		{
    			var pzTableRowsCount = VariableSetService.getRowsCount(this.pzTable);
    			
    			for (var rowIndex = 0; rowIndex < pzTableRowsCount; rowIndex++)
        		{
        			var newRow = new Object();
    			
    				var vat = VariableSetService.getValue(this.pzTable, rowIndex, 'pz_vat');
    				var vatValue = VariableSetService.getValue(this.pzTable, rowIndex, 'pz_wartosc_vat_fk');
    				var netValue = VariableSetService.getValue(this.pzTable, rowIndex, 'pz_wartosc_fk');
    			
	    			if (vat != null && vat != '')
	    			{
	    				if(tmpTable[vat] == null) 
						{
	    					tmpTable[vat] = new Array();
							tmpTable[vat]['vatValue']= new Decimal(vatValue).toDecimalPlaces(2).toNumber();
							tmpTable[vat]['netValue']= new Decimal(netValue).toDecimalPlaces(2).toNumber();
							tmpTableKeys.push(vat);
						}
	    				else
						{
							tmpTable[vat]['vatValue'] = tmpTable[vat]['vatValue'] + new Decimal(vatValue).toDecimalPlaces(2).toNumber();
							tmpTable[vat]['netValue'] = tmpTable[vat]['netValue'] + new Decimal(netValue).toDecimalPlaces(2).toNumber();
						}
	    			}
        		}

    		}
  			
  			var vatAmountSum = new Decimal(0).toDecimalPlaces(2).toNumber();
    		for(var key of tmpTableKeys) 
    		{
    			newRow['vat'] = key;
    			newRow['kwota_vat'] = tmpTable[key]['vatValue'];
    			newRow['kwota_netto'] = tmpTable[key]['netValue'];
    			newRow['kwota_net_w_pln'] = new Decimal(tmpTable[key]['netValue'] * currencyExchangeRate).toDecimalPlaces(2).toNumber();
    			VariableSetService.addRow(this.summaringTable, false, newRow);
    			
    			vatAmountSum = vatAmountSum + tmpTable[key]['vatValue'];
    		}
    		VariableService.setValue('suma_kwoty_vat', new Decimal(vatAmountSum).toDecimalPlaces(2).toNumber());
    	}
    	catch(oError) 
    	{
    		Logger.error(Action.t("action.fill-in-summary-table.fill-in-table-error", oError));
     	    MessageService.showFailure(Action.t("action.fill-in-summary-table.fill-in-table-error", oError));
    	}
    	finally
    	{
    		VariableSetService.save(this.summaringTable);
    	}
    }
});