/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.tasks;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.client.common.Categories;
import com.suncode.client.db.models.QADDecreeDataModel;
import com.suncode.client.db.models.QADHeaderDataModel;
import com.suncode.client.db.models.QADPZDecreeDataModel;
import com.suncode.client.db.services.QADDataService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class QADBooking {
    private static Logger log = LoggerFactory.getLogger(QADBooking.class);
    private static final String PZ_INVOICE_TYPE = "Magazynowa";
    private static final String PAYMENT_TYPE_CARD = "Karta p\u0142atnicza s\u0142u\u017cbowa";
    @Autowired
    private ActivityService activityService;
    @Autowired
    private QADDataService qadDataService;
    @Autowired
    private UserService userService;
    @Autowired
    private CommentService commentService;
    private final String[] DECREE_CO_IDS = new String[]{"lp", "konto", "subkonto", "mpk", "projekt", "uzycie_podatku", "klasa_vat", "wartosc_netto_na_linii", "wartosc_netto_w_pln_na", "opis_linii"};
    private final String[] PZ_DECREE_CO_IDS = new String[]{"pz_numer_zz", "pz_nr", "pz_nr_linii", "pz_data", "pz_magazyn", "pz_jm", "pz_indeks", "pz_nazwa", "pz_ilosc_fk", "pz_cena_fk", "pz_wartosc_fk", "pz_vat", "pz_wartosc_vat_fk", "pz_id"};

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("qad-booking-app-id")).name("application.qad-booking.name")).description("application.qad-booking.desc")).category(new Category[]{Categories.INVOICES})).icon((Icon)SilkIconPack.APPLICATION)).create();
    }

    public void execute(ApplicationContext context) {
        log.debug("************************* QADBooking() ********************");
        String processId = context.getProcessId();
        String activityId = context.getActivityId();
        Map contextMap = this.activityService.getActivityContext(processId, activityId);
        String identifier = (String)contextMap.get("identyfikator");
        String invoiceType = (String)contextMap.get("rodzaj_faktury");
        try {
            QADHeaderDataModel foundHeader;
            this.exportCostDecree(identifier, contextMap);
            if (StringUtils.equals((CharSequence)invoiceType, (CharSequence)PZ_INVOICE_TYPE)) {
                this.exportPZDecree(identifier, contextMap);
            }
            if ((foundHeader = this.qadDataService.getHeaderByIdentifier(identifier)) == null) {
                QADHeaderDataModel qadHModel = new QADHeaderDataModel();
                this.prepareHeaderData(qadHModel, contextMap);
                this.qadDataService.saveHeader(qadHModel);
                log.info("Zapisano nag\u0142\u00f3wek QAD: " + qadHModel.toString());
            } else {
                this.prepareHeaderData(foundHeader, contextMap);
                this.qadDataService.updateHeader(foundHeader);
                log.info("Zaktualizowano nag\u0142\u00f3wek QAD: " + foundHeader.toString());
            }
        }
        catch (Exception e) {
            QADHeaderDataModel foundHeader;
            List<QADPZDecreeDataModel> foundPZDecree;
            log.debug("Wyst\u0105pi\u0142 b\u0142\u0105d podczas zapisu dnaych w tabeli QAD: " + e.getMessage());
            Comment comment = new Comment();
            comment.setActivityId(activityId);
            comment.setProcessId(processId);
            comment.setTimestamp(Long.valueOf(DateTime.now().getMillis()));
            comment.setUserId("admin");
            comment.setComment("Wyst\u0105pi\u0142 b\u0142\u0105d podczas zapisu dnaych w tabeli QAD: " + e.getMessage() + ". Skontaktuj si\u0119 z administratorem.");
            this.commentService.createComment(comment);
            List<QADDecreeDataModel> foundDecree = this.qadDataService.getDecreeRowsByIdentifier(identifier);
            if (foundDecree != null) {
                for (QADDecreeDataModel qadDecreeDataModel : foundDecree) {
                    this.qadDataService.deleteDecree(qadDecreeDataModel);
                }
            }
            if (StringUtils.equals((CharSequence)invoiceType, (CharSequence)PZ_INVOICE_TYPE) && (foundPZDecree = this.qadDataService.getPZDecreeRowsByIdentifier(identifier)) != null) {
                for (QADPZDecreeDataModel qadPZDecreeDataModel : foundPZDecree) {
                    this.qadDataService.deletePZDecree(qadPZDecreeDataModel);
                }
            }
            if ((foundHeader = this.qadDataService.getHeaderByIdentifier(identifier)) != null) {
                this.qadDataService.deleteHeader(foundHeader);
            }
            throw e;
        }
    }

    private void exportCostDecree(String identifier, Map<String, Object> contextMap) {
        List costDecree = DynamicTableFunctions.convertFromMapToListOfMaps(contextMap, (String[])this.DECREE_CO_IDS);
        for (Map row : costDecree) {
            Integer index = Integer.valueOf((String)row.get("lp"));
            QADDecreeDataModel foundDecreeRow = this.qadDataService.getDecreeRowByIdentifierAndIndex(identifier, index);
            if (foundDecreeRow == null) {
                QADDecreeDataModel qadDModel = new QADDecreeDataModel();
                this.prepareDecreeRowData(qadDModel, contextMap, row, index);
                this.qadDataService.saveDecree(qadDModel);
                log.info("Zapisano wiersz QAD: " + qadDModel.toString());
                continue;
            }
            this.prepareDecreeRowData(foundDecreeRow, contextMap, row, index);
            this.qadDataService.updateDecree(foundDecreeRow);
            log.info("Zaktualizowano wiersz QAD: " + foundDecreeRow.toString());
        }
    }

    private void exportPZDecree(String identifier, Map<String, Object> contextMap) {
        List pzDecree = DynamicTableFunctions.convertFromMapToListOfMaps(contextMap, (String[])this.PZ_DECREE_CO_IDS);
        for (Map row : pzDecree) {
            Long pzId = Long.valueOf((String)row.get("pz_id"));
            QADPZDecreeDataModel foundPZDecreeRow = this.qadDataService.getPZDecreeRowByIdentifierAndPZId(identifier, pzId);
            if (foundPZDecreeRow == null) {
                QADPZDecreeDataModel qadPZModel = new QADPZDecreeDataModel();
                this.preparePZDecreeRowData(qadPZModel, contextMap, row, pzId);
                this.qadDataService.savePZDecree(qadPZModel);
                log.info("Zapisano wiersz PZ w QAD: " + qadPZModel.toString());
                continue;
            }
            this.preparePZDecreeRowData(foundPZDecreeRow, contextMap, row, pzId);
            this.qadDataService.updatePZDecree(foundPZDecreeRow);
            log.info("Zaktualizowano wiersz PZ w QAD: " + foundPZDecreeRow.toString());
        }
    }

    private void prepareDecreeRowData(QADDecreeDataModel qadDModel, Map<String, Object> contextMap, Map<String, String> row, Integer index) {
        String hIdentyfikator = (String)contextMap.get("identyfikator");
        qadDModel.setIdentyfikator(hIdentyfikator);
        qadDModel.setNrLinii(index);
        qadDModel.setKonto(row.get("konto"));
        qadDModel.setSubkonto(row.get("subkonto"));
        qadDModel.setMpk(row.get("mpk"));
        qadDModel.setProjekt(row.get("projekt"));
        qadDModel.setKodUzyciaPodatku(row.get("uzycie_podatku"));
        qadDModel.setKlasaVat(row.get("klasa_vat"));
        qadDModel.setOpisLinii(row.get("opis_linii"));
        Double dWartoscNetto = Double.valueOf(row.get("wartosc_netto_na_linii"));
        qadDModel.setWartoscNetto(dWartoscNetto);
        Double dWartoscNettoWPLN = Double.valueOf(row.get("wartosc_netto_w_pln_na"));
        qadDModel.setWartoscNettoWPLN(dWartoscNettoWPLN);
        String hWaluta = (String)contextMap.get("waluta");
        qadDModel.setWaluta(hWaluta);
        qadDModel.setStatusDoQAD("ACT");
        qadDModel.setDataWpisu(Timestamp.valueOf(LocalDateTime.now()));
    }

    private void preparePZDecreeRowData(QADPZDecreeDataModel qadPZDModel, Map<String, Object> contextMap, Map<String, String> row, Long pzId) {
        String hIdentyfikator = (String)contextMap.get("identyfikator");
        qadPZDModel.setIdentyfikator(hIdentyfikator);
        qadPZDModel.setPzId(pzId);
        Integer iNrLinii = Integer.valueOf(row.get("pz_nr_linii"));
        qadPZDModel.setNrLinii(iNrLinii);
        qadPZDModel.setNumerZZ(row.get("pz_numer_zz"));
        qadPZDModel.setNrPZ(row.get("pz_nr"));
        Double dIloscNaFakturze = Double.valueOf(row.get("pz_ilosc_fk"));
        qadPZDModel.setIloscNaFakturze(dIloscNaFakturze);
        Double dCenaNaFakturze = Double.valueOf(row.get("pz_cena_fk"));
        qadPZDModel.setCenaNaFakturze(dCenaNaFakturze);
        BigDecimal biStawkaVat = new BigDecimal(row.get("pz_vat"));
        qadPZDModel.setStawkaVATNaFakturze(biStawkaVat);
        qadPZDModel.setStatusDoQAD("ACT");
        qadPZDModel.setDataWpisu(Timestamp.valueOf(LocalDateTime.now()));
    }

    private void prepareHeaderData(QADHeaderDataModel qadHModel, Map<String, Object> contextMap) {
        String hKorekta;
        String hIdentyfikator = (String)contextMap.get("identyfikator");
        qadHModel.setIdentyfikator(hIdentyfikator);
        String hKodKreskowy = (String)contextMap.get("kod_kreskowy");
        qadHModel.setKodKreskowy(hKodKreskowy);
        String hNrSegregatora = (String)contextMap.get("nr_segregatora");
        qadHModel.setNrSegregatora(hNrSegregatora);
        String hKodDostawcy = (String)contextMap.get("kod_dostawcy");
        qadHModel.setKodDostawcy(hKodDostawcy);
        String hNrFaktury = (String)contextMap.get("nr_faktury");
        qadHModel.setNumerFaktury(hNrFaktury);
        String hNrFakturyKsef = (String)contextMap.get("numerfaksef");
        Date hDataGenerowaniaFakturyKsef = (Date)contextMap.get("data_wplywu_do_ksef");
        if (StringUtils.isNotEmpty((CharSequence)hNrFakturyKsef)) {
            qadHModel.setNumerFakturyKSeF(hNrFakturyKsef);
            qadHModel.setDataWygenerowaniaFakturyKSeF(new Timestamp(hDataGenerowaniaFakturyKsef.getTime()));
        }
        Boolean hCzyKorekta = StringUtils.equals((CharSequence)(hKorekta = (String)contextMap.get("korekta")), (CharSequence)"TAK");
        qadHModel.setCzyKorekta(hCzyKorekta);
        String hNrFakturyPierowtnej = (String)contextMap.get("nr_faktury_pierwotnej");
        qadHModel.setNrFakturyPierwotnej(hNrFakturyPierowtnej);
        String hDataKsiegowania = (String)contextMap.get("data_ksiegowania");
        qadHModel.setDataKsiegowania(DateTime.parse((String)hDataKsiegowania).toDate());
        String hDataPodatkuVAT = (String)contextMap.get("data_podatku_vat");
        qadHModel.setDataPodatku(DateTime.parse((String)hDataPodatkuVAT).toDate());
        String hDataWystawieniaFaktury = (String)contextMap.get("data_wystawienia_faktur");
        qadHModel.setDataFaktury(DateTime.parse((String)hDataWystawieniaFaktury).toDate());
        String hWarunekPlatnosci = (String)contextMap.get("warunek_platnosci");
        qadHModel.setWarunekPlatnosci(hWarunekPlatnosci);
        String hTerminPlatnosci = (String)contextMap.get("termin_platnosci");
        qadHModel.setTerminPlatnosci(DateTime.parse((String)hTerminPlatnosci).toDate());
        String hMetodaPlatnosci = (String)contextMap.get("metoda_platnosci");
        qadHModel.setMetodaPlatnosci(hMetodaPlatnosci);
        if (StringUtils.equals((CharSequence)hMetodaPlatnosci, (CharSequence)PAYMENT_TYPE_CARD) && contextMap.containsKey("kod_posiadacz_karty_slu")) {
            String hKodPlatnikaKarta = (String)contextMap.get("kod_posiadacz_karty_slu");
            qadHModel.setKodPlatnikaKarta(hKodPlatnikaKarta);
        }
        String hNrRachunku = (String)contextMap.get("nr_rachunku");
        qadHModel.setNrRachunku(hNrRachunku);
        String hNrRachunkuVAT = (String)contextMap.get("nr_rachunku_dla_vat_w_p");
        qadHModel.setNrRachunkuVAT(hNrRachunkuVAT);
        String hNrWnioskuDotacji = (String)contextMap.get("numer_wniosku");
        qadHModel.setNrWnioskuDotacji(hNrWnioskuDotacji);
        String hRodzajFaktury = (String)contextMap.get("rodzaj_faktury");
        qadHModel.setRodzajFaktury(hRodzajFaktury);
        String hTypFaktury = (String)contextMap.get("typ_faktury");
        qadHModel.setTypFaktury(hTypFaktury);
        String hRodzajKosztu = (String)contextMap.get("rodzaj_kosztu");
        qadHModel.setRodzajKosztu(hRodzajKosztu);
        if (StringUtils.equals((CharSequence)hRodzajFaktury, (CharSequence)PZ_INVOICE_TYPE)) {
            String hCzyFunduszOchronyRolnictwa = (String)contextMap.get("fundusz_ochrony_rolnict");
            if (StringUtils.equalsIgnoreCase((CharSequence)hCzyFunduszOchronyRolnictwa, (CharSequence)"TAK")) {
                qadHModel.setCzyFunduszOchronySrodowiska(true);
            } else {
                qadHModel.setCzyFunduszOchronySrodowiska(false);
            }
        }
        String hLoginKsiegujacego = (String)contextMap.get("ksiegujacy_fakt_kosz_lo");
        String hEmeilKsiegujacego = this.getEmailByUserName(hLoginKsiegujacego);
        qadHModel.setEmailKsiegujacego(hEmeilKsiegujacego);
        String hWaluta = (String)contextMap.get("waluta");
        qadHModel.setWaluta(hWaluta);
        Double hkwotaNettoWWalucie = (Double)contextMap.get("kwota_netto_w_walucie");
        qadHModel.setWartoscNettoWWalucie(hkwotaNettoWWalucie);
        Double hkwotaBruttoWWalucie = (Double)contextMap.get("kwota_brutto_w_walucie");
        qadHModel.setWartoscBruttoWWalucie(hkwotaBruttoWWalucie);
        Double hsumaKwotyVAT = (Double)contextMap.get("suma_kwoty_vat");
        qadHModel.setWartoscVatWPLN(hsumaKwotyVAT);
        Double hKursWaluty = (Double)contextMap.get("kurs_waluty");
        qadHModel.setKursWaluty(hKursWaluty);
        String hMPP = (String)contextMap.get("mpp");
        Boolean hCzyMPP = StringUtils.equals((CharSequence)hMPP, (CharSequence)"TAK");
        qadHModel.setCzyMetodaPodzielonejPlatnosci(hCzyMPP);
        String hSplitPayment = (String)contextMap.get("split_payment");
        Boolean hCzySplitPayment = StringUtils.equals((CharSequence)hSplitPayment, (CharSequence)"TAK");
        qadHModel.setCzySplitPayment(hCzySplitPayment);
        String hBedzieKorekta = (String)contextMap.get("bedzie_korekta");
        Boolean hCzyBedzieKorekta = StringUtils.equals((CharSequence)hBedzieKorekta, (CharSequence)"TAK");
        qadHModel.setCzyBedzieKorekta(hCzyBedzieKorekta);
        Double hDoZaplatyWWalucie = (Double)contextMap.get("do_zaplaty_w_walucie");
        qadHModel.setWartoscDoZaplatyWWalucie(hDoZaplatyWWalucie);
        Double hKwotaSporna = (Double)contextMap.get("kwota_sporna");
        qadHModel.setKwotaSporna(hKwotaSporna);
        Double hKwotaZaplacona = (Double)contextMap.get("kwota_zaplacona");
        qadHModel.setWartoscZaplacona(hKwotaZaplacona);
        qadHModel.setStatusDoQAD("ACT");
        qadHModel.setStatusPlatnosciQAD("NA");
        qadHModel.setStatusDekretacjiQAD("NA");
        qadHModel.setDataWpisu(Timestamp.valueOf(LocalDateTime.now()));
    }

    private String getEmailByUserName(String hLoginKsiegujacego) {
        String email = "";
        User user = this.userService.getUser(hLoginKsiegujacego, new String[0]);
        if (user != null && StringUtils.isNotBlank((CharSequence)user.getEmail())) {
            email = user.getEmail();
        }
        return email;
    }
}

