/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.tasks;

import com.suncode.client.common.Categories;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class FindMatrixUsersList {
    private static Logger log = LoggerFactory.getLogger(FindMatrixUsersList.class);
    @Autowired
    private UserService userService;
    @Autowired
    private SQLFinder sqlFinder;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("find-matrix-user-list-app-id")).name("application.find-matrix-user-list.name")).description("application.find-matrix-user-list.desc")).category(new Category[]{Categories.INVOICES})).icon((Icon)SilkIconPack.APPLICATION)).parameter().id("query").name("application.find-matrix-user-list.query.name").description("application.find-matrix-user-list.query.desc").type((Type)Types.STRING).create()).parameter().id("resultColumnId").name("application.find-matrix-user-list.resultColumnId.name").description("application.find-matrix-user-list.resultColumnId.desc").type((Type)Types.STRING).create()).parameter().id("resultVariable").name("application.find-matrix-user-list.resultVariable.name").description("application.find-matrix-user-list.resultVariable.desc").type((Type)Types.VARIABLE).create();
    }

    public void execute(@Param String query, @Param String resultColumnId, @Param Variable resultVariable, ApplicationContext context) {
        log.debug("************************* FindMatrixUsersList() ********************");
        StringBuffer result = new StringBuffer("");
        try {
            this.validateResultColumn(query, resultColumnId);
            HashSet<String> usersWithoutDuplicates = new HashSet<String>();
            List<Map<String, Object>> queryResults = this.getQueryResults(query);
            for (Map<String, Object> row : queryResults) {
                String[] userIds;
                Object objValue = row.get(resultColumnId);
                if (objValue == null) continue;
                for (String userId : userIds = StringUtils.split((String)StringUtils.deleteWhitespace((String)String.valueOf(objValue)), (String)";")) {
                    log.debug("userId: " + userId);
                    User user = this.userService.getUser(userId, new String[0]);
                    if (user == null || !usersWithoutDuplicates.add(user.getUserName())) continue;
                    if (result.length() == 0) {
                        result.append(user.getUserName());
                        continue;
                    }
                    result.append(";").append(user.getUserName());
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            resultVariable.setValue((Object)result.toString());
            log.debug("Result: " + result.toString());
        }
    }

    private void validateResultColumn(String query, String resultColumnId) {
        String resultColumn = StringUtils.substringBetween((String)StringUtils.lowerCase((String)query), (String)"select", (String)"from");
        if (!StringUtils.equals((String)resultColumn.trim(), (String)resultColumnId)) {
            throw new IllegalArgumentException("B\u0142\u0119dnie okre\u015blono nazw\u0119 zwracanej kolumny. Pomi\u0119dzy select a from musi wystapi\u0107 warto\u015b\u0107 " + resultColumnId);
        }
    }

    private List<Map<String, Object>> getQueryResults(String query) {
        List result = null;
        try {
            SQLBuilder sqlBuilder = new SQLBuilder();
            sqlBuilder.setQuery(query);
            result = this.sqlFinder.find(sqlBuilder);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Nieprawid\u0142owe zapytanie: ", e);
        }
        return result;
    }
}

