/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.plannedtasks;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.client.common.Categories;
import com.suncode.client.db.models.QADDecreeDataModel;
import com.suncode.client.db.models.QADHeaderDataModel;
import com.suncode.client.db.models.QADPZDecreeDataModel;
import com.suncode.client.db.models.QADRRHeaderDataModel;
import com.suncode.client.db.models.QADResponseDecreeDataModel;
import com.suncode.client.db.services.QADDataService;
import com.suncode.client.db.services.QADRRDataService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.administration.scheduledtask.context.ProgressHolder;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class CheckQADBookAndPaymentState {
    private static Logger log = Logger.getLogger(CheckQADBookAndPaymentState.class);
    private static final String BOOK_WAITING_ACT_DEF_ID = "oczekiwanie_na_ksiegowanie_w_qad";
    private static final String PAYMENT_WAITING_ACT_DEF_ID = "oczekiwanie_na_potwierdzenie_platnosci";
    private static final String PAYMENT_RR_WAITING_ACT_DEF_ID = "oczekiwanie_na_potwierdzenie_platnosci_rr";
    private static final String IDENTIFIER_VAR_ID = "identyfikator";
    private static final String NOT_BOOKED_STATE = "NIEZAKSI\u0118GOWANE";
    private static final String BOOKED_STATE = "ZAKSI\u0118GOWANE";
    private static final String PZ_INVOICE_TYPE = "Magazynowa";
    private static final SimpleDateFormat dateFromat = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private QADDataService qadDataService;
    @Autowired
    private QADRRDataService qadRRDataService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private CommentService commentService;
    @Autowired
    private ProcessService processService;
    private final String[] RESPONSE_QAD_DECREE_COLUM_IDS = new String[]{"tqad_lp", "tqad_konto", "tqad_subkonto", "tqad_mpk", "tqad_projekt", "tqad_opis_linii", "tqad_wartosc_netto_w_wa", "tqad_wartosc_netto_pln", "tqad_waluta", "tqad_komentarz_bledu"};

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("check-qad-booking-and-payment-state-sheduled-task-id")).name("scheduled-task.check-qad-booking-and-payment-state.name")).description("scheduled-task.check-qad-booking-and-payment-state.desc")).category(new Category[]{Categories.INVOICES})).cancelable().create();
    }

    public void execute(CancelationHandler cancelationHandler, Logger logger, ProgressHolder progressHolder) throws Exception {
        logger.info((Object)"Weryfikacja status\u00f3w p\u0142atno\u015bci");
        progressHolder.setProgress(Double.valueOf(0.0));
        int paymentWaitingActivitiesCounter = 0;
        List<Activity> paymentWaitingActivities = this.findOpenActivityByActivityDefId(PAYMENT_WAITING_ACT_DEF_ID);
        for (Activity paymentWaitingActivity : paymentWaitingActivities) {
            this.checkPaymentStatus(paymentWaitingActivity, cancelationHandler, logger);
            progressHolder.setProgress(Double.valueOf(0.33 * (double)paymentWaitingActivitiesCounter++ / (double)paymentWaitingActivities.size()));
        }
        progressHolder.setProgress(Double.valueOf(0.33));
        logger.info((Object)"Weryfikacja status\u00f3w p\u0142atno\u015bci (RR)");
        int paymentRRWaitingActivitiesCounter = 0;
        List<Activity> paymentRRWaitingActivities = this.findOpenActivityByActivityDefId(PAYMENT_RR_WAITING_ACT_DEF_ID);
        for (Activity paymentRRWaitingActivity : paymentRRWaitingActivities) {
            this.checkPaymentRRStatus(paymentRRWaitingActivity, cancelationHandler, logger);
            progressHolder.setProgress(Double.valueOf(0.33 * (double)paymentRRWaitingActivitiesCounter++ / (double)paymentRRWaitingActivities.size() + 0.33));
        }
        progressHolder.setProgress(Double.valueOf(0.66));
        logger.info((Object)"Weryfikacja status\u00f3w ksi\u0119gowania");
        int bookWaitingActivitiesCounter = 0;
        List<Activity> bookWaitingActivities = this.findOpenActivityByActivityDefId(BOOK_WAITING_ACT_DEF_ID);
        for (Activity bookWaitingActivity : bookWaitingActivities) {
            this.checkBookStatus(bookWaitingActivity, cancelationHandler, logger);
            progressHolder.setProgress(Double.valueOf(0.33 * (double)bookWaitingActivitiesCounter++ / (double)bookWaitingActivities.size() + 0.66));
        }
        progressHolder.setProgress(Double.valueOf(1.0));
    }

    private void checkBookStatus(Activity bookWaitingActivity, CancelationHandler cancelationHandler, Logger logger) {
        String processId = bookWaitingActivity.getProcessId();
        String activityId = bookWaitingActivity.getActivityId();
        if (!cancelationHandler.isCanceled().booleanValue()) {
            Map contextMap = this.activityService.getActivityContext(processId, activityId);
            String identifier = (String)contextMap.get(IDENTIFIER_VAR_ID);
            contextMap.put("komentarz_bledu_z_qad", "");
            this.clearResponseDecreeTable(contextMap);
            QADHeaderDataModel foundResponseHeader = this.qadDataService.getProcessedResponseHeaderByIdentifier(identifier);
            if (foundResponseHeader != null) {
                logger.info((Object)("Znaleziono nag\u0142\u00f3wek w tabeli pm_client_fz_zakup dla indentyfikatora: " + identifier));
                String qadHeaderState = foundResponseHeader.getStatusDekretacjiQAD();
                if (StringUtils.equals((CharSequence)qadHeaderState, (CharSequence)"ERR")) {
                    contextMap.put("status_ksiegowania", NOT_BOOKED_STATE);
                    contextMap.put("komentarz_bledu_z_qad", foundResponseHeader.getOpisBledu());
                } else {
                    contextMap.put("status_ksiegowania", BOOKED_STATE);
                }
                logger.info((Object)("Pobranie danych z tabeli pm_client_fzdk_dekret dla identyfikatora: " + identifier));
                List<QADResponseDecreeDataModel> responseDecree = this.qadDataService.getResponseDecreeRowsByIdentifier(identifier);
                if (responseDecree != null) {
                    for (QADResponseDecreeDataModel qadResponseDecreeDataModel : responseDecree) {
                        String qadDecreeState = qadResponseDecreeDataModel.getStatusDoQAD();
                        HashMap<String, String> toAdd = new HashMap<String, String>();
                        toAdd.put("tqad_lp", String.valueOf(qadResponseDecreeDataModel.getNrLinii()));
                        toAdd.put("tqad_konto", qadResponseDecreeDataModel.getKonto());
                        toAdd.put("tqad_subkonto", qadResponseDecreeDataModel.getSubkonto());
                        toAdd.put("tqad_mpk", qadResponseDecreeDataModel.getMpk());
                        toAdd.put("tqad_projekt", qadResponseDecreeDataModel.getProjekt());
                        toAdd.put("tqad_opis_linii", qadResponseDecreeDataModel.getOpisLinii());
                        toAdd.put("tqad_wartosc_netto_w_wa", String.valueOf(qadResponseDecreeDataModel.getWartoscNetto()));
                        toAdd.put("tqad_wartosc_netto_pln", String.valueOf(qadResponseDecreeDataModel.getWartoscNettoWPLN()));
                        toAdd.put("tqad_waluta", qadResponseDecreeDataModel.getWaluta());
                        if (StringUtils.equals((CharSequence)qadDecreeState, (CharSequence)"ERR")) {
                            toAdd.put("tqad_komentarz_bledu", qadResponseDecreeDataModel.getOpisBledu());
                        } else {
                            toAdd.put("tqad_komentarz_bledu", "");
                        }
                        log.debug((Object)("Dodawany wiersz do dekretu: " + String.valueOf(toAdd)));
                        contextMap.putAll(DynamicTableFunctions.addRecords((Map)contextMap, (String[])this.RESPONSE_QAD_DECREE_COLUM_IDS, toAdd));
                        qadResponseDecreeDataModel.setStatusDoQAD("FIN");
                        qadResponseDecreeDataModel.setDataOdczytu(Timestamp.valueOf(LocalDateTime.now()));
                        this.qadDataService.updateResponseDecree(qadResponseDecreeDataModel);
                        logger.debug((Object)("Dodano wiersz do tabeli dekretacji QAD: " + qadResponseDecreeDataModel.toString()));
                    }
                } else {
                    logger.error((Object)("Nie znaleziono danych do odczytu z tabeli pm_client_fzdk_dekret dla identyfikatora: " + identifier));
                    throw new IllegalArgumentException("Nie znaleziono danych do odczytu z tabeli pm_client_fzdk_dekret dla identyfikatora: " + identifier);
                }
                this.activityService.setActivityContext(processId, activityId, contextMap);
                this.processService.setProcessContext(processId, contextMap);
                foundResponseHeader.setStatusDekretacjiQAD("FIN");
                foundResponseHeader.setDataAktualizacji(Timestamp.valueOf(LocalDateTime.now()));
                this.qadDataService.updateHeader(foundResponseHeader);
                logger.debug((Object)("Zaktualizowano nag\u0142\u00f3wek dla indentyfikatora: " + identifier));
                String bookState = (String)contextMap.get("status_ksiegowania");
                if (StringUtils.equals((CharSequence)bookState, (CharSequence)NOT_BOOKED_STATE)) {
                    logger.info((Object)"Akceptacja zadania przyciskiem Odrzu\u0107.");
                    this.sendToNextActivity(activityId, processId, "odrzuc", "admin", logger);
                    logger.info((Object)"Usuwanie danych z tabel interfejsowych z powodu b\u0142\u0119du ksi\u0119gowania.");
                    String invoiceType = (String)contextMap.get("rodzaj_faktury");
                    if (StringUtils.equals((CharSequence)invoiceType, (CharSequence)PZ_INVOICE_TYPE)) {
                        logger.info((Object)"Usuwanie wpis\u00f3w wierszy w tabeli pm_client_fzp_linie_pz");
                        List<QADPZDecreeDataModel> pzDecreeRowsToDelete = this.qadDataService.getPZDecreeRowsByIdentifier(identifier);
                        if (pzDecreeRowsToDelete != null) {
                            for (QADPZDecreeDataModel qadPZDecreeDataModel : pzDecreeRowsToDelete) {
                                this.qadDataService.deletePZDecree(qadPZDecreeDataModel);
                            }
                        }
                    }
                    logger.info((Object)"Usuwanie wpis\u00f3w wierszy w tabeli pm_client_fzd_linie_zakupu");
                    List<QADDecreeDataModel> decreeRowsToDelete = this.qadDataService.getDecreeRowsByIdentifier(identifier);
                    if (decreeRowsToDelete != null) {
                        for (QADDecreeDataModel qadDecreeDataModel : decreeRowsToDelete) {
                            this.qadDataService.deleteDecree(qadDecreeDataModel);
                        }
                    }
                    logger.info((Object)"Usuwanie wpis\u00f3w wierszy w tabeli pm_client_fzdk_dekret");
                    for (QADResponseDecreeDataModel qadResponseDecreeDataModel : responseDecree) {
                        this.qadDataService.deleteResponseDecree(qadResponseDecreeDataModel);
                    }
                    logger.info((Object)"Usuwanie wpisu nag\u0142\u00f3wka w tabeli pm_client_fz_zakup");
                    this.qadDataService.deleteHeader(foundResponseHeader);
                } else {
                    logger.info((Object)"Akceptacja zadania przyciskiem Zatwierd\u017a.");
                    this.sendToNextActivity(activityId, processId, "zatwierdz", "admin", logger);
                }
            }
        }
    }

    private void checkPaymentStatus(Activity paymentWaitingActivity, CancelationHandler cancelationHandler, Logger logger) {
        String processId = paymentWaitingActivity.getProcessId();
        String activityId = paymentWaitingActivity.getActivityId();
        if (!cancelationHandler.isCanceled().booleanValue()) {
            Map contextMap = this.activityService.getActivityContext(processId, activityId);
            String identifier = (String)contextMap.get(IDENTIFIER_VAR_ID);
            contextMap.put("komentarz_bledu_z_qad", "");
            this.clearResponseDecreeTable(contextMap);
            QADHeaderDataModel foundPaymentResponseHeader = this.qadDataService.getPaymentResponseHeaderByIdentifier(identifier);
            if (foundPaymentResponseHeader != null) {
                logger.info((Object)("Znaleziono nag\u0142\u00f3wek w tabeli pm_client_fz_zakup dla indentyfikatora: " + identifier));
                logger.info((Object)("Pobranie danych z tabeli pm_client_fzdk_dekret dla identyfikatora: " + identifier));
                List<QADResponseDecreeDataModel> responseDecree = this.qadDataService.getResponseDecreeRowsByIdentifier(identifier);
                if (responseDecree != null) {
                    for (QADResponseDecreeDataModel qadResponseDecreeDataModel : responseDecree) {
                        String qadDecreeState = qadResponseDecreeDataModel.getStatusDoQAD();
                        HashMap<String, String> toAdd = new HashMap<String, String>();
                        toAdd.put("tqad_lp", String.valueOf(qadResponseDecreeDataModel.getNrLinii()));
                        toAdd.put("tqad_konto", qadResponseDecreeDataModel.getKonto());
                        toAdd.put("tqad_subkonto", qadResponseDecreeDataModel.getSubkonto());
                        toAdd.put("tqad_mpk", qadResponseDecreeDataModel.getMpk());
                        toAdd.put("tqad_projekt", qadResponseDecreeDataModel.getProjekt());
                        toAdd.put("tqad_opis_linii", qadResponseDecreeDataModel.getOpisLinii());
                        toAdd.put("tqad_wartosc_netto_w_wa", String.valueOf(qadResponseDecreeDataModel.getWartoscNetto()));
                        toAdd.put("tqad_wartosc_netto_pln", String.valueOf(qadResponseDecreeDataModel.getWartoscNettoWPLN()));
                        toAdd.put("tqad_waluta", qadResponseDecreeDataModel.getWaluta());
                        if (StringUtils.equals((CharSequence)qadDecreeState, (CharSequence)"ERR")) {
                            toAdd.put("tqad_komentarz_bledu", qadResponseDecreeDataModel.getOpisBledu());
                        } else {
                            toAdd.put("tqad_komentarz_bledu", "");
                        }
                        log.debug((Object)("Dodawany wiersz do dekretu: " + String.valueOf(toAdd)));
                        contextMap.putAll(DynamicTableFunctions.addRecords((Map)contextMap, (String[])this.RESPONSE_QAD_DECREE_COLUM_IDS, toAdd));
                        qadResponseDecreeDataModel.setStatusDoQAD("FIN");
                        qadResponseDecreeDataModel.setDataOdczytu(Timestamp.valueOf(LocalDateTime.now()));
                        this.qadDataService.updateResponseDecree(qadResponseDecreeDataModel);
                        logger.debug((Object)("Dodano wiersz do tabeli dekretacji QAD: " + qadResponseDecreeDataModel.toString()));
                    }
                } else {
                    logger.error((Object)("Nie znaleziono danych do odczytu z tabeli pm_client_fz_zakup dla identyfikatora: " + identifier));
                    throw new IllegalArgumentException("Nie znaleziono danych do odczytu z tabeli pm_client_fz_zakup dla identyfikatora: " + identifier);
                }
                contextMap.put("kwota_zaplacona", foundPaymentResponseHeader.getWartoscZaplacona());
                this.activityService.setActivityContext(processId, activityId, contextMap);
                this.processService.setProcessContext(processId, contextMap);
                foundPaymentResponseHeader.setStatusDekretacjiQAD("FIN");
                foundPaymentResponseHeader.setStatusPlatnosciQAD("FIN");
                foundPaymentResponseHeader.setDataAktualizacji(Timestamp.valueOf(LocalDateTime.now()));
                this.qadDataService.updateHeader(foundPaymentResponseHeader);
                logger.debug((Object)("Zaktualizowano nag\u0142\u00f3wek dla indentyfikatora: " + identifier));
                logger.info((Object)"Akceptacja zadania przyciskiem Zap\u0142acono.");
                this.sendToNextActivity(activityId, processId, "zaplacono", "admin", logger);
            }
        }
    }

    private void checkPaymentRRStatus(Activity paymentRRWaitingActivity, CancelationHandler cancelationHandler, Logger logger) {
        String processId = paymentRRWaitingActivity.getProcessId();
        String activityId = paymentRRWaitingActivity.getActivityId();
        if (!cancelationHandler.isCanceled().booleanValue()) {
            Map contextMap = this.activityService.getActivityContext(processId, activityId);
            String identifier = (String)contextMap.get(IDENTIFIER_VAR_ID);
            QADRRHeaderDataModel rrPaymentResponseHeader = this.qadRRDataService.getResponsePaymentRRInvoiceByIdentifier(identifier);
            if (rrPaymentResponseHeader != null) {
                logger.info((Object)("Znaleziono nag\u0142\u00f3wek w tabeli pm_client_frr_zakup dla indentyfikatora: " + identifier));
                String qadPaymentState = rrPaymentResponseHeader.getStatusPlatnosciQAD();
                logger.info((Object)("Status p\u0142atno\u015bci z QAD: " + qadPaymentState));
                if (StringUtils.equals((CharSequence)qadPaymentState, (CharSequence)"ERR")) {
                    contextMap.put("komentarz_bledu_z_qad", rrPaymentResponseHeader.getOpisBledu());
                    this.activityService.setActivityContext(processId, activityId, contextMap);
                    this.processService.setProcessContext(processId, contextMap);
                    logger.info((Object)"Akceptacja zadania przyciskiem Nie zap\u0142acono.");
                    this.sendToNextActivity(activityId, processId, "nie_zaplacono", "admin", logger);
                } else {
                    contextMap.put("kwota_zaplacona", rrPaymentResponseHeader.getWartoscZaplacona());
                    contextMap.put("data_podatku_vat", dateFromat.format(rrPaymentResponseHeader.getDataPodatku()));
                    contextMap.put("termin_platnosci", dateFromat.format(rrPaymentResponseHeader.getTerminPlatnosci()));
                    this.activityService.setActivityContext(processId, activityId, contextMap);
                    this.processService.setProcessContext(processId, contextMap);
                    logger.info((Object)"Akceptacja zadania przyciskiem Zap\u0142acono.");
                    this.sendToNextActivity(activityId, processId, "zaplacono", "admin", logger);
                }
                rrPaymentResponseHeader.setStatusPlatnosciQAD("FIN");
                rrPaymentResponseHeader.setDataAktualizacji(Timestamp.valueOf(LocalDateTime.now()));
                this.qadRRDataService.updateHeader(rrPaymentResponseHeader);
                logger.debug((Object)("Zaktualizowano nag\u0142\u00f3wek dla indentyfikatora: " + identifier));
            } else {
                logger.info((Object)("Oczekiwanie na nadanie statusu p\u0142atno\u015bci QAD dla identyfikatora: " + identifier));
            }
        }
    }

    private void clearResponseDecreeTable(Map<String, Object> contextMap) {
        contextMap.put("tqad_lp", "");
        contextMap.put("tqad_konto", "");
        contextMap.put("tqad_subkonto", "");
        contextMap.put("tqad_mpk", "");
        contextMap.put("tqad_projekt", "");
        contextMap.put("tqad_opis_linii", "");
        contextMap.put("tqad_wartosc_netto_w_wa", "");
        contextMap.put("tqad_wartosc_netto_pln", "");
        contextMap.put("tqad_waluta", "");
        contextMap.put("tqad_komentarz_bledu", "");
    }

    public List<Activity> findOpenActivityByActivityDefId(String sActivityDefId) {
        DetachedCriteria dc = DetachedCriteria.forClass(Activity.class);
        dc.add((Criterion)Restrictions.eq((String)"activityDefinitionId", (Object)sActivityDefId));
        ActivityFinder activityFinder = FinderFactory.getActivityFinder();
        List activityList = activityFinder.findByCriteria(dc);
        ArrayList<Activity> result = new ArrayList<Activity>();
        for (Activity activity : activityList) {
            if (!activity.isOpen()) continue;
            result.add(activity);
        }
        return result;
    }

    public void sendToNextActivity(String activityId, String processId, String sActionName, String sUserName, Logger logger) {
        AcceptationDefinition ad = new AcceptationDefinition(processId, activityId, sUserName, sActionName);
        ad.setIgnoreOwnerShip(Boolean.valueOf(true));
        try {
            UserContext.activate((String)sUserName);
            this.activityService.acceptActivity(ad);
        }
        catch (Exception ex) {
            logger.error((Object)("Problem podczas akceptacji zadania buforowego: " + activityId));
            logger.error((Object)("Tre\u015b\u0107 b\u0142\u0119du: " + ex.getMessage()));
            Comment comment = new Comment();
            comment.setActivityId(activityId);
            comment.setProcessId(processId);
            comment.setUserId("admin");
            comment.setTimestamp(Long.valueOf(DateTime.now().getMillis()));
            comment.setComment("Wyst\u0105pi\u0142 b\u0142\u0105d podczas automatycznej akceptacji zadania: " + ex.getMessage());
            this.commentService.createComment(comment);
            log.debug((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

