/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.db.services;

import com.suncode.client.db.models.QADDecreeDataModel;
import com.suncode.client.db.models.QADHeaderDataModel;
import com.suncode.client.db.models.QADPZDecreeDataModel;
import com.suncode.client.db.models.QADResponseDecreeDataModel;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class QADDataService {
    @Autowired
    private SessionFactory sessionFactory;

    public void saveHeader(QADHeaderDataModel data) {
        this.sessionFactory.getCurrentSession().save((Object)data);
    }

    public void updateHeader(QADHeaderDataModel data) {
        this.sessionFactory.getCurrentSession().update((Object)data);
    }

    public void deleteHeader(QADHeaderDataModel data) {
        this.sessionFactory.getCurrentSession().delete((Object)data);
    }

    public void saveDecree(QADDecreeDataModel data) {
        this.sessionFactory.getCurrentSession().save((Object)data);
    }

    public void updateDecree(QADDecreeDataModel data) {
        this.sessionFactory.getCurrentSession().update((Object)data);
    }

    public void deleteDecree(QADDecreeDataModel data) {
        this.sessionFactory.getCurrentSession().delete((Object)data);
    }

    public void savePZDecree(QADPZDecreeDataModel data) {
        this.sessionFactory.getCurrentSession().save((Object)data);
    }

    public void updatePZDecree(QADPZDecreeDataModel data) {
        this.sessionFactory.getCurrentSession().update((Object)data);
    }

    public void deletePZDecree(QADPZDecreeDataModel data) {
        this.sessionFactory.getCurrentSession().delete((Object)data);
    }

    public void saveResponseDecree(QADResponseDecreeDataModel data) {
        this.sessionFactory.getCurrentSession().save((Object)data);
    }

    public void updateResponseDecree(QADResponseDecreeDataModel data) {
        this.sessionFactory.getCurrentSession().update((Object)data);
    }

    public void deleteResponseDecree(QADResponseDecreeDataModel data) {
        this.sessionFactory.getCurrentSession().delete((Object)data);
    }

    public QADHeaderDataModel getHeaderByIdentifier(String identifier) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(QADHeaderDataModel.class);
        criteria.add(Restrictions.isNotNull((String)"identyfikator"));
        criteria.add((Criterion)Restrictions.eq((String)"identyfikator", (Object)identifier));
        ArrayList list = (ArrayList)criteria.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (QADHeaderDataModel)list.get(0);
    }

    public QADHeaderDataModel getProcessedResponseHeaderByIdentifier(String identifier) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(QADHeaderDataModel.class);
        criteria.add(Restrictions.isNotNull((String)"identyfikator"));
        criteria.add((Criterion)Restrictions.eq((String)"identyfikator", (Object)identifier));
        criteria.add((Criterion)Restrictions.eq((String)"statusDoQAD", (Object)"FIN"));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"statusDekretacjiQAD", (Object)"ACT"), (Criterion)Restrictions.eq((String)"statusDekretacjiQAD", (Object)"ERR")));
        criteria.add((Criterion)Restrictions.eq((String)"statusPlatnosciQAD", (Object)"NA"));
        ArrayList list = (ArrayList)criteria.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (QADHeaderDataModel)list.get(0);
    }

    public QADHeaderDataModel getPaymentResponseHeaderByIdentifier(String identifier) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(QADHeaderDataModel.class);
        criteria.add(Restrictions.isNotNull((String)"identyfikator"));
        criteria.add((Criterion)Restrictions.eq((String)"identyfikator", (Object)identifier));
        criteria.add((Criterion)Restrictions.eq((String)"statusDoQAD", (Object)"FIN"));
        criteria.add((Criterion)Restrictions.eq((String)"statusDekretacjiQAD", (Object)"ACT"));
        criteria.add((Criterion)Restrictions.eq((String)"statusPlatnosciQAD", (Object)"ACT"));
        ArrayList list = (ArrayList)criteria.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (QADHeaderDataModel)list.get(0);
    }

    public QADDecreeDataModel getDecreeRowByIdentifierAndIndex(String identifier, int index) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(QADDecreeDataModel.class);
        criteria.add(Restrictions.isNotNull((String)"identyfikator"));
        criteria.add((Criterion)Restrictions.eq((String)"identyfikator", (Object)identifier));
        criteria.add((Criterion)Restrictions.eq((String)"nrLinii", (Object)index));
        ArrayList list = (ArrayList)criteria.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (QADDecreeDataModel)list.get(0);
    }

    public QADPZDecreeDataModel getPZDecreeRowByIdentifierAndPZId(String identifier, Long pzId) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(QADPZDecreeDataModel.class);
        criteria.add(Restrictions.isNotNull((String)"identyfikator"));
        criteria.add((Criterion)Restrictions.eq((String)"identyfikator", (Object)identifier));
        criteria.add((Criterion)Restrictions.eq((String)"pzId", (Object)pzId));
        ArrayList list = (ArrayList)criteria.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (QADPZDecreeDataModel)list.get(0);
    }

    public List<QADDecreeDataModel> getDecreeRowsByIdentifier(String identifier) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(QADDecreeDataModel.class);
        criteria.add(Restrictions.isNotNull((String)"identyfikator"));
        criteria.add((Criterion)Restrictions.eq((String)"identyfikator", (Object)identifier));
        ArrayList list = (ArrayList)criteria.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<QADPZDecreeDataModel> getPZDecreeRowsByIdentifier(String identifier) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(QADPZDecreeDataModel.class);
        criteria.add(Restrictions.isNotNull((String)"identyfikator"));
        criteria.add((Criterion)Restrictions.eq((String)"identyfikator", (Object)identifier));
        ArrayList list = (ArrayList)criteria.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<QADResponseDecreeDataModel> getResponseDecreeRowsByIdentifier(String identifier) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(QADResponseDecreeDataModel.class);
        criteria.add(Restrictions.isNotNull((String)"identyfikator"));
        criteria.add(Restrictions.isNotNull((String)"nrLinii"));
        criteria.add((Criterion)Restrictions.eq((String)"identyfikator", (Object)identifier));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"statusDoQAD", (Object)"ACT"), (Criterion)Restrictions.eq((String)"statusDoQAD", (Object)"ERR")));
        criteria.addOrder(Order.asc((String)"nrLinii"));
        ArrayList list = (ArrayList)criteria.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }
}

