/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.datachoosers;

import com.suncode.client.common.Categories;
import com.suncode.pwfl.administration.substitution.SubstitutionService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.annotation.DataChooser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DataChooser
public class MatrixUsersList {
    private static Logger log = LoggerFactory.getLogger(MatrixUsersList.class);
    @Autowired
    private UserService userService;
    @Autowired
    private SQLFinder sqlFinder;
    @Autowired
    private SubstitutionService substitutionService;

    @Define
    public void definition(DataChooserDefinitionBuilder builder) {
        ((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)((DataChooserDefinitionBuilder)builder.id("matrix-user-list-dc-id")).name("datachooser.matrix-user-list.name")).description("datachooser.matrix-user-list.desc")).category(new Category[]{Categories.INVOICES})).icon((Icon)SilkIconPack.TEXT_PADDING_LEFT)).parameter().id("query").name("datachooser.matrix-user-list.query.name").description("datachooser.matrix-user-list.query.desc").type((Type)Types.STRING).create()).parameter().id("resultColumnId").name("datachooser.matrix-user-list.resultColumnId.name").description("datachooser.matrix-user-list.resultColumnId.desc").type((Type)Types.STRING).create()).mapping().id("fullName").name("datachooser.matrix-user-list.map-fullName.name").description("datachooser.matrix-user-list.map-fullName.desc").self().create().mapping().id("userName").name("datachooser.matrix-user-list.map-userName.name").description("datachooser.matrix-user-list.map-userName.desc").create();
    }

    public void data(@Param String query, @Param String resultColumnId, ComponentQueryData queryData, DataChooserResult result) {
        long size = 0L;
        int startItem = queryData.getPagination().getStart();
        int limit = queryData.getPagination().getLimit();
        String dcKey = queryData.getQuery();
        HashSet<String> usersWithoutDuplicates = new HashSet<String>();
        List results = new ArrayList();
        try {
            this.validateResultColumn(query, resultColumnId);
            List<Map<String, Object>> queryResults = this.getQueryResults(query);
            for (Map<String, Object> row : queryResults) {
                String[] userIds;
                Object objValue = row.get(resultColumnId);
                if (objValue == null) continue;
                for (String userId : userIds = StringUtils.split((String)StringUtils.deleteWhitespace((String)String.valueOf(objValue)), (String)";")) {
                    log.debug("userId: " + userId);
                    User user = this.userService.getUser(userId, new String[0]);
                    if (user == null) continue;
                    HashMap<String, String> userRowMap = new HashMap<String, String>();
                    if ((StringUtils.isEmpty((String)dcKey) || StringUtils.containsIgnoreCase((String)user.getFullName(), (String)dcKey)) && usersWithoutDuplicates.add(user.getUserName())) {
                        userRowMap.put("fullName", user.getFullName());
                        userRowMap.put("userName", user.getUserName());
                        results.add(userRowMap);
                    }
                    List substituteList = this.substitutionService.getSubstituteUsers(userId);
                    for (User substitute : substituteList) {
                        HashMap<String, String> substituteRowMap = new HashMap<String, String>();
                        if (!StringUtils.isEmpty((String)dcKey) && !StringUtils.containsIgnoreCase((String)substitute.getFullName(), (String)dcKey) || !usersWithoutDuplicates.add(substitute.getUserName())) continue;
                        substituteRowMap.put("fullName", substitute.getFullName());
                        substituteRowMap.put("userName", substitute.getUserName());
                        results.add(substituteRowMap);
                    }
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            int endItem = startItem + limit;
            if (endItem >= results.size()) {
                endItem = results.size();
            }
            results = results.subList(startItem, endItem);
            result.setData(results);
            result.setTotal(size);
        }
    }

    private void validateResultColumn(String query, String resultColumnId) {
        String resultColumn = StringUtils.substringBetween((String)StringUtils.lowerCase((String)query), (String)"select", (String)"from");
        if (!StringUtils.equals((String)resultColumn.trim(), (String)resultColumnId)) {
            throw new IllegalArgumentException("B\u0142\u0119dnie okre\u015blono nazw\u0119 zwracanej kolumny. Pomi\u0119dzy select a from musi wystapi\u0107 warto\u015b\u0107 " + resultColumnId);
        }
    }

    private List<Map<String, Object>> getQueryResults(String query) {
        List result = null;
        try {
            SQLBuilder sqlBuilder = new SQLBuilder();
            sqlBuilder.setQuery(query);
            result = this.sqlFinder.find(sqlBuilder);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Nieprawid\u0142owe zapytanie: ", e);
        }
        return result;
    }
}

