/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.tasks;

import com.plusmpm.CUF.util.extension.DynamicTableFunctions;
import com.suncode.client.common.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class ChangePaymentState {
    private static Logger log = LoggerFactory.getLogger(ChangePaymentState.class);
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private CommentService commentService;
    private static final String PAYMENT_WAITING_ACT_DEF_ID = "oczekiwanie_na_potwierdzenie_platnosci";
    private static final String WHO_CHANGE_PAYMENT_STATE_LOGIN = "zmieniajacy_status_logi";
    private final String[] INVOICES_TABLE_IDS = new String[]{"id_procesu", "nowy_status_platnosci", "nowa_kwota_zaplacona"};

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("change-payment-state-app-id")).name("application.change-payment-state.name")).description("application.change-payment-state.desc")).category(new Category[]{Categories.PAYMENT})).icon((Icon)SilkIconPack.APPLICATION)).create();
    }

    public void execute(ApplicationContext context) {
        log.debug("************************* ChangePaymentState() start ********************");
        Map activityContextMap = this.activityService.getActivityContext(context.getProcessId(), context.getActivityId());
        Process process = this.processService.getProcess(context.getProcessId(), new String[]{"processDefinition"});
        String userId = (String)activityContextMap.get(WHO_CHANGE_PAYMENT_STATE_LOGIN);
        List invoicesTable = DynamicTableFunctions.convertFromMapToListOfMaps((Map)activityContextMap, (String[])this.INVOICES_TABLE_IDS);
        for (Map row : invoicesTable) {
            String rowProcessId = (String)row.get("id_procesu");
            String newPaymentState = (String)row.get("nowy_status_platnosci");
            Double newPaymentAmount = Double.valueOf((String)row.get("nowa_kwota_zaplacona"));
            log.debug("Zmiana statusu p\u0142atno\u015bci dla procesu " + rowProcessId);
            List<Activity> paymenActivitiesToChange = this.findClosedActivityByActivityDefIdAndProcess(PAYMENT_WAITING_ACT_DEF_ID, rowProcessId);
            for (Activity activity : paymenActivitiesToChange) {
                Map paymentProcessContext = this.processService.getProcessContext(activity.getProcessId());
                log.debug("paymentProcessContext: " + String.valueOf(paymentProcessContext));
                Map paymentActivityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                log.debug("paymentActivityContext: " + String.valueOf(paymentActivityContext));
                paymentActivityContext.put("status_platnosci", newPaymentState);
                paymentActivityContext.put("kwota_zaplacona", newPaymentAmount);
                paymentActivityContext.put("status_procesu", paymentProcessContext.get("status_procesu"));
                this.activityService.setActivityContext(activity.getProcessId(), activity.getActivityId(), paymentActivityContext);
                this.commentService.createComment(this.getComment(activity.getProcessId(), activity.getActivityId(), userId, process.getName(), newPaymentAmount));
                paymentProcessContext.put("status_platnosci", newPaymentState);
                paymentProcessContext.put("kwota_zaplacona", newPaymentAmount);
                this.processService.setProcessContext(activity.getProcessId(), paymentProcessContext);
                log.debug("Status p\u0142atno\u015bci dla procesu " + rowProcessId + " zosta\u0142 zmieniony na " + newPaymentState);
            }
        }
        log.debug("************************* ChangePaymentState() end ********************");
    }

    private Comment getComment(String processId, String activityId, String userId, String processName, double paymentAmount) {
        Comment comment = new Comment();
        comment.setProcessId(processId);
        comment.setActivityId(activityId);
        comment.setTimestamp(Long.valueOf(new Date().getTime()));
        comment.setUserId(userId);
        comment.setComment("Zmieniono status p\u0142atno\u015bci z poziomu procesu " + processName + ". Kwota zap\u0142acona zosta\u0142a zmieniona na " + String.format("%.2f", paymentAmount));
        return comment;
    }

    private List<Activity> findClosedActivityByActivityDefIdAndProcess(String activityDefId, String processId) {
        DetachedCriteria dc = DetachedCriteria.forClass(Activity.class);
        dc.createAlias("process", "process");
        dc.add((Criterion)Restrictions.eq((String)"activityDefinitionId", (Object)activityDefId));
        dc.add((Criterion)Restrictions.eq((String)"process.processId", (Object)processId));
        ActivityFinder activityFinder = FinderFactory.getActivityFinder();
        List activityList = activityFinder.findByCriteria(dc);
        ArrayList<Activity> result = new ArrayList<Activity>();
        for (Activity activity : activityList) {
            if (activity.isOpen()) continue;
            result.add(activity);
        }
        return result;
    }
}

