/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.pz;

import com.suncode.cuf.sql.query.QueryExecutor;
import com.suncode.cuf.sql.query.SelectQuery;
import com.suncode.cuf.sql.query.type.SqlTypes;
import com.suncode.cuf.util.CufComponentFactory;
import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.api.result.CustomSaveResult;
import com.suncode.plugin.pzmodule.api.saver.record.CustomRecordSaver;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.enhydra.shark.api.SharkTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ClosePZModuleVeryfier
implements CustomRecordSaver {
    private Logger log = LoggerFactory.getLogger(ClosePZModuleVeryfier.class);
    private String VAT_LIST_QUERY = "select distinct procent from pm_client_musvat_matrix order by procent";

    public CustomSaveResult save(SharkTransaction sharkTransaction, ConfigurationDto configuration, SaveInfo saveInfo, List<Record> attachedRecords) {
        CustomSaveResult customSaveResult = new CustomSaveResult();
        customSaveResult.setSuccess(true);
        try {
            Set<BigDecimal> vatSet = this.getAlowedVatSet();
            String allowedVatList = this.getAllowedVatText(vatSet);
            this.log.debug("allowedVatList: " + allowedVatList);
            StringBuffer bf = new StringBuffer();
            for (Record record : attachedRecords) {
                BigDecimal vatProcentage = new BigDecimal((String)record.get((Object)"pz_vat"));
                if (vatSet.contains(vatProcentage)) continue;
                if (bf.length() == 0) {
                    bf.append("<b>" + String.valueOf(vatProcentage) + "</b>");
                    continue;
                }
                bf.append(", ").append("<b>" + String.valueOf(vatProcentage) + "</b>");
            }
            if (bf.length() > 0) {
                customSaveResult.setSuccess(false);
                customSaveResult.setErrorMessage("Stawki VAT " + bf.toString() + " s\u0105 nieprawid\u0142owe. Prosz\u0119 poprawi\u0107 zgodnie z poni\u017csza list\u0105 dost\u0119pnych stawek:<br>" + allowedVatList);
            }
        }
        catch (Exception e) {
            customSaveResult.setSuccess(false);
            customSaveResult.setErrorMessage("B\u0142\u0105d podczas weryfikacji stawek VAT: " + e.getMessage());
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return customSaveResult;
    }

    private String getAllowedVatText(Set<BigDecimal> vatSet) {
        StringBuffer bf = new StringBuffer("");
        for (BigDecimal value : vatSet) {
            if (bf.length() == 0) {
                bf.append("<b>" + String.valueOf(value) + "</b>");
                continue;
            }
            bf.append(", ").append("<b>" + String.valueOf(value) + "</b>");
        }
        return bf.toString();
    }

    private Set<BigDecimal> getAlowedVatSet() {
        final HashSet<BigDecimal> allowedVatSet = new HashSet<BigDecimal>();
        TransactionTemplate tt = new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager());
        tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                QueryExecutor executor = CufComponentFactory.getQueryExecutor();
                SelectQuery query = new SelectQuery();
                query.setQuery(ClosePZModuleVeryfier.this.VAT_LIST_QUERY);
                query.addScalar("procent", SqlTypes.LONG);
                List results = executor.list(query);
                ClosePZModuleVeryfier.this.log.debug("results: " + String.valueOf(results));
                if (results != null) {
                    for (Map row : results) {
                        BigDecimal vat = new BigDecimal((Long)row.get("procent"));
                        if (vat == null) continue;
                        allowedVatSet.add(vat);
                    }
                }
            }
        });
        return allowedVatSet;
    }
}

