/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.plannedtasks;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.client.common.Categories;
import com.suncode.client.db.models.QADRRDecreeDataModel;
import com.suncode.client.db.models.QADRRHeaderDataModel;
import com.suncode.client.db.services.QADRRDataService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.administration.scheduledtask.context.ProgressHolder;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.util.ProcessBuilderDefinition;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class RRInvoicesReader {
    private static Logger log = Logger.getLogger(RRInvoicesReader.class);
    private static final String FAK_DEFINITION_ID = "proces_fak";
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private QADRRDataService qadRRDataService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("rr-invoice-reader-scheduled-task-id")).name("scheduled-task.rr-invoice-reader.name")).description("scheduled-task.rr-invoice-reader.desc")).category(new Category[]{Categories.INVOICES})).cancelable().parameter().id("rrFilesPath").name("scheduled-task.rr-invoice-readert.rrFilesPath.name").type((Type)Types.STRING).create()).parameter().id("docClassName").name("scheduled-task.rr-invoice-readert.docClassName.name").type((Type)Types.STRING).create();
    }

    public void execute(@Param String rrFilesPath, @Param String docClassName, CancelationHandler cancelationHandler, Logger logger, ProgressHolder progressHolder) throws Exception {
        log.debug((Object)"************************* RRInvoicesReader() ********************");
        logger.info((Object)"Rozpocz\u0119cie odczytu faktur RR");
        try {
            List<QADRRHeaderDataModel> rrIncoices;
            logger.info((Object)("Weryfikacja klasy dokument\u00f3w o nazwie " + docClassName));
            DocumentClass documentClass = this.documentClassService.getDocumentClass(docClassName, new String[0]);
            if (documentClass == null) {
                throw new IllegalStateException("Klasa dokument\u00f3w [" + String.valueOf(documentClass) + "] nie zosta\u0142a znaleziona.");
            }
            logger.info((Object)"Weryfikacja \u015bcie\u017cki do plik\u00f3w faktur RR");
            File directory = new File(rrFilesPath);
            String[] flist = directory.list();
            if (flist == null) {
                throw new IOException("Nieprawid\u0142owa \u015bcie\u017cka do katalogu z plikami faktur RR!");
            }
            File directoryBackup = new File(rrFilesPath + "/backup");
            if (!(directoryBackup.exists() && directoryBackup.isDirectory() || !directoryBackup.mkdir())) {
                logger.debug((Object)"Katalog dla przetworzonych plik\u00f3w zosta\u0142 utworzony.");
                log.debug((Object)"Katalog dla przetworzonych plik\u00f3w zosta\u0142 utworzony.");
            }
            if ((rrIncoices = this.qadRRDataService.getReadyRRInvoices()) != null) {
                progressHolder.setProgress(Double.valueOf(0.0));
                int rrProcessedCounter = rrIncoices.size();
                boolean currentRRCounter = false;
                for (QADRRHeaderDataModel rrInvoiceHeaderData : rrIncoices) {
                    String rrId = rrInvoiceHeaderData.getIdentyfikator();
                    logger.info((Object)("Przetwarzanie faktury RR o id " + rrId));
                    List<QADRRDecreeDataModel> decreeData = this.qadRRDataService.getReadyRRDecreeRowsByIdentifier(rrId);
                    String rrFileName = rrId + ".txt";
                    File rrFile = FileUtils.getFile((File)directory, (String[])new String[]{rrId + ".txt"});
                    if (!cancelationHandler.isCanceled().booleanValue()) {
                        if (rrFile.exists() && rrFile.canRead()) {
                            logger.info((Object)("Dodanie pliku " + rrFile.getName() + " do klasy " + docClassName));
                            try {
                                this.createProcessWithDocument(documentClass, rrFile, rrInvoiceHeaderData, decreeData, logger);
                                rrInvoiceHeaderData.setStatusImportuZQAD("FIN");
                                rrInvoiceHeaderData.setDataAktualizacji(Timestamp.valueOf(LocalDateTime.now()));
                                rrInvoiceHeaderData.setDataOdczytu(Timestamp.valueOf(LocalDateTime.now()));
                                this.qadRRDataService.updateHeader(rrInvoiceHeaderData);
                                if (decreeData != null) {
                                    for (QADRRDecreeDataModel decreeRow : decreeData) {
                                        decreeRow.setStatusZQAD("FIN");
                                        decreeRow.setDataOdczytu(Timestamp.valueOf(LocalDateTime.now()));
                                        this.qadRRDataService.updateDecree(decreeRow);
                                    }
                                }
                                FileUtils.copyFileToDirectory((File)rrFile, (File)directoryBackup);
                                FileUtils.deleteQuietly((File)rrFile);
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage());
                                log.debug((Object)e.getMessage(), (Throwable)e);
                            }
                        } else {
                            logger.error((Object)("Brak pliku " + rrFileName + " w katalogu " + directory.getPath()));
                            log.debug((Object)("Brak pliku " + rrFileName + " w katalogu " + directory.getPath()));
                        }
                        progressHolder.setProgress(Double.valueOf((double)currentRRCounter / (double)(++rrProcessedCounter)));
                        continue;
                    }
                    logger.info((Object)"Anulowano");
                    progressHolder.setProgress(Double.valueOf(1.0));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
    }

    private void createProcessWithDocument(DocumentClass documentClass, File rrFile, QADRRHeaderDataModel headerData, List<QADRRDecreeDataModel> decreeData, Logger logger) throws Exception {
        ProcessBuilderDefinition definition = this.buildProcessDefinition(headerData, decreeData);
        String newProcessId = this.processService.createProcess(definition);
        if (newProcessId == null) {
            throw new Exception("Wyst\u0105pi\u0142 problem podczas tworzenia procesu faktur");
        }
        Process newProcess = this.processService.getProcess(newProcessId, new String[]{"processDefinition"});
        DocumentDefinition docDefinition = new DocumentDefinition();
        docDefinition.setDocumentClassId(documentClass.getId());
        docDefinition.setFileName(rrFile.getName());
        docDefinition.setDescription("Faktura RR");
        docDefinition.setUserName("admin");
        docDefinition.setProcessId(newProcessId);
        docDefinition.setInputStream((InputStream)new FileInputStream(rrFile));
        docDefinition.setSaveAsNewVersion(false);
        WfDocument document = this.documentService.addDocument(docDefinition);
        logger.debug((Object)("Dokument faktury RR zosta\u0142 dodany do archiwum - fileid: " + document.getId() + ", filename: " + rrFile.getName()));
        this.documentService.attachDocumentToProcess(document, "admin", newProcessId, null);
        logger.info((Object)("Dokument faktury RR zosta\u0142 dodany do procesu: " + newProcess.getName()));
    }

    private ProcessBuilderDefinition buildProcessDefinition(QADRRHeaderDataModel headerData, List<QADRRDecreeDataModel> decreeData) {
        ProcessBuilderDefinition pbd = new ProcessBuilderDefinition();
        pbd.setAutoStart(true);
        pbd.setPackageId(XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(FAK_DEFINITION_ID));
        pbd.setProcessDefId(FAK_DEFINITION_ID);
        String username = SystemProperties.getString((String)"SchedulerToolAgent.sharkUsername");
        pbd.setCreator(username);
        String password = SystemProperties.getPassword((String)"AdminPassword");
        pbd.setCreatorPassword(password);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("Initiator", "admin");
        variables.put("status_procesu", "W OBIEGU");
        variables.put("proces_tworzony_automat", true);
        variables.put("faktura_rr", true);
        variables.put("identyfikator", headerData.getIdentyfikator());
        variables.put("nr_faktury", headerData.getNumerFaktury());
        variables.put("rodzaj_faktury", "RR");
        variables.put("typ_faktury", "RR");
        variables.put("data_wystawienia_faktur", headerData.getDataFaktury());
        variables.put("data_dostawywykonania_u", headerData.getDataDostawy());
        variables.put("data_wplywu_faktury", headerData.getDataFaktury());
        variables.put("data_podatku_vat", headerData.getDataPodatku());
        variables.put("data_ksiegowania_rr", headerData.getDataKsiegowania());
        variables.put("kod_dostawcy", headerData.getKodDostawcy());
        variables.put("waluta", headerData.getWaluta());
        variables.put("kwota_netto_w_walucie", headerData.getWartoscNettoWWalucie());
        variables.put("kwota_brutto_w_walucie", headerData.getWartoscBruttoWWalucie());
        variables.put("kurs_waluty", headerData.getKursWaluty());
        variables.put("do_zaplaty_w_walucie", headerData.getWartoscDoZaplatyWWalucie());
        variables.put("kwota_sporna", headerData.getKwotaSporna());
        variables.put("metoda_platnosci", headerData.getMetodaPlatnosci());
        variables.put("warunek_platnosci", headerData.getWarunekPlatnosci());
        variables.put("termin_platnosci", headerData.getTerminPlatnosci());
        variables.put("nr_rachunku", headerData.getNrRachunku());
        variables.put("suma_kwoty_vat", headerData.getWartoscVatWPLN());
        variables.put("fundusz_pomocji_wp", headerData.getFunduszPromocjiWp());
        if (decreeData != null) {
            this.setRRDecreeData(decreeData, variables);
        }
        log.debug((Object)("variables: " + String.valueOf(variables)));
        pbd.setVariables(variables);
        return pbd;
    }

    private void setRRDecreeData(List<QADRRDecreeDataModel> decreeData, Map<String, Object> variables) {
        variables.put("tqad_lp", "");
        variables.put("tqad_konto", "");
        variables.put("tqad_subkonto", "");
        variables.put("tqad_mpk", "");
        variables.put("tqad_projekt", "");
        variables.put("tqad_opis_linii", "");
        variables.put("tqad_wartosc_netto_w_wa", "");
        variables.put("tqad_wartosc_netto_pln", "");
        variables.put("tqad_waluta", "");
        for (QADRRDecreeDataModel decreeRow : decreeData) {
            if (StringUtils.isEmpty((CharSequence)String.valueOf(variables.get("tqad_lp")))) {
                variables.put("tqad_lp", String.valueOf(decreeRow.getNrLinii()));
            } else {
                variables.put("tqad_lp", String.valueOf(variables.get("tqad_lp")) + ";" + decreeRow.getNrLinii());
            }
            if (StringUtils.isEmpty((CharSequence)String.valueOf(variables.get("tqad_konto")))) {
                variables.put("tqad_konto", String.valueOf(decreeRow.getKonto()));
            } else {
                variables.put("tqad_konto", String.valueOf(variables.get("tqad_konto")) + ";" + decreeRow.getKonto());
            }
            if (StringUtils.isEmpty((CharSequence)String.valueOf(variables.get("tqad_subkonto")))) {
                variables.put("tqad_subkonto", String.valueOf(decreeRow.getSubkonto()));
            } else {
                variables.put("tqad_subkonto", String.valueOf(variables.get("tqad_subkonto")) + ";" + decreeRow.getSubkonto());
            }
            if (StringUtils.isEmpty((CharSequence)String.valueOf(variables.get("tqad_mpk")))) {
                variables.put("tqad_mpk", String.valueOf(decreeRow.getMpk()));
            } else {
                variables.put("tqad_mpk", String.valueOf(variables.get("tqad_mpk")) + ";" + decreeRow.getMpk());
            }
            if (StringUtils.isEmpty((CharSequence)String.valueOf(variables.get("tqad_projekt")))) {
                variables.put("tqad_projekt", String.valueOf(decreeRow.getProjekt()));
            } else {
                variables.put("tqad_projekt", String.valueOf(variables.get("tqad_projekt")) + ";" + decreeRow.getProjekt());
            }
            if (StringUtils.isEmpty((CharSequence)String.valueOf(variables.get("tqad_opis_linii")))) {
                variables.put("tqad_opis_linii", String.valueOf(decreeRow.getOpisLinii()));
            } else {
                variables.put("tqad_opis_linii", String.valueOf(variables.get("tqad_opis_linii")) + ";" + decreeRow.getOpisLinii());
            }
            if (StringUtils.isEmpty((CharSequence)String.valueOf(variables.get("tqad_wartosc_netto_w_wa")))) {
                variables.put("tqad_wartosc_netto_w_wa", String.valueOf(decreeRow.getWartoscNetto()));
            } else {
                variables.put("tqad_wartosc_netto_w_wa", String.valueOf(variables.get("tqad_wartosc_netto_w_wa")) + ";" + decreeRow.getWartoscNetto());
            }
            if (StringUtils.isEmpty((CharSequence)String.valueOf(variables.get("tqad_wartosc_netto_pln")))) {
                variables.put("tqad_wartosc_netto_pln", String.valueOf(decreeRow.getWartoscNettoWPLN()));
            } else {
                variables.put("tqad_wartosc_netto_pln", String.valueOf(variables.get("tqad_wartosc_netto_pln")) + ";" + decreeRow.getWartoscNettoWPLN());
            }
            if (StringUtils.isEmpty((CharSequence)String.valueOf(variables.get("tqad_waluta")))) {
                variables.put("tqad_waluta", String.valueOf(decreeRow.getWaluta()));
                continue;
            }
            variables.put("tqad_waluta", String.valueOf(variables.get("tqad_waluta")) + ";" + decreeRow.getWaluta());
        }
    }
}

