/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.db.services;

import com.suncode.client.db.models.QADRRDecreeDataModel;
import com.suncode.client.db.models.QADRRHeaderDataModel;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class QADRRDataService {
    @Autowired
    private SessionFactory sessionFactory;

    public void updateHeader(QADRRHeaderDataModel data) {
        this.sessionFactory.getCurrentSession().update((Object)data);
    }

    public void updateDecree(QADRRDecreeDataModel data) {
        this.sessionFactory.getCurrentSession().update((Object)data);
    }

    public List<QADRRHeaderDataModel> getReadyRRInvoices() {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(QADRRHeaderDataModel.class);
        criteria.add(Restrictions.isNotNull((String)"identyfikator"));
        criteria.add((Criterion)Restrictions.eq((String)"statusImportuZQAD", (Object)"ACT"));
        ArrayList list = (ArrayList)criteria.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public QADRRHeaderDataModel getResponsePaymentRRInvoiceByIdentifier(String identifier) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(QADRRHeaderDataModel.class);
        criteria.add(Restrictions.isNotNull((String)"identyfikator"));
        criteria.add((Criterion)Restrictions.eq((String)"identyfikator", (Object)identifier));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"statusPlatnosciQAD", (Object)"ACT"), (Criterion)Restrictions.eq((String)"statusPlatnosciQAD", (Object)"ERR")));
        ArrayList list = (ArrayList)criteria.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (QADRRHeaderDataModel)list.get(0);
    }

    public List<QADRRDecreeDataModel> getReadyRRDecreeRowsByIdentifier(String identifier) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(QADRRDecreeDataModel.class);
        criteria.add(Restrictions.isNotNull((String)"identyfikator"));
        criteria.add((Criterion)Restrictions.eq((String)"identyfikator", (Object)identifier));
        criteria.add((Criterion)Restrictions.eq((String)"statusZQAD", (Object)"ACT"));
        criteria.addOrder(Order.asc((String)"nrLinii"));
        ArrayList list = (ArrayList)criteria.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }
}

