/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.tasks;

import com.suncode.client.common.Categories;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class AttachEMLFile {
    private static final String EML_DOC_CLASS_NAME = "eFaktury - EML";
    private static final String EML_DOC_CLASS_Id_INDEX = "Identyfikator e-mail";
    private Logger log = LoggerFactory.getLogger(AttachEMLFile.class);
    @Autowired
    private DocumentService documentService;
    @Autowired
    private FileFinder fileFinder;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentClassIndexFinder documentClassIndexFinder;
    @Autowired
    private CommentService commentService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("attach-eml-file-app-id")).name("application.attach-eml-file.name")).description("application.attach-eml-file.desc")).category(new Category[]{Categories.INVOICES})).icon((Icon)SilkIconPack.APPLICATION)).parameter().id("identifier").name("application.attach-eml-file.identifier.name").description("application.attach-eml-file.identifier.desc").type((Type)Types.STRING).create();
    }

    public void execute(@Param String identifier, ApplicationContext context) {
        this.log.debug("************************* AttachEMLFile() ********************");
        try {
            DocumentClass documentClass = this.documentClassService.getDocumentClass(EML_DOC_CLASS_NAME, new String[0]);
            if (documentClass == null) {
                throw new IllegalStateException("Klasa dokument\u00f3w [" + String.valueOf(documentClass) + "] nie zosta\u0142a znaleziona.");
            }
            long indexId = this.findIndexIdByCriteria(EML_DOC_CLASS_Id_INDEX, documentClass);
            HashMap<Long, String> indexes = new HashMap<Long, String>();
            indexes.put(indexId, identifier);
            this.log.debug("Wyszukwianie pliku EML dla indentyfikatora: {}" + identifier);
            List documents = this.fileFinder.findByIndexes(indexes, documentClass.getId());
            this.log.debug("Znaleziono {} plik\u00f3w", (Object)documents.size());
            for (WfFile wfFile : documents) {
                WfDocument wfDocument = this.documentService.getDocument(Long.valueOf(wfFile.getId()));
                this.documentService.attachDocumentToProcess(wfDocument, "admin", context.getProcessId(), context.getActivityId());
                this.log.debug("Dodano plik EML {} do procesu {}.", (Object)wfDocument.getFile().getFileName(), (Object)context.getProcessId());
            }
        }
        catch (Exception e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            this.addCommentAsAdmin(context.getProcessId(), context.getActivityId(), "Nie uda\u0142o si\u0119 pod\u0142aczy\u0107 za\u0142acznika EML do procesu z powodu: " + e.getMessage());
        }
    }

    private void addCommentAsAdmin(String processId, String activityId, String msg) {
        Comment comment = new Comment();
        comment.setActivityId(activityId);
        comment.setProcessId(processId);
        comment.setTimestamp(Long.valueOf(new Date().getTime()));
        comment.setUserId("admin");
        comment.setComment(msg);
        this.commentService.createComment(comment);
    }

    private Long findIndexIdByCriteria(String indexName, DocumentClass documentClass) {
        DetachedCriteria dc = DetachedCriteria.forClass(DocumentClassIndex.class);
        SimpleExpression cIndexName = Restrictions.eq((String)"name", (Object)indexName);
        SimpleExpression cIndexClassId = Restrictions.eq((String)"documentClass", (Object)documentClass);
        dc.add((Criterion)Restrictions.and((Criterion)cIndexName, (Criterion)cIndexClassId));
        List indexData = this.documentClassIndexFinder.findByCriteria(dc);
        if (indexData.size() == 0) {
            throw new IllegalStateException("Indeks [" + indexName + "] nie zosta\u0142 znaleziony w klasie " + documentClass.getName() + ".");
        }
        return ((DocumentClassIndex)indexData.get(0)).getId();
    }
}

