/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.client.setters;

import com.suncode.client.common.Categories;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.activity.ActivityDocument;
import com.suncode.pwfl.workflow.activity.ActivityDocumentService;
import com.suncode.pwfl.workflow.form.variablesetter.VariableSetterDefinitionBuilder;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@VariableSetter
public class RemoveDocumentsFromProcess {
    private final String JOIN_ACTIVITY_DOCUMENTS = "activityDocuments";
    @Autowired
    private FileService fileService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private ActivityDocumentService activityDocumentService;

    @Define
    public void definition(VariableSetterDefinitionBuilder builder) {
        ((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)((VariableSetterDefinitionBuilder)builder.id("remove-document-from-process-setter")).name("setter.remove-document-from-process.name")).description("setter.remove-document-from-process.desc")).category(new Category[]{Categories.INVOICES})).icon((Icon)SilkIconPack.PAGE_DELETE)).parameter().id("removeDocumentInfo").name("setter.setter.remove-document-from-process.removeDocumentInfo.name").type((Type)Types.VARIABLE).create()).parameter().id("excludedClassName").name("setter.setter.remove-document-from-process.excludedClassName.name").type((Type)Types.STRING).create();
    }

    public void set(@Param Variable removeDocumentInfo, @Param String excludedClassName, UserInfo userInfo, AcceptanceContext acceptanceContext) {
        SimpleDateFormat dateFromat = new SimpleDateFormat("yyyy-MM-dd");
        Assert.isTrue((removeDocumentInfo.getType() == Types.STRING ? 1 : 0) != 0, (String)("Variable " + removeDocumentInfo.getId() + " must be in STRING type only!"));
        HashSet removedDocuments = new HashSet();
        List foundDocuments = this.documentFinder.getDocumentsFromProcess(acceptanceContext.getProcessId(), new String[]{"documentClass", "documentClass"});
        DocumentClass emlDocClass = this.documentClassService.getDocumentClass(excludedClassName, new String[0]);
        Assert.isTrue((emlDocClass != null ? 1 : 0) != 0, (String)("DocumentClass " + excludedClassName + " not found!"));
        for (WfDocument wfDocument : foundDocuments) {
            if (wfDocument.getDocumentClassId() == emlDocClass.getId() && this.fileAttachedToOtherProcesses(wfDocument, acceptanceContext.getProcessId())) continue;
            HashMap<String, String> documentInfo = new HashMap<String, String>();
            documentInfo.put("date", dateFromat.format(wfDocument.getFile().getFileDate()));
            documentInfo.put("name", wfDocument.getFile().getFileName());
            documentInfo.put("class", wfDocument.getFile().getDocumentClass().getName());
            this.documentService.deleteDocument(wfDocument);
            removedDocuments.add(documentInfo);
        }
        StringBuffer bf = new StringBuffer();
        bf.append("Uzytkownik anuluj\u0105cy proces: <b>" + userInfo.getFullName().toUpperCase() + "</b> (" + userInfo.getUserName() + ")");
        int docCounter = 0;
        for (Map map : removedDocuments) {
            if (docCounter == 0) {
                bf.append("<br>Usuni\u0119te dokumenty dnia " + dateFromat.format(new Date()) + " : <br>");
            }
            if (docCounter > 0) {
                bf.append("<br>");
            }
            bf.append("Nazwa pliku <b>" + (String)map.get("name") + "</b>");
            bf.append(", Data dodania do archiwum <b>" + (String)map.get("date") + "</b>");
            bf.append(", Nazwa klasy dokument\u00f3w <b>" + (String)map.get("class") + "</b>");
            ++docCounter;
        }
        removeDocumentInfo.setValue((Object)StringUtils.left((String)bf.toString(), (int)4000));
    }

    private boolean fileAttachedToOtherProcesses(WfDocument wfDocument, String processId) {
        HashSet<String> foundProcesses = new HashSet<String>();
        WfFile wfFile = this.fileService.getFile(Long.valueOf(wfDocument.getFile().getId()), new String[]{"activityDocuments"});
        Set adSet = wfFile.getActivityDocuments();
        for (ActivityDocument ad : adSet) {
            ActivityDocument activitydocument = (ActivityDocument)this.activityDocumentService.get((Serializable)ad.getId(), new String[]{"process"});
            String currentProcessId = activitydocument.getProcess().getProcessId();
            if (StringUtils.equals((String)currentProcessId, (String)processId)) continue;
            foundProcesses.add(currentProcessId);
        }
        return foundProcesses.size() > 0;
    }
}

