package com.suncode.autoupdate.tomcat;

import java.io.File;
import java.lang.reflect.Method;

import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.ServerInfo;

import lombok.SneakyThrows;

public class Tomcat8
    extends Tomcat7
{
    @Override
    public boolean active()
    {
        return ServerInfo.getServerNumber().startsWith( "8" )
                || ServerInfo.getServerNumber().startsWith( "10" );
    }

    @SneakyThrows
    public File getRoot( Context context )
    {
        StandardContext ctx = (StandardContext) context;

        File docBase = new File( ctx.getDocBase() );
        if ( !docBase.isAbsolute() )
        {
            Host host = (Host) context.getParent();
            Method getAppBaseFileMethod = Host.class.getMethod( "getAppBaseFile" );
            File appBase = (File) getAppBaseFileMethod.invoke( host );
            return new File( appBase, docBase.getPath() );
        }
        return docBase;
    }
}
