package com.suncode.autoupdate.tomcat;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

import lombok.NonNull;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;

@RequiredArgsConstructor
public class RunJar
{
    @NonNull
    private final File source;
   
    @SneakyThrows
    public void invoke(Consumer<Class<?>> consumer) {
        ClassLoader parent = getClass().getClassLoader();
        
        String mainClass = mainClass();
        URL[] classpath = new URL[]{source.toURI().toURL()};
        try(URLClassLoader loader = new URLClassLoader( classpath, parent)) {
            Class<?> main = loader.loadClass( mainClass );
            consumer.accept( main );
        }
    }
    
    private String mainClass() throws IOException {
        try(JarInputStream jar = new JarInputStream( new FileInputStream( source ) )) {
            Manifest manifest = jar.getManifest();
            return manifest.getMainAttributes().getValue( Attributes.Name.MAIN_CLASS );
        }
    }
}
