package com.suncode.autoupdate.tomcat;

import lombok.experimental.UtilityClass;

@UtilityClass
public class Hook
{
    private static final Impl active;
    static
    {
        Tomcat7 tomcat7 = new Tomcat7();
        Tomcat8 tomcat8 = new Tomcat8();
        if ( tomcat7.active() )
        {
            active = tomcat7;
        }
        else if ( tomcat8.active() )
        {
            active = tomcat8;
        }
        else
        {
            active = null;
        }
    }

    public Impl get()
    {
        if ( active != null )
        {
            return active;
        }
        throw new IllegalStateException( "No valid tomcat hook found" );
    }
}
