/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.tomcat;

import com.suncode.autoupdate.tomcat.Bootstrap;
import com.suncode.autoupdate.tomcat.Impl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.CodeSource;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.ServerInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Tomcat7
implements Impl {
    @Override
    public boolean active() {
        return ServerInfo.getServerNumber().startsWith("7");
    }

    @Override
    public File getRoot(Context context) {
        StandardContext ctx = (StandardContext)context;
        Method getBasePath = StandardContext.class.getDeclaredMethod("getBasePath", new Class[0]);
        getBasePath.setAccessible(true);
        return new File((String)getBasePath.invoke((Object)ctx, new Object[0]));
    }

    @Override
    public Context getContext(ServletContext servletContext) {
        Field facadeContextField = ApplicationContextFacade.class.getDeclaredField("context");
        Field contextField = ApplicationContext.class.getDeclaredField("context");
        facadeContextField.setAccessible(true);
        contextField.setAccessible(true);
        return (Context)contextField.get(facadeContextField.get(servletContext));
    }

    @Override
    public boolean isHookRegisterd(ServletContext context) {
        StandardContext standardContext = (StandardContext)this.getContext(context);
        File contextFile = this.locateDefaultContextFile(standardContext);
        Document document = this.readXml(contextFile);
        return this.isAlreadyRegistered(document);
    }

    @Override
    public void registerHook(ServletContext context, InputStream bootstrapJar) {
        StandardContext standardContext = (StandardContext)this.getContext(context);
        File contextFile = this.locateDefaultContextFile(standardContext);
        this.copyToLib(bootstrapJar);
        Document document = this.readXml(contextFile);
        if (this.isAlreadyRegistered(document)) {
            return;
        }
        Element listenerEl = document.createElement("Listener");
        listenerEl.setAttribute("className", Bootstrap.class.getName());
        document.getDocumentElement().appendChild(listenerEl);
        Host host = this.getHost((Context)standardContext);
        host.setAutoDeploy(false);
        this.saveXml(document, contextFile);
    }

    private File locateDefaultContextFile(StandardContext standardContext) {
        File base = new File(System.getProperty("catalina.base"));
        File contextFile = null;
        if (standardContext.getDefaultContextXml() != null) {
            contextFile = new File(standardContext.getDefaultContextXml());
            if (!contextFile.isAbsolute()) {
                contextFile = new File(base, standardContext.getDefaultContextXml());
            }
        } else {
            contextFile = new File(base, "conf/context.xml");
        }
        if (!contextFile.exists()) {
            URL configFile = standardContext.getConfigFile();
            if (configFile != null) {
                contextFile = new File(configFile.toURI());
            } else {
                throw new RuntimeException("Context file not found: " + contextFile.getAbsolutePath());
            }
        }
        return contextFile;
    }

    private boolean isAlreadyRegistered(Document document) {
        NodeList listeners = document.getDocumentElement().getElementsByTagName("Listener");
        for (int i = 0; i < listeners.getLength(); ++i) {
            Element listener = (Element)listeners.item(i);
            if (!listener.getAttribute("className").equals(Bootstrap.class.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document readXml(File source) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        try (FileInputStream inputStream = new FileInputStream(source);){
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
    }

    private void saveXml(Document document, File output) throws TransformerFactoryConfigurationError, IOException, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        try (FileOutputStream outputStream = new FileOutputStream(output);){
            DOMSource input = new DOMSource(document);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(input, result);
        }
    }

    private Host getHost(Context context) {
        Container parent = context.getParent();
        while (parent != null) {
            if (parent instanceof Host) {
                return (Host)parent;
            }
            parent = context.getParent();
        }
        throw new IllegalStateException("Could not access Host from " + context);
    }

    private Path copyToLib(InputStream inputStream) {
        Path target;
        block5: {
            CodeSource libSource = StandardContext.class.getProtectionDomain().getCodeSource();
            if (libSource == null) {
                throw new IllegalStateException("Cant locate tomcat lib directory");
            }
            Path libDirectory = Paths.get(libSource.getLocation().toURI()).getParent();
            target = libDirectory.resolve("autoupdate-tomcat-hook.jar");
            try {
                Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                if (Files.exists(target, new LinkOption[0])) break block5;
                throw e;
            }
        }
        return target;
    }
}

