/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.tomcat;

import com.suncode.autoupdate.tomcat.Consumer;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import lombok.NonNull;

public class RunJar {
    @NonNull
    private final File source;

    public void invoke(Consumer<Class<?>> consumer) {
        ClassLoader parent = this.getClass().getClassLoader();
        String mainClass = this.mainClass();
        URL[] classpath = new URL[]{this.source.toURI().toURL()};
        try (URLClassLoader loader = new URLClassLoader(classpath, parent);){
            Class<?> main = loader.loadClass(mainClass);
            consumer.accept(main);
        }
    }

    private String mainClass() throws IOException {
        try (JarInputStream jar = new JarInputStream(new FileInputStream(this.source));){
            Manifest manifest = jar.getManifest();
            String string = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            return string;
        }
    }

    @ConstructorProperties(value={"source"})
    public RunJar(@NonNull File source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        this.source = source;
    }
}

