package com.suncode.autoupdate.tomcat;

import lombok.SneakyThrows;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;

import java.io.File;
import java.lang.reflect.Method;

public class Bootstrap
    implements LifecycleListener
{
    static {
        System.out.println("[Patcher-Bootstrap]: initialized");
    }

    @Override
    public void lifecycleEvent( LifecycleEvent event )
    {
        try
        {
            if ( event.getType().equals( Lifecycle.BEFORE_START_EVENT ) )
            {
                Object source = event.getSource();
                System.out.println(String.format("[Patcher-Bootstrap]: Caught event of type=%s source=%s", event.getType(), source.getClass().getName()));
                if ( source instanceof Context )
                {
                    bootstrap( (Context) source );
                }
            }
        }
        catch ( Throwable e )
        {
            System.out.println( "[Patcher-Bootstrap]: Unexpected error when bootstrapping: " + e.getMessage() );
            e.printStackTrace( System.out );
        }
    }

    private void bootstrap( Context context )
    {
        final File root = Hook.get().getRoot( context );
        final File patcherBin = new File( root, ".patcher/patcher.jar" );
        if ( patcherBin.exists() )
        {
            System.out.println( "[Patcher-Bootstrap]: found @" + root.getAbsolutePath() );
            RunJar run = new RunJar( patcherBin );
            run.invoke( new Consumer<Class<?>>() {
                @SneakyThrows
                public void accept( Class<?> mainClass )
                {
                    String[] args = new String[] { root.getAbsolutePath(), patcherBin.getAbsolutePath() };
                    Method main = mainClass.getMethod( "main", String[].class );
                    main.invoke( null, (Object) args );
                }
            } );
        }
        else {
            System.out.println("[Patcher-Bootstrap]: No patcher binary found on " + patcherBin.getAbsolutePath());
        }
    }
}
